
u16 agb_read_mem16(u32 adr)
{
	u16	value;
	u8 *byte_ptr;

	if(/*0x00000000 <= adr && */adr < 0x00004000)
	{
		value
		return SysRom[adr] | (SysRom[adr+1]<<8);
	}
	if(0x02000000 <= adr && adr < 0x02040000)
	{
		adr -= 0x02000000;
		return ExWRam[adr] | (ExWRam[adr + 1]<<8);
	}
	if(0x03000000 <= adr && adr < 0x03080000)
	{
		adr -= 0x03000000;
		return InWRam[adr] | (InWRam[adr + 1]<<8);
	}
	if(0x04000000 <= adr && adr < 0x04000400)
	{
		adr -= 0x04000000;
		return IoRam[adr] | (IoRam[adr + 1]<<8);
	}
	if(0x05000000 <= adr && adr < 0x05000400)
	{
		adr -= 0x05000000;
		return PalRam[adr] | (PalRam[adr + 1]<<8);
	}
	if(0x06000000 <= adr && adr < 0x06018000)
	{
		adr -= 0x06000000;
		return VRam[adr] | (VRam[adr + 1]<<8);
	}
	if(0x07000000 <= adr && adr < 0x07000400)
	{
		adr -= 0x07000000;
		return Oam[adr] | (Oam[adr + 1]<<8);
	}
	if(0x08000000 <= adr && adr < (0x08000000 + file_size)){
		adr -= 0x08000000;
		return Rom[adr] | (Rom[adr + 1]<<8);
	}

	return 0;
}

u32 agb_read_mem32(u32 adr)
{
	if(/*0x00000000 <= adr && */adr < 0x00004000){
		return (u32)(SysRom[adr] | (SysRom[adr + 1]<<8) | (SysRom[adr + 2]<<16) | (SysRom[adr + 3]<<24));
	}
	if(0x02000000 <= adr && adr < 0x02040000){
		adr -= 0x02000000;
		return (u32)(ExWRam[adr] | (ExWRam[adr + 1]<<8) | (ExWRam[adr + 2]<<16) | (ExWRam[adr + 3]<<24));
	}
	if(0x03000000 <= adr && adr < 0x03080000){
		adr -= 0x03000000;
		return (u32)(InWRam[adr] | (InWRam[adr + 1]<<8) | (InWRam[adr + 2]<<16) | (InWRam[adr + 3]<<24));
	}
	if(0x04000000<=adr && adr<0x04000400){
		adr -= 0x04000000;
		return (u32)(IoRam[adr] | (IoRam[adr + 1]<<8) | (IoRam[adr + 2]<<16) | (IoRam[adr + 3]<<24));
	}
	if(0x05000000 <= adr && adr < 0x05000400){
		adr -= 0x05000000;
		return (u32)(PalRam[adr] | (PalRam[adr + 1]<<8) | (PalRam[adr + 2]<<16) | (PalRam[adr + 3]<<24));
	}
	if(0x06000000 <= adr && adr < 0x06018000){
		adr -= 0x06000000;
		return (u32)(VRam[adr] | (VRam[adr + 1]<<8) | (VRam[adr + 2]<<16) | (VRam[adr + 3]<<24));
	}
	if(0x07000000 <= adr && adr < 0x07000400){
		adr -= 0x07000000;
		return (u32)(Oam[adr] | (Oam[adr + 1]<<8) | (Oam[adr + 2]<<16) | (Oam[adr + 3]<<24));
	}
	if(0x08000000 <= adr && adr < (0x08000000 + file_size)){
		adr -= 0x08000000;
		return (u32)(Rom[adr] | (Rom[adr + 1]<<8) | (Rom[adr + 2]<<16) | (Rom[adr + 3]<<24));
	}

	return 0;
}

_inline void DmaTransfer(u32 index)
{
	u32	count;
	u32	dma_sad, dma_dad, dma_size;
	char str[256];

	if(index == 0){
		dma_size = 0x3FFF & (IoRam[R_DM0CNT_L] | (IoRam[R_DM0CNT_L + 1]<<8));
		dma_sad	= (u32)(IoRam[R_DM0SAD] | (IoRam[R_DM0SAD + 1]<<8) | (IoRam[R_DM0SAD + 2]<<16) | (IoRam[R_DM0SAD + 3]<<24)) + 8;
		dma_sad &= 0x0FFFFFFF;	/*], 0ROM̈włȂ*/
		dma_dad	= (u32)(IoRam[R_DM0DAD] | (IoRam[R_DM0DAD + 1]<<8) | (IoRam[R_DM0DAD + 2]<<16) | (IoRam[R_DM0DAD + 3]<<24));
		dma_dad &= 0x07FFFFFF;	/*]*/
		sprintf(str, "DMA0 dad=%08Xh, sad=%08Xh, cnt=%Xh(*%dbit)", 
			dma_sad, dma_dad, dma_size, (IoRam[R_DM3CNT_H + 1] & BIT_2_)?32:16);
		console_print(str);
		if(IoRam[R_DM0CNT_H] & BIT_2_){	/*1 : 32bit - DMA Transfer Type*/
			for(count = 0; count < dma_size; count++){
				WMem32(dma_dad, RMem32(dma_sad));
				if(IoRam[R_DM0CNT_H] & BIT_5_)dma_sad -= 4;
				else dma_sad += 4;
				if(IoRam[R_DM0CNT_H] & BIT_7_)dma_dad -= 4;
				else dma_dad += 4;
			}
		}else{	/*1 : 16bit*/
			for(count = 0; count < dma_size; count++){
				WMem16(dma_dad, RMem16(dma_sad));
				if(IoRam[R_DM0CNT_H] & BIT_5_)dma_sad -= 2;
				else dma_sad += 2;
				if(IoRam[R_DM0CNT_H] & BIT_7_)dma_dad -= 2;
				else dma_dad += 2;
			}
		}
		return;
	}
	if(index == 1){
		dma_size = 0x3FFF & (IoRam[R_DM1CNT_L] | (IoRam[R_DM1CNT_L + 1]<<8));
		dma_sad	= (u32)(IoRam[R_DM1SAD] | (IoRam[R_DM1SAD + 1]<<8) | (IoRam[R_DM1SAD + 2]<<16) | (IoRam[R_DM1SAD + 3]<<24)) + 8;
		dma_sad &= 0x0FFFFFFF;	/*], 0ROM̈włȂ*/
		dma_dad	= (u32)(IoRam[R_DM1DAD] | (IoRam[R_DM1DAD + 1]<<8) | (IoRam[R_DM1DAD + 2]<<16) | (IoRam[R_DM1DAD + 3]<<24));
		dma_dad &= 0x07FFFFFF;	/*]*/
		sprintf(str, "DMA1 dad=%08Xh, sad=%08Xh, cnt=%Xh(*%dbit)", 
			dma_sad, dma_dad, dma_size, (IoRam[R_DM3CNT_H + 1] & BIT_2_)?32:16);
		console_print(str);
		if(IoRam[R_DM1CNT_H] & BIT_2_){	/*1 : 32bit - DMA Transfer Type*/
			for(count = 0; count < dma_size; count++){
				WMem32(dma_dad, RMem32(dma_sad));
				if(IoRam[R_DM1CNT_H] & BIT_5_)dma_sad -= 4;
				else dma_sad += 4;
				if(IoRam[R_DM1CNT_H] & BIT_7_)dma_dad -= 4;
				else dma_dad += 4;
			}
		}else{	/*1 : 16bit*/
			for(count = 0; count < dma_size; count++){
				WMem16(dma_dad, RMem16(dma_sad));
				if(IoRam[R_DM1CNT_H] & BIT_5_)dma_sad -= 2;
				else dma_sad += 2;
				if(IoRam[R_DM1CNT_H] & BIT_7_)dma_dad -= 2;
				else dma_dad += 2;
			}
		}
		return;
	}
	if(index == 2){
		dma_size = 0x3FFF & (IoRam[R_DM2CNT_L] | (IoRam[R_DM2CNT_L + 1]<<8));
		dma_sad	= (u32)(IoRam[R_DM2SAD] | (IoRam[R_DM2SAD + 1]<<8) | (IoRam[R_DM2SAD + 2]<<16) | (IoRam[R_DM2SAD + 3]<<24)) + 8;
		dma_sad &= 0x0FFFFFFF;	/*], 0ROM̈włȂ*/
		dma_dad	= (u32)(IoRam[R_DM2DAD] | (IoRam[R_DM2DAD + 1]<<8) | (IoRam[R_DM2DAD + 2]<<16) | (IoRam[R_DM2DAD + 3]<<24));
		dma_dad &= 0x07FFFFFF;	/*]*/
		sprintf(str, "DMA2 dad=%08Xh, sad=%08Xh, cnt=%Xh(*%dbit)", 
			dma_sad, dma_dad, dma_size, (IoRam[R_DM3CNT_H + 1] & BIT_2_)?32:16);
		console_print(str);
		if(IoRam[R_DM2CNT_H] & BIT_2_){	/*1 : 32bit - DMA Transfer Type*/
			for(count = 0; count < dma_size; count++){
				WMem32(dma_dad, RMem32(dma_sad));
				if(IoRam[R_DM2CNT_H] & BIT_5_)dma_sad -= 4;
				else dma_sad += 4;
				if(IoRam[R_DM2CNT_H] & BIT_7_)dma_dad -= 4;
				else dma_dad += 4;
			}
		}else{	/*1 : 16bit*/
			for(count = 0; count < dma_size; count++){
				WMem16(dma_dad, RMem16(dma_sad));
				if(IoRam[R_DM2CNT_H] & BIT_5_)dma_sad -= 2;
				else dma_sad += 2;
				if(IoRam[R_DM2CNT_H] & BIT_7_)dma_dad -= 2;
				else dma_dad += 2;
			}
		}
		return;
	}
	if(index == 3){
		dma_size = 0x3FFF & (IoRam[R_DM3CNT_L] | (IoRam[R_DM3CNT_L + 1]<<8));
		dma_sad	= (u32)(IoRam[R_DM3SAD] | (IoRam[R_DM3SAD + 1]<<8) | (IoRam[R_DM3SAD + 2]<<16) | (IoRam[R_DM3SAD + 3]<<24)) + 8;
		dma_sad &= 0x0FFFFFFF;	/*], 0ROM̈włȂ*/
		dma_dad	= (u32)(IoRam[R_DM3DAD] | (IoRam[R_DM3DAD + 1]<<8) | (IoRam[R_DM3DAD + 2]<<16) | (IoRam[R_DM3DAD + 3]<<24));
		dma_dad &= 0x07FFFFFF;	/*]*/
		sprintf(str, "DMA3 dad=%08Xh, sad=%08Xh, cnt=%Xh(*%dbit)", 
			dma_sad, dma_dad, dma_size, (IoRam[R_DM3CNT_H + 1] & BIT_2_)?32:16);
		console_print(str);
		if(IoRam[R_DM3CNT_H + 1] & BIT_2_){	/*1 : 32bit - DMA Transfer Type*/
			for(count = 0; count < dma_size; count++){
				WMem32(dma_dad, RMem32(dma_sad));
				if(IoRam[R_DM3CNT_H] & BIT_5_)dma_sad -= 4;
				else dma_sad += 4;
				if(IoRam[R_DM3CNT_H] & BIT_7_)dma_dad -= 4;
				else dma_dad += 4;
			}
		}else{	/*1 : 16bit*/
			for(count = 0; count < dma_size; count++){
				WMem16(dma_dad, RMem16(dma_sad));
				if(IoRam[R_DM3CNT_H] & BIT_5_)dma_sad -= 2;
				else dma_sad += 2;
				if(IoRam[R_DM3CNT_H] & BIT_7_)dma_dad -= 2;
				else dma_dad += 2;
			}
		}
		return;
	}

}
/*
_inline int WMem16(u32 adr, u16 val)
{
	u8	*pMem;

	if(0x02000000 <= adr && adr < 0x02040000)
	{
		pMem	= &ExWorkRam[adr - 0x02000000];
		*pMem	= (u8)val;
		pMem++;
		*pMem	= (u8)(val>>8);
		return 0;
	}
	if(0x03000000 <= adr && adr < 0x03080000)
	{
		pMem	= &InWorkRam[adr - 0x03000000];
		*pMem	= (u8)val;
		pMem++;
		*pMem	= (u8)(val>>8);
		return 0;
	}
	if(0x04000000 <= adr && adr < 0x04000400)
	{
		pMem	= &IoRam[adr - 0x04000000];
		*pMem	= (u8)val;
		pMem++;
		*pMem	= (u8)(val>>8);
		return 0;
	}
	if(0x05000000 <= adr && adr < 0x05000400)
	{
		pMem	= &PalRam[adr - 0x05000000];
		*pMem	= (u8)val;
		pMem++;
		*pMem	= (u8)(val>>8);
		return 0;
	}
	if(0x06000000 <= adr && adr < 0x06018000)
	{
		pMem	= &VRam[adr - 0x06000000];
		*pMem	= (u8)val;
		pMem++;
		*pMem	= (u8)(val>>8);
		return 0;
	}
	if(0x07000000 <= adr && adr < 0x07000400)
	{
		pMem	= &Oam[adr - 0x07000000];
		*pMem	= (u8)val;
		pMem++;
		*pMem	= (u8)(val>>8);
		return 0;
	}

	return 1;
}

_inline int WMem32(u32 adr, u32 val)
{
	u8	*pMem;
#ifdef	_LENDIAN_
		u32 *pmem32;
#endif

	if(0x02000000 <= adr && adr < 0x02040000){
		pMem  = &ExWorkRam[adr - 0x02000000];
		*pMem = (u8)val;
		pMem++;
		*pMem = (u8)(val>>8);
		pMem++;
		*pMem = (u8)(val>>16);
		pMem++;
		*pMem = (u8)(val>>24);
		return 0;
	}
	if(0x03000000 <= adr && adr < 0x03080000){
		pMem = &InWorkRam[adr - 0x03000000];
		*pMem = (u8)val;
		pMem++;
		*pMem = (u8)(val>>8);
		pMem++;
		*pMem = (u8)(val>>16);
		pMem++;
		*pMem = (u8)(val>>24);
		return 0;
	}
	if(0x04000000 <= adr && adr < 0x04000400){
		pMem = &IoRam[adr - 0x04000000];
#ifdef	_LENDIAN_
		pmem32 = (u32*)pMem;
		*pmem32 = val;
#else
		*pMem = (u8)val;
		pMem++;
		*pMem = (u8)(val>>8);
		pMem++;
		*pMem = (u8)(val>>16);
		pMem++;
		*pMem = (u8)(val>>24);
#endif
		return 0;
	}
	if(0x05000000 <= adr && adr < 0x05000400){
		pMem = &PalRam[adr - 0x05000000];
		*pMem = (u8)val;
		pMem++;
		*pMem = (u8)(val>>8);
		pMem++;
		*pMem = (u8)(val>>16);
		pMem++;
		*pMem = (u8)(val>>24);
		return 0;
	}
	if(0x06000000 <= adr && adr < 0x06018000){
		pMem = &VRam[adr - 0x06000000];
		*pMem = (u8)val;
		pMem++;
		*pMem = (u8)(val>>8);
		pMem++;
		*pMem = (u8)(val>>16);
		pMem++;
		*pMem = (u8)(val>>24);
		return 0;
	}
	if(0x07000000 <= adr && adr < 0x07000400){
		pMem = &Oam[adr - 0x07000000];
		*pMem = (u8)val;
		pMem++;
		*pMem = (u8)(val>>8);
		pMem++;
		*pMem = (u8)(val>>16);
		pMem++;
		*pMem = (u8)(val>>24);
		return 0;
	}

	if(adr == 0xC0DED00D){
		char str[256];
		u32	i;
		memset(str, 0, 256);
		for(i = 0; RMem8(val); i++)str[i] = RMem8(val++);
		console_print(str);
	}

	return 1;
}
*/

