
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/


inline void agb_timer(u32 clk)
{
	static const u32 Timer_table[]={1, 64, 256, 1024};
	static u32 tm0, tm1, tm2, tm3;
	u32 countup;	/*I[o[t[JE^*/
	u32 ttr;		/*^C}[WX^ꎞۑ*/

	countup = 0;

	ttr = agb_ioram[0x102];
	if(ttr & 0x80){	/*TM0_CNT ^C}[ғtO*/
		if((Timer_table[(ttr & 0x03)] - tm0) <= 0){	/*JE^*/
			agb_write_mem16(0x04000100, agb_read_mem16(0x04000100) + 1);
			tm0 -= Timer_table[(ttr & 0x03)];
			countup++;
			agb_interrupt(IRQ_TIMER0);
		}
	}
	
	ttr = agb_ioram[0x106];
	if(ttr & 0x80){	/*TM1_CNT ^C}[ғtO*/
		if((Timer_table[(ttr & 0x03)] - tm1) <= 0){
			agb_write_mem16(0x04000104, agb_read_mem16(0x04000104)+1);
			tm1 -= Timer_table[(ttr & 0x03)];
			countup++;
			/*Ⴂԍ(TM0)̃JE^I[o[t[ꍇɑ*/
			if(ttr & 0x04)agb_write_mem16(0x04000104, agb_read_mem16(0x04000104) + 1);
			agb_interrupt(IRQ_TIMER1);
		}
	}

	ttr = agb_ioram[0x10A];
	if(ttr & 0x80){	/*TM2_CNT ^C}[ғtO*/
		if((Timer_table[(ttr & 0x03)] - tm2) <= 0){
			agb_write_mem16(0x04000108, agb_read_mem16(0x04000108) + 1);
			tm2 -= Timer_table[(ttr & 0x03)];
			countup++;
			/*Ⴂԍ(TM0,TM1)̃JE^I[o[t[ꍇɑ*/
			if(ttr & 0x04)agb_write_mem16(0x04000108, agb_read_mem16(0x04000108) + 1);
			agb_interrupt(IRQ_TIMER2);
		}
	}

	ttr = agb_ioram[0x10E];
	if(ttr & 0x80){	/*TM3_CNT ^C}[ғtO*/
		if((Timer_table[(ttr & 0x03)] - tm3) <= 0){
			agb_write_mem16(0x0400010C, agb_read_mem16(0x0400010C) + 1);
			tm3 -= Timer_table[(ttr & 0x03)];
			countup++;
			/*Ⴂԍ(TM0, TM1, TM2)̃JE^I[o[t[ꍇɑ*/
			if(ttr & 0x04)agb_write_mem16(0x0400010C, agb_read_mem16(0x0400010C) + 1);
			agb_interrupt(IRQ_TIMER3);
		}
	}

}
