
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#ifndef	_EXTERNS_
#define	_EXTERNS_

#include "../include/arm7tdmi.h"
#include "../include/defines.h"

extern u8	agb_sysrom[AGB_SIZE_SYSROM];
extern u8	agb_exram[AGB_SIZE_EXRAM];
extern u8	agb_inram[AGB_SIZE_INRAM];
extern u8	agb_ioram[AGB_SIZE_IORAM];
extern u8	agb_palram[AGB_SIZE_PALRAM];
extern u8	agb_vram[AGB_SIZE_VRAM];
extern u8	agb_oam[AGB_SIZE_OAM];
extern u8	*agb_rom;

extern ARM7TDMI arm;
extern AGBIOLCD *io_lcd;
extern AGBIODMA *io_dma;
extern AGBIOTM  *io_tm;
extern AGBIOKEY *io_key;

extern u32	file_size;

extern u32	BreakPoint1;
extern u32	BreakPoint2;
extern u32	BreakPoint3;
extern u32	BreakPoint4;
extern BOOL fAutoUpdate;
extern BOOL fAutoRun;
extern BOOL fBreak;
extern BOOL fNext;
extern BOOL fFps;
extern BOOL fVsync;

extern BOOL fRegisterDlg;
extern BOOL fDisassemblerDlg;
extern BOOL fMemoryDlg;
extern BOOL fOamDlg;
extern BOOL fDispcntDlg;
extern BOOL fTraceDlg;
extern BOOL fHardioDlg;
extern BOOL fTileDlg;
extern BOOL fMapDlg;

extern u16	FrameBuffer[240 * 160];

extern u32	agb_obj_size_table[4][4][2];

extern u8 agb_read_mem8(u32 adr);
extern u16 agb_read_mem16(u32 adr);
extern u32 agb_read_mem32(u32 adr);
extern void agb_write_mem16(u32 adr, u16 val);


#endif	/*_EXTERNS_*/
