
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#ifndef	_GLOBALS_
#define	_GLOBALS_

u8	agb_sysrom[AGB_SIZE_SYSROM];
u8	agb_exram[AGB_SIZE_EXRAM];
u8	agb_inram[AGB_SIZE_INRAM];
u8	agb_ioram[AGB_SIZE_IORAM];
u8	agb_palram[AGB_SIZE_PALRAM];
u8	agb_vram[AGB_SIZE_VRAM];
u8	agb_oam[AGB_SIZE_OAM];
u8	*agb_rom;

ARM7TDMI arm;
AGBIOLCD *io_lcd = (AGBIOLCD*)&agb_ioram[0x000];
AGBIODMA *io_dma = (AGBIODMA*)&agb_ioram[0x0B0];
AGBIOTM	 *io_tm  = (AGBIOTM*)&agb_ioram[0x100];
AGBIOKEY *io_key = (AGBIOKEY*)&agb_ioram[0x130];
AGBIOIRQ *io_irq = (AGBIOIRQ*)&agb_ioram[0x200];

u32	file_size;

#ifndef	_COMMON_GLOBALS_
#define	_COMMON_GLOBALS_

u32	frame_count;
u32	frame_rate;
u32	frame_skip;
BOOL fFps;
BOOL fVsync;

#endif	/*_COMMON_GLOBALS_*/

BOOL fEnableBios;
BOOL fAutoUpdate;
BOOL fAutoRun;
BOOL fBreak;
BOOL fNext;
BOOL fTMain;

BOOL fRegisterDlg;
BOOL fDisassemblerDlg;
BOOL fMemoryDlg;
BOOL fOamDlg;
BOOL fDispcntDlg;
BOOL fTraceDlg;
BOOL fHardioDlg;
BOOL fTileDlg;
BOOL fMapDlg;

u16	FrameBuffer[240 * 160];

u32	agb_obj_size_table[4][4][2] = {
8, 8,
16, 16,
32, 32,
64, 64,

16, 8,
32, 8,
32, 16,
64, 32,

8, 16,
8, 32,
16, 32,
32, 64,
};

#ifdef	_AGBWIN32_
u32	BreakPoint1;
u32	BreakPoint2;
u32	BreakPoint3;
u32	BreakPoint4;
#endif	/*_AGBWIN32_*/

#endif	/*_GLOBALS_*/
