// DisassemblerDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "DisassemblerDlg.h"
#include "../include/hextoint.h"
#include "../include/bits.h"
#include "../include/externs.h"

#define	_AGBWIN32_
#define	DISASM_MAX	0x0FFFFFD0
#define	disasm_print(str)		\
{\
	if(m_out_file){\
		fprintf(dfp, "\n\t");\
		fprintf(dfp, &str[18]);\
	}else{\
		m_lstDisasm.AddString(str);\
	}\
}

u32 debug_pc;
char mnemonic[STR_LINE_SIZE], str_shift[STR_OFFSET_SIZE];
FILE *dfp;
#include "../gbacore/disasm_arm_def.h"
#include "../gbacore/disasm_thumb_def.h"
#include "../gbacore/disasm_arm.c"
#include "../gbacore/disasm_thumb.c"
#include "../gbacore/disasm_branch.c"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CDisassemblerDlg _CAO

CDisassemblerDlg::CDisassemblerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDisassemblerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDisassemblerDlg)
	//}}AFX_DATA_INIT
}


void CDisassemblerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDisassemblerDlg)
	DDX_Control(pDX, IDC_LIST_DISASSEMBLER, m_lstDisasm);
	DDX_Control(pDX, IDC_SCROLLBAR_DISASSEMBLER, m_scrDisasm);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDisassemblerDlg, CDialog)
	//{{AFX_MSG_MAP(CDisassemblerDlg)
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_BUTTON_GO, OnButtonGo)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_RADIO_ARM, OnRadioArm)
	ON_BN_CLICKED(IDC_RADIO_THUMB, OnRadioThumb)
	ON_BN_CLICKED(IDC_CHECK_ENABLE, OnCheckEnable)
	ON_LBN_DBLCLK(IDC_LIST_DISASSEMBLER, OnDblclkListDisassembler)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_SAVE_FILE, OnButtonSaveFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDisassemblerDlg bZ[W nh

BOOL CDisassemblerDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	debug_pc	= 0x08000000;
	m_pFont		= NULL;
	m_out_file	= FALSE;

	OnRadioArm();
/*
	m_pFont = new CFont;
	m_pFont->CreatePointFont(7, _T("FixedSys"));
	m_lstDisasm.SetFont(m_pFont);
*/
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CDisassemblerDlg::OnOK()
{
	OnClose();
}

void CDisassemblerDlg::OnCancel()
{
	OnClose();
}

void CDisassemblerDlg::ShowDisassembler()
{
	int i;
	
	m_lstDisasm.ResetContent();

	if(m_state_thumb){
		for(i = 0; i < 12; i++)ExecuteThumbDisasm();
	}else{
		for(i = 0; i < 12; i++)ExecuteArmDisasm();
	}

	m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
}

void CDisassemblerDlg::ShowDisassembler_step(unsigned int step_pc)
{	/*y[W؂ւ{I*/
	if((debug_pc - 0x2C) > step_pc || debug_pc <= step_pc){
		debug_pc = step_pc;
		ShowDisassembler();
	}

	m_lstDisasm.SetCurSel(12 - ((debug_pc - step_pc) >> 2));
}

void CDisassemblerDlg::ShowDisassembler_code()
{	/*\XV*/
	int i;

	m_lstDisasm.ResetContent();
	
	if(m_state_thumb){
		debug_pc -= 0x30;
		for(i = 0; i < 12; i++)ExecuteThumbDisasm();
		debug_pc += 0x18;
	}else{
		debug_pc -= 0x30;
		for(i = 0; i < 12; i++)ExecuteArmDisasm();
	}

	m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
	m_lstDisasm.SetCurSel(-1);
}

void CDisassemblerDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{	/*XN[o[ɂ铮*/
	UINT ScrPos = m_scrDisasm.GetScrollPos();
	UINT s_code, s_page;

	if(m_state_thumb){	/*THUMB̃f[^*/
		s_code = 0x02;/*IyR[h̃TCY*/
		s_page = 0x18;/*\IyR[h̃TCY̍v*/
	}else{
		s_code = 0x04;
		s_page = 0x30;
	}

	switch(nSBCode) {
		case SB_LINEUP:	/*XN[o[̃{^*/
			if((debug_pc - s_code) <= 0x00000000 + s_page)debug_pc = 0x00000000 + s_page;
			else debug_pc -= s_code;
			m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
			ShowDisassembler_code();
			break;
		case SB_LINEDOWN:
			if((debug_pc + s_code) >= DISASM_MAX + s_page)debug_pc = DISASM_MAX + s_page;
			else debug_pc += s_code;
			m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
			ShowDisassembler_code();
			break;
		case SB_PAGEUP:	/*XN[o[̗]*/
			if((debug_pc - s_page) <= 0x00000000 + s_page)debug_pc = 0x00000000 + s_page;
			else debug_pc -= s_page;
			m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
			ShowDisassembler_code();
			break;
		case SB_PAGEDOWN:
			if((debug_pc + s_page) >= DISASM_MAX + s_page)debug_pc = DISASM_MAX + s_page;
			else debug_pc += s_page;
			m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
			ShowDisassembler_code();
			break;
		case SB_THUMBPOSITION:	/*XN[o[̂܂*/
		case SB_THUMBTRACK:
			debug_pc = nPos << m_shift;
			if(nPos == 0x800)debug_pc = DISASM_MAX + s_page;
			else if(nPos == 0x00)debug_pc = s_page;
			m_scrDisasm.SetScrollPos(nPos, TRUE);
			ShowDisassembler_code();
			break;
	}

	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

BOOL CDisassemblerDlg::PreTranslateMessage(MSG* pMsg) 
{
	UINT s_code, s_page;

	if(m_state_thumb){
		s_code = 0x02;
		s_page = 0x18;
	}else{
		s_code = 0x04;
		s_page = 0x30;
	}

	if(pMsg->message == WM_KEYDOWN){
		switch(pMsg->wParam){
		case VK_RETURN:
			return FALSE;
		case VK_ESCAPE:
			return FALSE;
		case VK_DOWN:
			if((debug_pc + s_code) >= DISASM_MAX + s_page)debug_pc = DISASM_MAX + s_page;
			else debug_pc += s_code;
			m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
			ShowDisassembler_code();
			break;
		case VK_UP:
			if((debug_pc - s_code) <= 0x000000000 + s_page)debug_pc = 0x000000000 + s_page;
			else debug_pc -= s_code;
			m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
			ShowDisassembler_code();
			break;
		case VK_PRIOR:
			if((debug_pc - s_page) <= 0x00000000 + 0x30)debug_pc = 0x00000000 + s_page;
			else debug_pc -= s_page;
			m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
			ShowDisassembler_code();
			break;
		case VK_NEXT:
			if((debug_pc + s_page) >= DISASM_MAX + s_page)debug_pc = DISASM_MAX + s_page;
			else debug_pc += s_page;
			m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
			ShowDisassembler_code();
			break;
		case VK_HOME:
			debug_pc = 0x00000000;
			m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
			ShowDisassembler_code();
			break;
		case VK_END:
			debug_pc = 0x0FFFFFB0;
			m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
			ShowDisassembler_code();
			break;
		case 'N':
			//AfxGetMainWnd()->SendMessage(WM_DEBUG_NEXT);
			fNext = TRUE;
			AfxGetMainWnd()->SendMessage(WM_ACTIVATE, 0, 0);
			break;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CDisassemblerDlg::OnButtonGo() 
{	/*w肳ꂽAhXɃWv*/
	char str[32];

	GetDlgItemText(IDC_EDIT_ADDRESS, str, 10);
	debug_pc = (HexToInt(str) + (m_state_thumb?0x18:0x30)) & ~0x3;
	ShowDisassembler_code();
}

void CDisassemblerDlg::OnClose() 
{
	fDisassemblerDlg = FALSE;
	EndDialog(0);
	//CDialog::OnClose();
}

void CDisassemblerDlg::OnRadioArm()
{	/*Arm[hɕ\؂ւ*/
	m_state_thumb	= FALSE;
	m_shift			= 17;
	m_scrDisasm.SetScrollRange(0, 0x800, TRUE);
	m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
	ShowDisassembler_code();
	CheckRadioButton(IDC_RADIO_ARM, IDC_RADIO_THUMB, IDC_RADIO_ARM);
}

void CDisassemblerDlg::OnRadioThumb() 
{	/*Thumb[hɐ؂ւ*/
	m_state_thumb	= TRUE;
	m_shift			= 18;
	m_scrDisasm.SetScrollRange(0, 0x800, TRUE);
	m_scrDisasm.SetScrollPos(debug_pc >> m_shift, TRUE);
	ShowDisassembler_code();
	CheckRadioButton(IDC_RADIO_ARM, IDC_RADIO_THUMB, IDC_RADIO_THUMB);
}

void CDisassemblerDlg::OnCheckEnable() 
{	/*u[N|Cg̐ݒ*/
	char str[32];
	CButton* pBPchk = (CButton*)GetDlgItem(IDC_CHECK_ENABLE);

	if(!pBPchk->GetCheck()){
		pBPchk->SetCheck(0);
		fBreak = FALSE;
		GetDlgItem(IDC_EDIT_BREAKPOINT1)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_BREAKPOINT2)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_BREAKPOINT3)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_BREAKPOINT4)->EnableWindow(TRUE);
	}else{
		pBPchk->SetCheck(1);
		fBreak = TRUE;
		GetDlgItem(IDC_EDIT_BREAKPOINT1)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_BREAKPOINT2)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_BREAKPOINT3)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_BREAKPOINT4)->EnableWindow(FALSE);
		GetDlgItemText(IDC_EDIT_BREAKPOINT1, str, 10);
		BreakPoint1 = HexToInt(str);
		sprintf(str, "0x%x", BreakPoint1);
		MessageBox(str, 0, 0);
		GetDlgItemText(IDC_EDIT_BREAKPOINT2, str, 10);
		BreakPoint2 = HexToInt(str);
		GetDlgItemText(IDC_EDIT_BREAKPOINT3, str, 10);
		BreakPoint3 = HexToInt(str);
		GetDlgItemText(IDC_EDIT_BREAKPOINT4, str, 10);
		BreakPoint4 = HexToInt(str);
	}
}

void CDisassemblerDlg::OnDblclkListDisassembler() 
{	/*u[N|Cg̐ݒ*/
	u32 address;
	char str[16];

	if(fBreak)return;

	address = m_lstDisasm.GetCurSel();

	if(m_state_thumb){
		address = (debug_pc - 0x18) + (address << 1);
	}else{
		address = (debug_pc - 0x30) + (address << 2);
	}

	sprintf(str, "%08X", address);
	/*ԂɃeLXgZbg*/
	if(!GetDlgItemInt(IDC_EDIT_BREAKPOINT1, NULL, FALSE)){
		SetDlgItemText(IDC_EDIT_BREAKPOINT1, str);
	}else if(!GetDlgItemInt(IDC_EDIT_BREAKPOINT2, NULL, FALSE)){
		SetDlgItemText(IDC_EDIT_BREAKPOINT2, str);
	}else if(!GetDlgItemInt(IDC_EDIT_BREAKPOINT3, NULL, FALSE)){
		SetDlgItemText(IDC_EDIT_BREAKPOINT3, str);
	}else{
		SetDlgItemText(IDC_EDIT_BREAKPOINT4, str);
	}
}

void CDisassemblerDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	delete m_pFont;	
}

void CDisassemblerDlg::OnButtonSaveFile() 
{
	u32 i, temp_pc;
	char filename[512];
	char *str_line = 
		"\n; -------------------------------------------------------------------\n";
	CDisassemblerSaveDlg dlg;

	m_out_file	= TRUE;
	temp_pc		= debug_pc;
	
	dlg.m_disasm_filename	= filename;
	if(dlg.DoModal() == IDOK){
		dfp = fopen(filename, "wt");

		fprintf(dfp, str_line);
		fprintf(dfp, "; GameboyAdvanceVM ARM7TDMI Disassmbler\n");
		fprintf(dfp, "; Version 0.03");
		fprintf(dfp, str_line);
		fprintf(dfp, "\n");

		debug_pc = dlg.m_disasm_address;
		if(dlg.m_disasm_thumb_state){
			for(i = 0; i < dlg.m_disasm_size; i++)ExecuteThumbDisasm();
		}else{
			for(i = 0; i < dlg.m_disasm_size; i++)ExecuteArmDisasm();
		}

		fprintf(dfp, "\n");

		fclose(dfp);
		MessageBox("ۑ܂B", NULL, MB_ICONINFORMATION);
	}


	debug_pc	= temp_pc;
	m_out_file	= FALSE;
}


