// MainFrm.cpp : CMainFrame NX̓̒`s܂B
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "MainFrm.h"
#include <mmsystem.h>
#pragma comment(lib, "winmm.lib")
#include "agbwin32.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_COMMAND(IDM_OPEN, OnOpen)
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_COMMAND(IDM_RESET, OnReset)
	ON_COMMAND(IDM_RUN, OnRun)
	ON_COMMAND(IDM_SHOW_DISASSEMBLER, OnShowDisassembler)
	ON_COMMAND(IDM_SHOW_REGISTER, OnShowRegister)
	ON_COMMAND(IDM_SHOW_MEMORY, OnShowMemory)
	ON_COMMAND(IDM_NEXT, OnNext)
	ON_COMMAND(IDM_STOP, OnStop)
	ON_WM_CLOSE()
	ON_COMMAND(IDM_AUTO_UPDATE, OnAutoUpdate)
	ON_COMMAND(IDM_ZOOM_1, OnZoom1)
	ON_COMMAND(IDM_ZOOM_2, OnZoom2)
	ON_COMMAND(IDM_ZOOM_3, OnZoom3)
	ON_COMMAND(IDM_ZOOM_4, OnZoom4)
	ON_COMMAND(IDM_ZOOM_FULLSCREEN, OnZoomFullscreen)
	ON_WM_TIMER()
	ON_COMMAND(IDM_SHOW_FPS, OnShowFps)
	ON_COMMAND(IDM_VSYNC, OnVsync)
	ON_WM_DROPFILES()
	ON_COMMAND(IDM_SHOW_OAM, OnShowOam)
	ON_WM_DESTROY()
	ON_WM_ACTIVATE()
	ON_COMMAND(IDM_SHOW_DISPCNT, OnShowDispcnt)
	ON_COMMAND(IDM_INFORMATION, OnInformation)
	ON_COMMAND(IDM_AUTO_RUN, OnAutoRun)
	ON_COMMAND(IDM_SHOW_TRACE, OnShowTrace)
	ON_COMMAND(IDM_SHOW_HARDIO, OnShowHardio)
	ON_COMMAND(IDM_FRAME_RATE0, OnFrameRate0)
	ON_COMMAND(IDM_FRAME_RATE1, OnFrameRate1)
	ON_COMMAND(IDM_FRAME_RATE2, OnFrameRate2)
	ON_COMMAND(IDM_FRAME_RATE3, OnFrameRate3)
	ON_COMMAND(IDM_FRAME_RATE4, OnFrameRate4)
	ON_COMMAND(IDM_FRAME_RATE5, OnFrameRate5)
	ON_COMMAND(IDM_SHOW_TILE, OnShowTile)
	ON_MESSAGE(WM_DEBUG_NEXT, StepExecute)
	ON_COMMAND(IDM_SHOW_MAP, OnShowMap)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̍\z/

CMainFrame::CMainFrame()
{
	fTMain				=	FALSE;
	fBreak				=	FALSE;
	fNext				=	FALSE;

	fRegisterDlg		=	FALSE;
	fDisassemblerDlg	=	FALSE;
	fMemoryDlg			=	FALSE;
	fOamDlg				=	FALSE;
	fDispcntDlg			=	FALSE;
	fTraceDlg			=	FALSE;
	fHardioDlg			=	FALSE;
	fTileDlg			=	FALSE;
	fMapDlg				=	FALSE;

	m_pDisassemblerDlg	=	NULL;
	m_pRegisterDlg		=	NULL;
	m_pMemoryDlg		=	NULL;
	m_pOamDlg			=	NULL;
	m_pDispcntDlg		=	NULL;
	m_pTraceDlg			=	NULL;
	m_pHardioDlg		=	NULL;
	m_pTileDlg			=	NULL;
	m_pMapDlg			=	NULL;

	BreakPoint1			=	0xFFFFFFFF;
	BreakPoint2			=	0xFFFFFFFF;
	BreakPoint3			=	0xFFFFFFFF;
	BreakPoint4			=	0xFFFFFFFF;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	// t[̃NCAg̈Ŝ߂r[쐬܂B
	if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("Failed to create view window\n");
		return -1;
	}

	timeBeginPeriod(1);	// ^C}̐xŏ
	DragAcceptFiles(TRUE);

	OnZoom1();
	fAutoRun	= !TRUE;
	OnAutoRun();
	fAutoUpdate	= !TRUE;
	OnAutoUpdate();
	fFps		= !TRUE;
	OnShowFps();
	fVsync		= !TRUE;
	OnVsync();

	OnFrameRate0();

	OnShowTrace();
	m_pTraceDlg->OnCancel();

	if(__argv[1]!=NULL){
		AgbRomOpen(__argv[1]);
		if(fAutoRun)OnRun();
	}

	fEnableBios = agb_open_bios("bios.bin");
//	GetMenu()->CheckMenuItem(IDM_ENABLE_BIOS, fEnableBios?MF_CHECKED:MF_UNCHECKED);
	GetMenu()->EnableMenuItem(IDM_ENABLE_BIOS, MF_ENABLED);
//	MF_GRAYED

#ifdef _DEBUG
//	OnShowMemory();
	OnShowRegister();
	OnShowDisassembler();
#endif

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̐ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame bZ[W nh
void CMainFrame::OnSetFocus(CWnd* pOldWnd)
{
	// r[ EBhEɃtH[JX^܂B
	m_wndView.SetFocus();
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// r[ɍŏɃR}h@^܂B
	if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	// Ȃꍇɂ̓ftHg̏s܂B
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

int CMainFrame::AgbRomOpen(char *filename)
{
	int flag;
	char str[64], message[512];
	
	if(check_extension_name(filename, "zip")){
		flag = agb_open_ziprom(filename, agb_rom, &file_size);
		switch((u8)flag){
		case 1:
			LoadString(0, IDS_INVALED_ZIP_FILE, str, 64);
			break;
		case 2:
			LoadString(0, IDS_BAT_ZIP_FILE, str, 64);
			break;
		case 3:
			LoadString(0, IDS_UNKNOW_FILE_OPEN_ERROR, str, 64);
			break;
		case 4:
			LoadString(0, IDS_FILE_OPEN_ERROR, str, 64);
			break;
		}
	}else{
		flag = agb_open_rom(filename, agb_rom, &file_size);
		switch((u8)flag){
		case 1:
			LoadString(0, IDS_CAN_NOT_OPEN_ROM_FILE, str, 64);
			break;
		case 2:
			LoadString(0, IDS_MEMORY_ALLOCATION_ERROR, str, 64);
			break;
		}
	}
	if(flag){
		sprintf(message, str, filename);
		MessageBox(message, NULL, MB_ICONSTOP);
		//MessageBox("file open error.", NULL, MB_ICONSTOP);
	}else{
		agb_initialize_memory();
		agb_initialize_register();
		UpdateDebugger();
	}

	return flag;
}

void CMainFrame::OnOpen() 
{
	u32	str_len;
	char filename[512];
	char str[128], str_filter[256];
	OPENFILENAME ofn;

	memset(str_filter, 0, 256);
	str_len = 0;

	LoadString(0, IDS_FILE_FILTER_GBA, str, 128);
	memcpy(&str_filter[0], str, strlen(str));
	str_len += strlen(str) + 1;

	LoadString(0, IDS_FILE_FILTER_GBA_EXTENSION, str, 128);
	memcpy(&str_filter[str_len], str, strlen(str));
	str_len += strlen(str) + 1;

	LoadString(0, IDS_FILE_FILTER_ALL, str, 128);
	memcpy(&str_filter[str_len], str, strlen(str));
	str_len += strlen(str) + 1;

	LoadString(0, IDS_FILE_FILTER_ALL_EXTENSION, str, 128);
	memcpy(&str_filter[str_len], str, strlen(str));

	memset(filename, 0, 512);
	memset(&ofn, 0, sizeof(ofn));
	ofn.Flags			= OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile		= filename;
	ofn.lpstrFilter		= str_filter;
	//ofn.lpstrFilter		= "GameboyAdvance ROM Files (*.gba;*.agb;*.bin;*.zip)\0*.gba;*.agb;*.bin;*.zip\0All Files (*.*)\0*.*";
	ofn.nMaxFileTitle	= 512;
	ofn.nMaxFile		= 512;
	ofn.lStructSize		= sizeof(OPENFILENAME);
	ofn.hwndOwner		= m_hWnd;

	WaitForTMain();

	if(GetOpenFileName(&ofn)){
		AgbRomOpen(filename);
	}

#ifndef	_DEBUG
	if(fAutoRun)OnRun();
#endif
}

void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	CFrameWnd::OnSize(nType, cx, cy);

	GetClientRect(&clientSize);
}

void CMainFrame::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	
	// `pbZ[WƂ CFrameWnd::OnPaint() ĂяoĂ͂܂
}

void CMainFrame::OnReset() 
{
	arm.running = FALSE;

	WaitForTMain();

	agb_initialize_memory();
	agb_initialize_register();

	//m_wndView.
		agb_draw_lcd();
	if(fAutoRun)OnRun();
}

void CMainFrame::OnRun() 
{
	arm.running = TRUE;
	console_print("agb_mainloop thread running.\n");
	m_pTMain = AfxBeginThread(ThreadMain, this);
}

UINT CMainFrame::ThreadMain(LPVOID pParam)
{
	((CMainFrame*)pParam)->agb_mainloop();
	
	return 0;
}

void CMainFrame::OnShowDisassembler() 
{
	if(!fDisassemblerDlg){
		if(m_pDisassemblerDlg == NULL){
			m_pDisassemblerDlg = new CDisassemblerDlg;
			m_pDisassemblerDlg->Create(IDD_DISASSEMBLER);
		}
		m_pDisassemblerDlg->ShowWindow(SW_SHOW);
		fDisassemblerDlg = TRUE;
	}else{
		m_pDisassemblerDlg->SetFocus();
	}

	m_pDisassemblerDlg->ShowDisassembler();
}

void CMainFrame::OnShowRegister() 
{
	if(!fRegisterDlg){
		if(m_pRegisterDlg == NULL){
			m_pRegisterDlg = new CRegisterDlg;
			m_pRegisterDlg->Create(IDD_REGISTER);
		}
		m_pRegisterDlg->ShowWindow(SW_SHOW);
		fRegisterDlg = TRUE;
	}else{
		m_pRegisterDlg->SetFocus();
	}

	m_pRegisterDlg->ShowRegister();
}

void CMainFrame::OnShowMemory() 
{
	if(!fMemoryDlg){
		if(m_pMemoryDlg == NULL){
			m_pMemoryDlg = new CMemoryDlg;
			m_pMemoryDlg->Create(IDD_MEMORY);
		}
		m_pMemoryDlg->ShowWindow(SW_SHOW);
		fMemoryDlg = TRUE;
	}else{
		m_pMemoryDlg->SetFocus();
	}

	m_pMemoryDlg->ShowMemory();
}

void CMainFrame::OnShowOam() 
{
	if(!fOamDlg){
		if(m_pOamDlg == NULL){
			m_pOamDlg = new COamDlg;
			m_pOamDlg->Create(IDD_OAM);
		}
		m_pOamDlg->ShowWindow(SW_SHOW);
		fOamDlg = TRUE;
	}else{
		m_pOamDlg->SetFocus();
	}

	m_pOamDlg->ShowOam();
}

void CMainFrame::OnShowDispcnt() 
{
	if(!fDispcntDlg){
		if(m_pDispcntDlg == NULL){
			m_pDispcntDlg = new CDispcntDlg;
			m_pDispcntDlg->Create(IDD_DISPCNT);
		}
		m_pDispcntDlg->ShowWindow(SW_SHOW);
		fDispcntDlg = TRUE;
	}else{
		m_pDispcntDlg->SetFocus();
	}

	m_pDispcntDlg->ShowDispcnt();
}

void CMainFrame::OnShowTrace() 
{
	if(!fTraceDlg){
		if(m_pTraceDlg == NULL){
			m_pTraceDlg = new CTraceDlg;
			m_pTraceDlg->Create(IDD_TRACE);
		}
		m_pTraceDlg->ShowWindow(SW_SHOW);
		fTraceDlg = TRUE;
	}else{
		m_pTraceDlg->SetFocus();
	}

	//m_pTraceDlg->ShowTrace();
}

void CMainFrame::OnShowHardio() 
{
	if(!fHardioDlg){
		if(m_pHardioDlg == NULL){
			m_pHardioDlg = new CHardioDlg;
			m_pHardioDlg->Create(IDD_HARDIO);
		}
		m_pHardioDlg->ShowWindow(SW_SHOW);
		fHardioDlg = TRUE;
	}else{
		m_pHardioDlg->SetFocus();
	}

	m_pHardioDlg->ShowHardio();
}

void CMainFrame::OnShowTile() 
{
	if(!fTileDlg){
		if(m_pTileDlg == NULL){
			m_pTileDlg = new CTileDlg;
			m_pTileDlg->Create(IDD_TILE);
		}
		m_pTileDlg->ShowWindow(SW_SHOW);
		fTileDlg = TRUE;
	}else{
		m_pTileDlg->SetFocus();
	}

	m_pTileDlg->ShowTile();
}

void CMainFrame::OnShowMap() 
{
	if(!fMapDlg){
		if(m_pMapDlg == NULL){
			m_pMapDlg = new CMapDlg;
			m_pMapDlg->Create(IDD_MAP);
		}
		m_pMapDlg->ShowWindow(SW_SHOW);
		fMapDlg = TRUE;
	}else{
		m_pMapDlg->SetFocus();
	}

	m_pMapDlg->ShowMap();
}

void CMainFrame::StepExecute()
{	/*Xebvs*/

	fBreak = TRUE;

	if(fBreak){
		fBreak = FALSE;
		arm.running = FALSE;
		agb_mainloop();
		UpdateDebugger();
	}
}

void CMainFrame::OnNext() 
{
	StepExecute();
}

void CMainFrame::OnStop() 
{
	arm.running = FALSE;
}

void CMainFrame::OnClose() 
{
	timeEndPeriod(1);
	//KillTimer(1);
	WaitForTMain();

	if(m_pDisassemblerDlg){
		if(fDisassemblerDlg)m_pDisassemblerDlg->OnCancel();
		delete m_pDisassemblerDlg;
	}

	if(m_pRegisterDlg){
		if(fRegisterDlg)m_pRegisterDlg->OnCancel();
		delete m_pRegisterDlg;
	}

	if(m_pMemoryDlg){
		if(fMemoryDlg)m_pMemoryDlg->OnCancel();
		delete m_pMemoryDlg;
	}

	if(m_pOamDlg){
		if(fOamDlg)m_pOamDlg->OnCancel();
		delete m_pOamDlg;
	}

	if(m_pDispcntDlg){
		if(fDispcntDlg)m_pDispcntDlg->OnCancel();
		delete m_pDispcntDlg;
	}

	if(m_pTraceDlg){
		if(fTraceDlg)m_pTraceDlg->OnCancel();
		delete m_pTraceDlg;
	}

	if(m_pTileDlg){
		if(fTileDlg)m_pTileDlg->OnCancel();
		delete m_pTileDlg;
	}

	if(m_pMapDlg){
		if(fMapDlg)m_pMapDlg->OnCancel();
		delete m_pMapDlg;
	}

	CFrameWnd::OnClose();
}

void CMainFrame::WaitForTMain()
{	/*MainloopXbh̏I҂*/
	int i;
	
	arm.running = FALSE;
	for(i = 0; i < 10 && fTMain; i++){
		Sleep(100);
	}
}

BOOL CMainFrame::PreTranslateMessage(MSG* pMsg) 
{
	if(WM_KEYDOWN == pMsg->message){
		switch(pMsg->wParam){
		case 'Z':
			io_key->keyinput &= ~BIT0;
			break;
		case 'X':
			io_key->keyinput &= ~BIT1;
			break;
		case ' ':
			io_key->keyinput &= ~BIT2;
			break;
		case VK_RETURN:
			io_key->keyinput &= ~BIT3;
			break;
		case VK_RIGHT:
			io_key->keyinput &= ~BIT4;
			break;
		case VK_LEFT:
			io_key->keyinput &= ~BIT5;
			break;
		case VK_UP:
			io_key->keyinput &= ~BIT6;
			break;
		case VK_DOWN:
			io_key->keyinput &= ~BIT7;
			break;
		case 'S':
			io_key->keyinput &= ~BIT8;
			break;
		case 'A':
			io_key->keyinput &= ~BIT9;
			break;
		case 'N':
			StepExecute();
			break;
		case 'R':
		case VK_ESCAPE:
			OnReset();
			break;
		case VK_F5:
			if(GetKeyState(VK_SHIFT) & 0x8000){
				OnStop();
			}else{
				OnRun();
			}
			break;
		}
	}

	if(WM_KEYUP == pMsg->message){
		switch(pMsg->wParam){
		case 'Z':
			io_key->keyinput |= BIT0;
			break;
		case 'X':
			io_key->keyinput |= BIT1;
			break;
		case ' ':
			io_key->keyinput |= BIT2;
			break;
		case VK_RETURN:
			io_key->keyinput |= BIT3;
			break;
		case VK_RIGHT:
			io_key->keyinput |= BIT4;
			break;
		case VK_LEFT:
			io_key->keyinput |= BIT5;
			break;
		case VK_UP:
			io_key->keyinput |= BIT6;
			break;
		case VK_DOWN:
			io_key->keyinput |= BIT7;
			break;
		case 'S':
			io_key->keyinput |= BIT8;
			break;
		case 'A':
			io_key->keyinput |= BIT9;
			break;
		}
	}

	return CFrameWnd::PreTranslateMessage(pMsg);
}

void CMainFrame::UpdateDebugger()
{
	if(fRegisterDlg)m_pRegisterDlg->ShowRegister();
	if(fDisassemblerDlg)m_pDisassemblerDlg->ShowDisassembler_step(ARM_PC);
	if(fMemoryDlg)m_pMemoryDlg->ShowMemory();
	if(fHardioDlg)m_pHardioDlg->ShowHardio();
	if(fTileDlg)m_pTileDlg->ShowTile();
	if(fMapDlg)m_pMapDlg->DrawMap();
	if(fOamDlg)m_pOamDlg->ShowOam();
}

void CMainFrame::OnZoom1() 
{
	SetRect(&clientSize, 0, 0, AGB_LCD_X, AGB_LCD_Y);
	AdjustWindowRect(&clientSize, WS_OVERLAPPEDWINDOW, TRUE);
//	AdjustWindowRect(&clientSize, 0, TRUE);
	SetWindowPos(&wndTop, 0, 0, clientSize.right - clientSize.left, 
							clientSize.bottom - clientSize.top, SWP_NOMOVE);

	GetMenu()->CheckMenuRadioItem(IDM_ZOOM_1, IDM_ZOOM_FULLSCREEN, IDM_ZOOM_1, MF_BYCOMMAND);
}

void CMainFrame::OnZoom2() 
{
	SetRect(&clientSize, 0, 0, AGB_LCD_X * 2, AGB_LCD_Y * 2);
	AdjustWindowRect(&clientSize, WS_OVERLAPPEDWINDOW, TRUE);
	SetWindowPos(&wndTop, 0, 0, clientSize.right - clientSize.left, 
							clientSize.bottom - clientSize.top, SWP_NOMOVE);

	GetMenu()->CheckMenuRadioItem(IDM_ZOOM_1, IDM_ZOOM_FULLSCREEN, IDM_ZOOM_2, MF_BYCOMMAND);
}

void CMainFrame::OnZoom3() 
{
	SetRect(&clientSize, 0, 0, AGB_LCD_X * 3, AGB_LCD_Y * 3);
	AdjustWindowRect(&clientSize, WS_OVERLAPPEDWINDOW, TRUE);
	SetWindowPos(&wndTop, 0, 0, clientSize.right - clientSize.left, 
							clientSize.bottom - clientSize.top, SWP_NOMOVE);

	GetMenu()->CheckMenuRadioItem(IDM_ZOOM_1, IDM_ZOOM_FULLSCREEN, IDM_ZOOM_3, MF_BYCOMMAND);
}

void CMainFrame::OnZoom4() 
{
	SetRect(&clientSize, 0, 0, AGB_LCD_X * 4, AGB_LCD_Y * 4);
	AdjustWindowRect(&clientSize, WS_OVERLAPPEDWINDOW, TRUE);
	SetWindowPos(&wndTop, 0, 0, clientSize.right - clientSize.left, 
							clientSize.bottom - clientSize.top, SWP_NOMOVE);

	GetMenu()->CheckMenuRadioItem(IDM_ZOOM_1, IDM_ZOOM_FULLSCREEN, IDM_ZOOM_4, MF_BYCOMMAND);
}

void CMainFrame::OnZoomFullscreen() 
{
	PostMessage(WM_SYSCOMMAND, SC_MAXIMIZE);

	GetMenu()->CheckMenuRadioItem(IDM_ZOOM_1, IDM_ZOOM_FULLSCREEN, IDM_ZOOM_FULLSCREEN, MF_BYCOMMAND);
}

void CMainFrame::OnTimer(UINT nIDEvent) 
{
	char str[64];

	if(fTMain){
		sprintf(str, _TITLE_" - %d%%", (int)(frame_count / 59.0f * 100));
		frame_count = 0;
	}else{
		sprintf(str, _TITLE_);
	}

	SetWindowText(str);

	CFrameWnd::OnTimer(nIDEvent);
}

void CMainFrame::ShowFps()
{
	static u32	wait_fps;
	static char str[64];

	if(wait_fps < timeGetTime()){
		sprintf(str, _TITLE_" - %d%%", (int)(frame_count / 59.0f * 100));
		frame_count = 0;
		SetWindowText(str);
		wait_fps = timeGetTime() + 1000;
	}
}

void CMainFrame::OnShowFps() 
{
	if(fFps){
		fFps = FALSE;
		//KillTimer(1);
		SetWindowText(_TITLE_);
	}else{
		fFps = TRUE;
		//SetTimer(1, 1000, NULL);
	}

	GetMenu()->CheckMenuItem(IDM_SHOW_FPS, fFps?MF_CHECKED:MF_UNCHECKED);
}

void CMainFrame::OnDropFiles(HDROP hDropInfo) 
{
	char filename[MAX_PATH];

	DragQueryFile(hDropInfo, 0, filename, sizeof(filename));
	DragFinish(hDropInfo);

	WaitForTMain();

	if(!AgbRomOpen(filename)){
		if(fAutoRun)OnRun();
	}

	//CFrameWnd::OnDropFiles(hDrop3o);
}

void CMainFrame::OnDestroy() 
{
	CFrameWnd::OnDestroy();
	
	agb_close_rom(agb_rom);
}

void CMainFrame::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CFrameWnd::OnActivate(nState, pWndOther, bMinimized);
/*	
	if(fNext){
		fNext = FALSE;
		StepExecute();
	}
*/
}

void CMainFrame::OnInformation() 
{
	char str[512];

	ShowHeaderInfo(agb_rom, str);
	MessageBox(str, NULL, NULL);
}

void CMainFrame::OnAutoUpdate() 
{
	fAutoUpdate = !fAutoUpdate;

	GetMenu()->CheckMenuItem(IDM_AUTO_UPDATE, fAutoUpdate?MF_CHECKED:MF_UNCHECKED);
}

void CMainFrame::OnVsync() 
{
	fVsync = !fVsync;

	GetMenu()->CheckMenuItem(IDM_VSYNC, fVsync?MF_CHECKED:MF_UNCHECKED);
}

void CMainFrame::OnAutoRun() 
{
	fAutoRun = !fAutoRun;

	GetMenu()->CheckMenuItem(IDM_AUTO_RUN, fAutoRun?MF_CHECKED:MF_UNCHECKED);
}

void CMainFrame::OnFrameRate0() 
{
	frame_skip = 0;

	GetMenu()->CheckMenuRadioItem(IDM_FRAME_RATE0, IDM_FRAME_RATE5, IDM_FRAME_RATE0, MF_BYCOMMAND);
}

void CMainFrame::OnFrameRate1() 
{
	frame_skip = 1;

	GetMenu()->CheckMenuRadioItem(IDM_FRAME_RATE0, IDM_FRAME_RATE5, IDM_FRAME_RATE1, MF_BYCOMMAND);
}

void CMainFrame::OnFrameRate2() 
{
	frame_skip = 2;

	GetMenu()->CheckMenuRadioItem(IDM_FRAME_RATE0, IDM_FRAME_RATE5, IDM_FRAME_RATE2, MF_BYCOMMAND);
}

void CMainFrame::OnFrameRate3() 
{
	frame_skip = 3;

	GetMenu()->CheckMenuRadioItem(IDM_FRAME_RATE0, IDM_FRAME_RATE5, IDM_FRAME_RATE3, MF_BYCOMMAND);
}

void CMainFrame::OnFrameRate4() 
{
	frame_skip = 4;

	GetMenu()->CheckMenuRadioItem(IDM_FRAME_RATE0, IDM_FRAME_RATE5, IDM_FRAME_RATE4, MF_BYCOMMAND);
}

void CMainFrame::OnFrameRate5() 
{
	frame_skip = 5;

	GetMenu()->CheckMenuRadioItem(IDM_FRAME_RATE0, IDM_FRAME_RATE5, IDM_FRAME_RATE5, MF_BYCOMMAND);
}


