// TileDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "gbaemu.h"
#include "TileDlg.h"

#define	_AGBWIN32_
#include "../include/externs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern DWORD dwSize;
LPBITMAPINFO tile_info;

/////////////////////////////////////////////////////////////////////////////
// CTileDlg _CAO


CTileDlg::CTileDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTileDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTileDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CTileDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTileDlg)
	DDX_Control(pDX, IDC_SLIDER_BASE, m_sldBase);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTileDlg, CDialog)
	//{{AFX_MSG_MAP(CTileDlg)
	ON_WM_CLOSE()
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, OnButtonUpdate)
	ON_BN_CLICKED(IDC_RADIO_COLOR16, OnRadioColor16)
	ON_BN_CLICKED(IDC_RADIO_COLOR256, OnRadioColor256)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTileDlg bZ[W nh

void CTileDlg::OnOK()
{
	OnClose();
}

void CTileDlg::OnCancel()
{
	OnClose();
}

BOOL CTileDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	tile_info = (LPBITMAPINFO)new char[dwSize];

	memset(tile_info, 0, sizeof(BITMAPINFOHEADER));
	tile_info->bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	tile_info->bmiHeader.biWidth	= TILE_LCD_X;
	tile_info->bmiHeader.biHeight	= -TILE_LCD_Y;
	tile_info->bmiHeader.biPlanes	= 1;
	tile_info->bmiHeader.biBitCount	= 16;

	memset(TileBuffer, 0, TILE_LCD_X * TILE_LCD_Y * 2);
/*
	RECT	DlgSize;
	SetRect(&DlgSize, 0, 0, 260, 290);
	AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left,
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
*/
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_FRAME_TILE), 0, 10, 10,
					TILE_LCD_X, TILE_LCD_Y, SWP_NOACTIVATE | SWP_NOZORDER);

	m_sldBase.SetRange(0, 7, TRUE);
	OnRadioColor256();

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CTileDlg::OnClose() 
{
	fTileDlg = FALSE;
	EndDialog(0);
	//CDialog::OnClose();
}

void CTileDlg::ShowTile()
{
	u32	x, y, tile_x, tile_y;
	u32	base_char, base_map, temp32;
	u16 *palette;
	u8	*vram;
	char str[32];
	HBITMAP	hBitmap, hOldmap;
	HDC		hDC, hMemDC;

	hDC = GetDlgItem(IDC_FRAME_TILE)->GetDC()->m_hDC;

	base_char = m_sldBase.GetPos() << 14;	/*16KBP*/
	sprintf(str , "%08Xh", (base_char + 0x06000000));
	SetDlgItemText(IDC_EDIT_BASE_CHAR, str);

	palette	= (u16*)agb_palram;
	base_map = 0;

	for(y = 0; y < TILE_LCD_Y; y += 8){
		for(x = 0; x < TILE_LCD_X; x += 8){
			vram = &agb_vram[(base_map << 6) + base_char];
			for(tile_y = 0; tile_y < 8; tile_y++){
				for(tile_x = 0; tile_x < 8; tile_x++){
					temp32 = palette[*vram++];
					TileBuffer[tile_x + x + (tile_y + y) * TILE_LCD_X] = SWAP_RB(temp32);
				}
			}
			base_map++;
		}
	}

	hMemDC	= CreateCompatibleDC(hDC);
	hBitmap	= CreateDIBitmap(hDC, &tile_info->bmiHeader, CBM_INIT, 
								TileBuffer, tile_info, DIB_RGB_COLORS);
	hOldmap	= (HBITMAP)SelectObject(hMemDC, hBitmap);
	StretchBlt(hDC, 0, 0, TILE_LCD_X, TILE_LCD_Y, hMemDC, 0, 0, TILE_LCD_X, TILE_LCD_Y, SRCCOPY);
	DeleteObject(hBitmap);
}

void CTileDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	ShowTile();
	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}

void CTileDlg::OnButtonUpdate() 
{
	ShowTile();
}

BOOL CTileDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(WM_KEYDOWN == pMsg->message){
		switch((BYTE)pMsg->wParam){
		case VK_RETURN:
			return FALSE;
		case VK_ESCAPE:
			return FALSE;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CTileDlg::OnRadioColor16() 
{
	CheckRadioButton(IDC_RADIO_COLOR16, IDC_RADIO_COLOR256, IDC_RADIO_COLOR16);
	m_fcolor16 = TRUE;
}

void CTileDlg::OnRadioColor256() 
{
	CheckRadioButton(IDC_RADIO_COLOR16, IDC_RADIO_COLOR256, IDC_RADIO_COLOR256);
	m_fcolor16 = FALSE;
}

void CTileDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	delete tile_info;	
}
