/*
 * Decompiled with CFR 0.152.
 */
package ygba;

import ygba.YGBACore;
import ygba.cpu.ARM7TDMI;
import ygba.dma.DirectMemoryAccess;
import ygba.gfx.GFX;
import ygba.memory.Memory;
import ygba.time.Time;

public final class YGBA {
    private ARM7TDMI cpu = new ARM7TDMI();
    private Memory memory = new Memory();
    private DirectMemoryAccess dma = new DirectMemoryAccess();
    private GFX gfx = new GFX();
    private Time time = new Time();
    private YGBACore ygbaCore = new YGBACore(this.cpu, this.memory, this.time);
    private Thread ygbaThread = null;

    public YGBA() {
        this.setupConnections();
    }

    private void setupConnections() {
        this.cpu.connectToMemory(this.memory);
        this.memory.connectToDMA(this.dma);
        this.memory.connectToGraphics(this.gfx);
        this.memory.connectToTime(this.time);
        this.dma.connectToMemory(this.memory);
        this.gfx.connectToMemory(this.memory);
        this.time.connectToMemory(this.memory);
    }

    public ARM7TDMI getCPU() {
        return this.cpu;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public DirectMemoryAccess getDMA() {
        return this.dma;
    }

    public GFX getGraphics() {
        return this.gfx;
    }

    public Time getTime() {
        return this.time;
    }

    public void reset() {
        this.cpu.reset();
        this.memory.reset();
        this.dma.reset();
        this.gfx.reset();
        this.time.reset();
        this.ygbaThread = null;
        System.gc();
    }

    public void run() {
        this.ygbaThread = new Thread(this.ygbaCore);
        this.ygbaThread.setPriority(5);
        this.ygbaThread.start();
    }

    public void stop() {
        if (this.ygbaThread != null) {
            this.ygbaCore.stop();
            try {
                this.ygbaThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.ygbaThread = null;
        }
    }

    public boolean isReady() {
        return this.memory.isBIOSLoaded() && this.memory.isROMLoaded();
    }
}

