/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu;

import ygba.cpu.instruction.ARM_10;
import ygba.cpu.instruction.ARM_11;
import ygba.cpu.instruction.ARM_12;
import ygba.cpu.instruction.ARM_13;
import ygba.cpu.instruction.ARM_17;
import ygba.cpu.instruction.ARM_3;
import ygba.cpu.instruction.ARM_4;
import ygba.cpu.instruction.ARM_5;
import ygba.cpu.instruction.ARM_6;
import ygba.cpu.instruction.ARM_7;
import ygba.cpu.instruction.ARM_8;
import ygba.cpu.instruction.ARM_9;
import ygba.cpu.instruction.ARM_CP;
import ygba.cpu.instruction.THUMB_1;
import ygba.cpu.instruction.THUMB_10;
import ygba.cpu.instruction.THUMB_11;
import ygba.cpu.instruction.THUMB_12;
import ygba.cpu.instruction.THUMB_13;
import ygba.cpu.instruction.THUMB_14;
import ygba.cpu.instruction.THUMB_15;
import ygba.cpu.instruction.THUMB_16;
import ygba.cpu.instruction.THUMB_17;
import ygba.cpu.instruction.THUMB_18;
import ygba.cpu.instruction.THUMB_19;
import ygba.cpu.instruction.THUMB_2;
import ygba.cpu.instruction.THUMB_3;
import ygba.cpu.instruction.THUMB_4;
import ygba.cpu.instruction.THUMB_5;
import ygba.cpu.instruction.THUMB_6;
import ygba.cpu.instruction.THUMB_7;
import ygba.cpu.instruction.THUMB_8;
import ygba.cpu.instruction.THUMB_9;
import ygba.cpu.instruction.THUMB_Und;
import ygba.memory.MemoryInterface;

public final class ARM7TDMI {
    public static final int USRMode = 16;
    public static final int SYSMode = 31;
    public static final int FIQMode = 17;
    public static final int SVCMode = 19;
    public static final int ABTMode = 23;
    public static final int IRQMode = 18;
    public static final int UNDMode = 27;
    public static final int ResetVector = 0;
    public static final int UndefinedInstructionVector = 4;
    public static final int PrefetchAbortVector = 12;
    public static final int DataAbortVector = 16;
    public static final int NormalInterruptVector = 24;
    public static final int FastInterruptVector = 28;
    public static final int SoftwareInterruptVector = 8;
    public static final int IMEAddress = 67109384;
    public static final int IEAddress = 0x4000200;
    public static final int IFAddress = 0x4000202;
    public static final int ROMStartAddress = 0x8000000;
    public int[] registers = new int[37];
    public static final byte R0 = 0;
    public static final byte R1 = 1;
    public static final byte R2 = 2;
    public static final byte R3 = 3;
    public static final byte R4 = 4;
    public static final byte R5 = 5;
    public static final byte R6 = 6;
    public static final byte R7 = 7;
    public static final byte R8 = 8;
    public static final byte R8_fiq = 17;
    public static final byte R9 = 9;
    public static final byte R9_fiq = 18;
    public static final byte R10 = 10;
    public static final byte R10_fiq = 19;
    public static final byte R11 = 11;
    public static final byte R11_fiq = 20;
    public static final byte R12 = 12;
    public static final byte R12_fiq = 21;
    public static final byte R13 = 13;
    public static final byte R13_fiq = 22;
    public static final byte R13_svc = 25;
    public static final byte R13_abt = 28;
    public static final byte R13_irq = 31;
    public static final byte R13_und = 34;
    public static final byte R14 = 14;
    public static final byte R14_fiq = 23;
    public static final byte R14_svc = 26;
    public static final byte R14_abt = 29;
    public static final byte R14_irq = 32;
    public static final byte R14_und = 35;
    public static final byte R15 = 15;
    public static final byte CPSR = 16;
    public static final byte SPSR_fiq = 24;
    public static final byte SPSR_svc = 27;
    public static final byte SPSR_abt = 30;
    public static final byte SPSR_irq = 33;
    public static final byte SPSR_und = 36;
    public static final byte SPSR_null = -1;
    public static final byte SP = 13;
    public static final byte LR = 14;
    public static final byte PC = 15;
    public static byte SPSR;
    private static final byte NB_REGS = 37;
    public int mFlag;
    public boolean tFlag;
    public boolean fFlag;
    public boolean iFlag;
    public boolean vFlag;
    public boolean cFlag;
    public boolean nFlag;
    public boolean zFlag;
    private static final int MMask = 31;
    private static final int TMask = 32;
    private static final int FMask = 64;
    private static final int IMask = 128;
    private static final int VMask = 0x10000000;
    private static final int CMask = 0x20000000;
    private static final int ZMask = 0x40000000;
    private static final int NMask = Integer.MIN_VALUE;
    private int pipelineStage1;
    private int pipelineStage2;
    private MemoryInterface memory;
    public static final int CyclesPerInstruction = 4;
    private static final byte THUMBInstructionFormat1 = 1;
    private static final byte THUMBInstructionFormat2 = 2;
    private static final byte THUMBInstructionFormat3 = 3;
    private static final byte THUMBInstructionFormat4 = 4;
    private static final byte THUMBInstructionFormat5 = 5;
    private static final byte THUMBInstructionFormat6 = 6;
    private static final byte THUMBInstructionFormat7 = 7;
    private static final byte THUMBInstructionFormat8 = 8;
    private static final byte THUMBInstructionFormat9 = 9;
    private static final byte THUMBInstructionFormat10 = 10;
    private static final byte THUMBInstructionFormat11 = 11;
    private static final byte THUMBInstructionFormat12 = 12;
    private static final byte THUMBInstructionFormat13 = 13;
    private static final byte THUMBInstructionFormat14 = 14;
    private static final byte THUMBInstructionFormat15 = 15;
    private static final byte THUMBInstructionFormat16 = 16;
    private static final byte THUMBInstructionFormat17 = 17;
    private static final byte THUMBInstructionFormat18 = 18;
    private static final byte THUMBInstructionFormat19 = 19;
    private static final byte THUMBInstructionFormatUnd = 127;
    private static byte[] thumbInstruction;
    private static final byte ARMInstructionFormat3 = 3;
    private static final byte ARMInstructionFormat4 = 4;
    private static final byte ARMInstructionFormat5 = 5;
    private static final byte ARMInstructionFormat6 = 6;
    private static final byte ARMInstructionFormat7 = 7;
    private static final byte ARMInstructionFormat8 = 8;
    private static final byte ARMInstructionFormat9 = 9;
    private static final byte ARMInstructionFormat10 = 10;
    private static final byte ARMInstructionFormat11 = 11;
    private static final byte ARMInstructionFormat12 = 12;
    private static final byte ARMInstructionFormat13 = 13;
    private static final byte ARMInstructionFormat17 = 17;
    private static final byte ARMInstructionFormatCoP = 18;
    private static byte[] armInstruction;

    public ARM7TDMI() {
        ARM7TDMI.initTHUMB();
        ARM7TDMI.initARM();
    }

    public void connectToMemory(MemoryInterface memoryInterface) {
        this.memory = memoryInterface;
    }

    public int getSP() {
        return this.registers[13];
    }

    public void setSP(int n) {
        this.registers[13] = n;
    }

    public int getLR() {
        return this.registers[14];
    }

    public void setLR(int n) {
        this.registers[14] = n;
    }

    public int getPC() {
        return this.registers[15];
    }

    public int getCurrentPC() {
        return this.registers[15] - (this.tFlag ? 2 : 4);
    }

    public void setPC(int n) {
        this.registers[15] = n;
    }

    public int getCPSR() {
        int n = 0;
        n = ARM7TDMI.setBit(n, this.mFlag, true);
        n = ARM7TDMI.setBit(n, 32, this.tFlag);
        n = ARM7TDMI.setBit(n, 64, this.fFlag);
        n = ARM7TDMI.setBit(n, 128, this.iFlag);
        n = ARM7TDMI.setBit(n, 0x10000000, this.vFlag);
        n = ARM7TDMI.setBit(n, 0x20000000, this.cFlag);
        n = ARM7TDMI.setBit(n, 0x40000000, this.zFlag);
        n = ARM7TDMI.setBit(n, Integer.MIN_VALUE, this.nFlag);
        return n;
    }

    public void setCPSR(int n) {
        this.setMode(n & 0x1F);
        this.tFlag = (n & 0x20) != 0;
        this.fFlag = (n & 0x40) != 0;
        this.iFlag = (n & 0x80) != 0;
        this.vFlag = (n & 0x10000000) != 0;
        this.cFlag = (n & 0x20000000) != 0;
        this.zFlag = (n & 0x40000000) != 0;
        this.nFlag = (n & Integer.MIN_VALUE) != 0;
    }

    public int getSPSR() {
        return this.registers[SPSR];
    }

    public void setSPSR(int n) {
        this.registers[ARM7TDMI.SPSR] = n;
    }

    public int getRegister(int n) {
        return this.registers[n];
    }

    public void setRegister(int n, int n2) {
        this.registers[n] = n2;
    }

    public String getRegisterName(int n) {
        switch (n) {
            case 13: {
                return "sp";
            }
            case 14: {
                return "lr";
            }
            case 15: {
                return "pc";
            }
            case 16: {
                return "cpsr";
            }
            case 17: {
                return "spsr";
            }
        }
        return "r" + n;
    }

    public void swapRegisters(int n, int n2) {
        int n3 = this.registers[n];
        this.registers[n] = this.registers[n2];
        this.registers[n2] = n3;
    }

    private static int setBit(int n, int n2, boolean bl) {
        return bl ? n | n2 : n & ~n2;
    }

    public int getMode() {
        return this.mFlag;
    }

    public void setMode(int n) {
        int n2 = n;
        int n3 = this.mFlag;
        if (n2 != n3) {
            switch (n3) {
                case 17: {
                    this.swapRegisters(17, 8);
                    this.swapRegisters(18, 9);
                    this.swapRegisters(19, 10);
                    this.swapRegisters(20, 11);
                    this.swapRegisters(21, 12);
                    this.swapRegisters(22, 13);
                    this.swapRegisters(23, 14);
                    break;
                }
                case 19: {
                    this.swapRegisters(25, 13);
                    this.swapRegisters(26, 14);
                    break;
                }
                case 23: {
                    this.swapRegisters(28, 13);
                    this.swapRegisters(29, 14);
                    break;
                }
                case 18: {
                    this.swapRegisters(31, 13);
                    this.swapRegisters(32, 14);
                    break;
                }
                case 27: {
                    this.swapRegisters(34, 13);
                    this.swapRegisters(35, 14);
                }
            }
            switch (n2) {
                case 16: 
                case 31: {
                    SPSR = (byte)-1;
                    break;
                }
                case 17: {
                    this.swapRegisters(8, 17);
                    this.swapRegisters(9, 18);
                    this.swapRegisters(10, 19);
                    this.swapRegisters(11, 20);
                    this.swapRegisters(12, 21);
                    this.swapRegisters(13, 22);
                    this.swapRegisters(14, 23);
                    SPSR = (byte)24;
                    break;
                }
                case 19: {
                    this.swapRegisters(13, 25);
                    this.swapRegisters(14, 26);
                    SPSR = (byte)27;
                    break;
                }
                case 23: {
                    this.swapRegisters(13, 28);
                    this.swapRegisters(14, 29);
                    SPSR = (byte)30;
                    break;
                }
                case 18: {
                    this.swapRegisters(13, 31);
                    this.swapRegisters(14, 32);
                    SPSR = (byte)33;
                    break;
                }
                case 27: {
                    this.swapRegisters(13, 34);
                    this.swapRegisters(14, 35);
                    SPSR = (byte)36;
                }
            }
            this.mFlag = n2;
        }
    }

    public String getModeName() {
        switch (this.mFlag) {
            case 16: {
                return "usr";
            }
            case 31: {
                return "sys";
            }
            case 17: {
                return "fiq";
            }
            case 19: {
                return "svc";
            }
            case 23: {
                return "abt";
            }
            case 18: {
                return "irq";
            }
            case 27: {
                return "und";
            }
        }
        return "";
    }

    public boolean getTFlag() {
        return this.tFlag;
    }

    public void setTFlag(boolean bl) {
        this.tFlag = bl;
    }

    public boolean getFFlag() {
        return this.fFlag;
    }

    public void setFFlag(boolean bl) {
        this.fFlag = bl;
    }

    public boolean getIFlag() {
        return this.iFlag;
    }

    public void setIFlag(boolean bl) {
        this.iFlag = bl;
    }

    public boolean getVFlag() {
        return this.vFlag;
    }

    public void setVFlag(boolean bl) {
        this.vFlag = bl;
    }

    public boolean getCFlag() {
        return this.cFlag;
    }

    public void setCFlag(boolean bl) {
        this.cFlag = bl;
    }

    public boolean getNFlag() {
        return this.nFlag;
    }

    public void setNFlag(boolean bl) {
        this.nFlag = bl;
    }

    public boolean getZFlag() {
        return this.zFlag;
    }

    public void setZFlag(boolean bl) {
        this.zFlag = bl;
    }

    public void setVCFlagsForADD(int n, int n2, int n3) {
        boolean bl = n < 0;
        boolean bl2 = n2 < 0;
        boolean bl3 = n3 < 0;
        this.vFlag = bl && bl2 && !bl3 || !bl && !bl2 && bl3;
        this.cFlag = bl && bl2 || bl && !bl3 || bl2 && !bl3;
    }

    public void setVCFlagsForSUB(int n, int n2, int n3) {
        boolean bl = n < 0;
        boolean bl2 = n2 < 0;
        boolean bl3 = n3 < 0;
        this.vFlag = bl && !bl2 && !bl3 || !bl && bl2 && bl3;
        this.cFlag = bl && !bl2 || bl && !bl3 || !bl2 && !bl3;
    }

    private void generateInterrupt(int n, int n2, int n3) {
        int n4 = this.getCPSR();
        this.setMode(n);
        this.tFlag = false;
        this.iFlag = true;
        this.setSPSR(n4);
        this.setLR(n3);
        this.setPC(n2);
        this.flushARMPipeline();
    }

    public void generateNormalInterrupt(int n) {
        this.generateInterrupt(18, 24, n);
    }

    public void generateSoftwareInterrupt(int n) {
        this.generateInterrupt(19, 8, n);
    }

    public void generateUndefinedInstructionInterrupt(int n) {
        this.generateInterrupt(27, 4, n);
    }

    public void reset() {
        for (int n = 0; n < 37; n = (int)((byte)(n + 1))) {
            this.registers[n] = 0;
        }
        this.mFlag = 0;
        this.nFlag = false;
        this.zFlag = false;
        this.cFlag = false;
        this.vFlag = false;
        this.tFlag = false;
        this.iFlag = true;
        this.fFlag = true;
        this.setMode(19);
        this.setPC(0);
        this.iFlag = false;
        this.setMode(31);
        this.setPC(0x8000000);
        this.setRegister(13, 50364160);
        this.setRegister(25, 50364384);
        this.setRegister(31, 50364320);
        this.flushPipeline();
    }

    public void run(int n) {
        while (n > 0) {
            byte by;
            int n2;
            if (!this.iFlag && this.memory.getByte(67109384) != 0 && (this.memory.getHalfWord(0x4000200) & this.memory.getHalfWord(0x4000202)) != 0) {
                this.generateNormalInterrupt(this.getPC() + (this.tFlag ? 2 : 0));
            } else if (this.tFlag) {
                n2 = this.fetchTHUMB();
                by = ARM7TDMI.decodeTHUMB(n2);
                this.executeTHUMB(n2, by);
            } else {
                n2 = this.fetchARM();
                by = ARM7TDMI.decodeARM(n2);
                this.executeARM(n2, by);
            }
            n -= 4;
        }
    }

    public void flushPipeline() {
        if (this.tFlag) {
            this.flushTHUMBPipeline();
        } else {
            this.flushARMPipeline();
        }
    }

    public void flushTHUMBPipeline() {
        this.registers[15] = this.registers[15] & 0xFFFFFFFE;
        this.pipelineStage1 = this.memory.getHalfWord(this.registers[15]) & 0xFFFF;
        this.registers[15] = this.registers[15] + 2;
        this.pipelineStage2 = this.memory.getHalfWord(this.registers[15]) & 0xFFFF;
    }

    public void flushARMPipeline() {
        this.registers[15] = this.registers[15] & 0xFFFFFFFC;
        this.pipelineStage1 = this.memory.getWord(this.registers[15]);
        this.registers[15] = this.registers[15] + 4;
        this.pipelineStage2 = this.memory.getWord(this.registers[15]);
    }

    private static void initTHUMB() {
        thumbInstruction = new byte[256];
        for (int n = 0; n < thumbInstruction.length; n = (int)((short)(n + 1))) {
            int n2 = (n & 0xF8) == 24 ? 2 : ((n & 0xE0) == 0 ? 1 : ((n & 0xE0) == 32 ? 3 : ((n & 0xFC) == 64 ? 4 : ((n & 0xFC) == 68 ? 5 : ((n & 0xF8) == 72 ? 6 : ((n & 0xF2) == 80 ? 7 : ((n & 0xF2) == 82 ? 8 : ((n & 0xE0) == 96 ? 9 : ((n & 0xF0) == 128 ? 10 : ((n & 0xF0) == 144 ? 11 : ((n & 0xF0) == 160 ? 12 : ((n & 0xFF) == 176 ? 13 : ((n & 0xF6) == 180 ? 14 : ((n & 0xF0) == 192 ? 15 : ((n & 0xFF) == 223 ? 17 : ((n & 0xF0) == 208 ? 16 : ((n & 0xF8) == 224 ? 18 : ((n & 0xF0) == 240 ? 19 : 127))))))))))))))))));
            ARM7TDMI.thumbInstruction[n] = n2;
        }
    }

    private int fetchTHUMB() {
        this.registers[15] = this.registers[15] + 2;
        int n = this.pipelineStage1;
        this.pipelineStage1 = this.pipelineStage2;
        this.pipelineStage2 = this.memory.getHalfWord(this.registers[15]) & 0xFFFF;
        return n;
    }

    private static byte decodeTHUMB(int n) {
        int n2 = n >>> 8;
        return thumbInstruction[n2];
    }

    private void executeTHUMB(int n, byte by) {
        switch (by) {
            case 1: {
                THUMB_1.execute(this, this.memory, n);
                break;
            }
            case 2: {
                THUMB_2.execute(this, this.memory, n);
                break;
            }
            case 3: {
                THUMB_3.execute(this, this.memory, n);
                break;
            }
            case 4: {
                THUMB_4.execute(this, this.memory, n);
                break;
            }
            case 5: {
                THUMB_5.execute(this, this.memory, n);
                break;
            }
            case 6: {
                THUMB_6.execute(this, this.memory, n);
                break;
            }
            case 7: {
                THUMB_7.execute(this, this.memory, n);
                break;
            }
            case 8: {
                THUMB_8.execute(this, this.memory, n);
                break;
            }
            case 9: {
                THUMB_9.execute(this, this.memory, n);
                break;
            }
            case 10: {
                THUMB_10.execute(this, this.memory, n);
                break;
            }
            case 11: {
                THUMB_11.execute(this, this.memory, n);
                break;
            }
            case 12: {
                THUMB_12.execute(this, this.memory, n);
                break;
            }
            case 13: {
                THUMB_13.execute(this, this.memory, n);
                break;
            }
            case 14: {
                THUMB_14.execute(this, this.memory, n);
                break;
            }
            case 15: {
                THUMB_15.execute(this, this.memory, n);
                break;
            }
            case 16: {
                THUMB_16.execute(this, this.memory, n);
                break;
            }
            case 17: {
                THUMB_17.execute(this, this.memory, n);
                break;
            }
            case 18: {
                THUMB_18.execute(this, this.memory, n);
                break;
            }
            case 19: {
                THUMB_19.execute(this, this.memory, n);
                break;
            }
            case 127: {
                THUMB_Und.execute(this, this.memory, n);
            }
        }
    }

    public String disassembleTHUMB(int n) {
        int n2 = this.memory.getHalfWord(n) & 0xFFFF;
        byte by = ARM7TDMI.decodeTHUMB(n2);
        switch (by) {
            case 1: {
                return THUMB_1.disassemble(this, this.memory, n2, n);
            }
            case 2: {
                return THUMB_2.disassemble(this, this.memory, n2, n);
            }
            case 3: {
                return THUMB_3.disassemble(this, this.memory, n2, n);
            }
            case 4: {
                return THUMB_4.disassemble(this, this.memory, n2, n);
            }
            case 5: {
                return THUMB_5.disassemble(this, this.memory, n2, n);
            }
            case 6: {
                return THUMB_6.disassemble(this, this.memory, n2, n);
            }
            case 7: {
                return THUMB_7.disassemble(this, this.memory, n2, n);
            }
            case 8: {
                return THUMB_8.disassemble(this, this.memory, n2, n);
            }
            case 9: {
                return THUMB_9.disassemble(this, this.memory, n2, n);
            }
            case 10: {
                return THUMB_10.disassemble(this, this.memory, n2, n);
            }
            case 11: {
                return THUMB_11.disassemble(this, this.memory, n2, n);
            }
            case 12: {
                return THUMB_12.disassemble(this, this.memory, n2, n);
            }
            case 13: {
                return THUMB_13.disassemble(this, this.memory, n2, n);
            }
            case 14: {
                return THUMB_14.disassemble(this, this.memory, n2, n);
            }
            case 15: {
                return THUMB_15.disassemble(this, this.memory, n2, n);
            }
            case 16: {
                return THUMB_16.disassemble(this, this.memory, n2, n);
            }
            case 17: {
                return THUMB_17.disassemble(this, this.memory, n2, n);
            }
            case 18: {
                return THUMB_18.disassemble(this, this.memory, n2, n);
            }
            case 19: {
                return THUMB_19.disassemble(this, this.memory, n2, n);
            }
            case 127: {
                return THUMB_Und.disassemble(this, this.memory, n2, n);
            }
        }
        return "";
    }

    private static void initARM() {
        armInstruction = new byte[65536];
        for (int i = 0; i < armInstruction.length; ++i) {
            int n;
            int n2 = (i & 0xFF00) << 12 | (i & 0xFF) << 4;
            switch (n2 >>> 25 & 7) {
                case 0: {
                    if ((n2 & 0xFC000F0) == 144) {
                        n = 7;
                        break;
                    }
                    if ((n2 & 0xF8000F0) == 0x800090) {
                        n = 8;
                        break;
                    }
                    if ((n2 & 0xF0000F0) == 0x1000090) {
                        n = 12;
                        break;
                    }
                    if ((n2 & 0xE000090) == 144) {
                        n = 10;
                        break;
                    }
                    if ((n2 & 0xFF00FF0) == 18878224) {
                        n = 3;
                        break;
                    }
                }
                case 1: {
                    if ((n2 & 0xFB00FF0) == 0x1000000 || (n2 & 0xFB00FF0) == 0x1200000 || (n2 & 0xFB00000) == 0x3200000) {
                        n = 6;
                        break;
                    }
                    n = 5;
                    break;
                }
                case 2: 
                case 3: {
                    if ((n2 & 0xE000010) == 0x6000010) {
                        n = 17;
                        break;
                    }
                    n = 9;
                    break;
                }
                case 4: {
                    n = 11;
                    break;
                }
                case 5: {
                    n = 4;
                    break;
                }
                case 6: 
                case 7: {
                    if ((n2 & 0xE000000) == 0xC000000 || (n2 & 0xF000000) == 0xE000000) {
                        n = 18;
                        break;
                    }
                    n = 13;
                    break;
                }
                default: {
                    n = 17;
                }
            }
            ARM7TDMI.armInstruction[i] = n;
        }
    }

    private int fetchARM() {
        this.registers[15] = this.registers[15] + 4;
        int n = this.pipelineStage1;
        this.pipelineStage1 = this.pipelineStage2;
        this.pipelineStage2 = this.memory.getWord(this.registers[15]);
        return n;
    }

    private static byte decodeARM(int n) {
        int n2 = n >>> 12 & 0xFF00 | n >>> 4 & 0xFF;
        return armInstruction[n2];
    }

    private void executeARM(int n, byte by) {
        switch (by) {
            case 3: {
                ARM_3.execute(this, this.memory, n);
                break;
            }
            case 4: {
                ARM_4.execute(this, this.memory, n);
                break;
            }
            case 5: {
                ARM_5.execute(this, this.memory, n);
                break;
            }
            case 6: {
                ARM_6.execute(this, this.memory, n);
                break;
            }
            case 7: {
                ARM_7.execute(this, this.memory, n);
                break;
            }
            case 8: {
                ARM_8.execute(this, this.memory, n);
                break;
            }
            case 9: {
                ARM_9.execute(this, this.memory, n);
                break;
            }
            case 10: {
                ARM_10.execute(this, this.memory, n);
                break;
            }
            case 11: {
                ARM_11.execute(this, this.memory, n);
                break;
            }
            case 12: {
                ARM_12.execute(this, this.memory, n);
                break;
            }
            case 13: {
                ARM_13.execute(this, this.memory, n);
                break;
            }
            case 17: {
                ARM_17.execute(this, this.memory, n);
                break;
            }
            case 18: {
                ARM_CP.execute(this, this.memory, n);
            }
        }
    }

    public String disassembleARM(int n) {
        int n2 = this.memory.getWord(n);
        byte by = ARM7TDMI.decodeARM(n2);
        switch (by) {
            case 3: {
                return ARM_3.disassemble(this, this.memory, n2, n);
            }
            case 4: {
                return ARM_4.disassemble(this, this.memory, n2, n);
            }
            case 5: {
                return ARM_5.disassemble(this, this.memory, n2, n);
            }
            case 6: {
                return ARM_6.disassemble(this, this.memory, n2, n);
            }
            case 7: {
                return ARM_7.disassemble(this, this.memory, n2, n);
            }
            case 8: {
                return ARM_8.disassemble(this, this.memory, n2, n);
            }
            case 9: {
                return ARM_9.disassemble(this, this.memory, n2, n);
            }
            case 10: {
                return ARM_10.disassemble(this, this.memory, n2, n);
            }
            case 11: {
                return ARM_11.disassemble(this, this.memory, n2, n);
            }
            case 12: {
                return ARM_12.disassemble(this, this.memory, n2, n);
            }
            case 13: {
                return ARM_13.disassemble(this, this.memory, n2, n);
            }
            case 17: {
                return ARM_17.disassemble(this, this.memory, n2, n);
            }
            case 18: {
                return ARM_CP.disassemble(this, this.memory, n2, n);
            }
        }
        return "";
    }
}

