/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.cpu.instruction.ARMState;
import ygba.memory.MemoryInterface;

public final class ARM_11 {
    static final String[] InstructionName = new String[]{"stm", "ldm"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        boolean bl;
        int n2;
        int n3;
        if (!ARMState.isPreconditionSatisfied(aRM7TDMI, n)) {
            return;
        }
        int n4 = n >>> 16 & 0xF;
        int n5 = aRM7TDMI.getRegister(n4);
        int n6 = 0;
        for (n3 = 0; n3 <= 15; ++n3) {
            if ((n & 1 << n3) == 0) continue;
            ++n6;
        }
        n3 = n5 & 0xFFFFFFFC;
        if ((n & 0x800000) != 0) {
            n2 = n3 + (n6 << 2);
            if ((n & 0x1000000) != 0) {
                n3 += 4;
            }
        } else {
            n3 = n2 = n3 - (n6 << 2);
            if ((n & 0x1000000) == 0) {
                n3 += 4;
            }
        }
        boolean bl2 = (n & 0x8000) != 0;
        boolean bl3 = bl = (n & 0x400000) != 0;
        if ((n & 0x100000) == 0) {
            int n7;
            int n8 = bl ? 16 : aRM7TDMI.getMode();
            for (n7 = 0; n7 < 15; ++n7) {
                if ((n & 1 << n7) == 0) continue;
                memoryInterface.storeWord(n3, aRM7TDMI.getRegister(n7));
                n3 += 4;
                break;
            }
            if ((n & 0x200000) != 0) {
                aRM7TDMI.setRegister(n4, n5 & 3 | n2);
            }
            ++n7;
            while (n7 < 15) {
                if ((n & 1 << n7) != 0) {
                    memoryInterface.storeWord(n3, aRM7TDMI.getRegister(n7));
                    n3 += 4;
                }
                ++n7;
            }
            if (bl2) {
                memoryInterface.storeWord(n3, aRM7TDMI.getPC() + 4);
            }
        } else {
            int n9;
            int n10 = bl && !bl2 ? 16 : (n9 = aRM7TDMI.getMode());
            if ((n & 0x200000) != 0) {
                aRM7TDMI.setRegister(n4, n5 & 3 | n2);
            }
            for (int i = 0; i < 15; ++i) {
                if ((n & 1 << i) == 0) continue;
                aRM7TDMI.setRegister(i, memoryInterface.loadWord(n3));
                n3 += 4;
            }
            if (bl2) {
                aRM7TDMI.setPC(memoryInterface.loadWord(n3));
                if (bl) {
                    aRM7TDMI.setCPSR(aRM7TDMI.getSPSR());
                }
                aRM7TDMI.flushPipeline();
            }
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 20 & 1;
        String string = ARMState.getPreconditionSuffix(n);
        String string2 = ((n & 0x800000) == 0 ? "d" : "i") + ((n & 0x1000000) == 0 ? "a" : "b");
        String string3 = aRM7TDMI.getRegisterName(n >>> 16 & 0xF);
        String string4 = (n & 0x200000) != 0 ? "!" : "";
        String string5 = (n & 0x400000) != 0 ? "^" : "";
        String string6 = "";
        int n4 = n & 0xFFFF;
        int n5 = -1;
        for (int n6 = 0; n6 <= 16; n6 = (int)((byte)(n6 + 1))) {
            if ((n4 & 1 << n6) == 0) {
                if (n5 == -1) continue;
                string6 = string6 + "%" + aRM7TDMI.getRegisterName(n5);
                int n7 = n6 - 1;
                if (n5 < n7) {
                    string6 = n5 == n7 - 1 ? string6 + "%" + aRM7TDMI.getRegisterName(n7) : string6 + "-" + aRM7TDMI.getRegisterName(n7);
                }
                n5 = -1;
                continue;
            }
            if (n5 != -1) continue;
            n5 = n6;
        }
        string6 = string6.replaceFirst("%", "").replaceAll("%", ", ");
        return InstructionName[n3] + string + string2 + " " + string3 + string4 + ", " + "{" + string6 + "}" + string5;
    }
}

