/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.cpu.instruction.ARMState;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class ARM_5 {
    static final String[] InstructionName = new String[]{"and", "eor", "sub", "rsb", "add", "adc", "sbc", "rsc", "tst", "teq", "cmp", "cmn", "orr", "mov", "bic", "mvn"};
    static final String[] ShiftInstructionName = new String[]{"lsl", "lsr", "asr", "ror"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (!ARMState.isPreconditionSatisfied(aRM7TDMI, n)) {
            return;
        }
        int n6 = n >>> 16 & 0xF;
        int n7 = aRM7TDMI.getRegister(n6);
        boolean bl = aRM7TDMI.getCFlag();
        int n8 = n7;
        if ((n & 0x2000000) != 0) {
            n5 = n & 0xFF;
            n4 = (n & 0xF00) >>> 7;
            if (n4 != 0) {
                bl = (n5 & 1 << n4 - 1) != 0;
                n5 = n5 << 32 - n4 | n5 >>> n4;
            }
        } else {
            n4 = n & 0xF;
            n3 = aRM7TDMI.getRegister(n4);
            n2 = n & 0x60;
            n5 = n3;
            if ((n & 0x10) == 0) {
                int n9 = n >>> 7 & 0x1F;
                switch (n2) {
                    case 0: {
                        if (n9 == 0) break;
                        bl = (n5 & 1 << 32 - n9) != 0;
                        n5 <<= n9;
                        break;
                    }
                    case 32: {
                        if (n9 != 0) {
                            bl = (n5 & 1 << n9 - 1) != 0;
                            n5 >>>= n9;
                            break;
                        }
                        bl = (n5 & Integer.MIN_VALUE) != 0;
                        n5 = 0;
                        break;
                    }
                    case 64: {
                        if (n9 != 0) {
                            bl = (n5 & 1 << n9 - 1) != 0;
                            n5 >>= n9;
                            break;
                        }
                        bl = (n5 & Integer.MIN_VALUE) != 0;
                        n5 >>= 31;
                        break;
                    }
                    case 96: {
                        if (n9 != 0) {
                            bl = (n5 & 1 << n9 - 1) != 0;
                            n5 = n5 << 32 - n9 | n5 >>> n9;
                            break;
                        }
                        bl = (n5 & 1) != 0;
                        n5 >>>= 1;
                        if (!aRM7TDMI.getCFlag()) break;
                        n5 |= Integer.MIN_VALUE;
                    }
                }
            } else {
                int n10 = n >>> 8 & 0xF;
                int n11 = aRM7TDMI.getRegister(n10);
                int n12 = n11 + (n10 == 15 ? 4 : 0) & 0xFF;
                switch (n2) {
                    case 0: {
                        if (n12 == 0) break;
                        if (n12 < 32) {
                            bl = (n5 & 1 << 32 - n12) != 0;
                            n5 <<= n12;
                            break;
                        }
                        if (n12 == 32) {
                            bl = (n5 & 1) != 0;
                            n5 = 0;
                            break;
                        }
                        bl = false;
                        n5 = 0;
                        break;
                    }
                    case 32: {
                        if (n12 == 0) break;
                        if (n12 < 32) {
                            bl = (n5 & 1 << n12 - 1) != 0;
                            n5 >>>= n12;
                            break;
                        }
                        if (n12 == 32) {
                            bl = (n5 & Integer.MIN_VALUE) != 0;
                            n5 = 0;
                            break;
                        }
                        bl = false;
                        n5 = 0;
                        break;
                    }
                    case 64: {
                        if (n12 == 0) break;
                        if (n12 < 32) {
                            bl = (n5 & 1 << n12 - 1) != 0;
                            n5 >>= n12;
                            break;
                        }
                        bl = (n5 & Integer.MIN_VALUE) != 0;
                        n5 >>= 31;
                        break;
                    }
                    case 96: {
                        if (n12 != 0) {
                            if ((n12 &= 0x1F) != 0) {
                                bl = (n5 & 1 << n12 - 1) != 0;
                                n5 = n5 << 32 - n12 | n5 >>> n12;
                                break;
                            }
                            bl = (n5 & Integer.MIN_VALUE) != 0;
                            break;
                        }
                        bl = (n5 & Integer.MIN_VALUE) != 0;
                    }
                }
            }
        }
        n4 = n >>> 12 & 0xF;
        n2 = (n & 0x100000) != 0 ? 1 : 0;
        switch (n & 0x1E00000) {
            case 0: {
                n3 = n8 & n5;
                aRM7TDMI.setRegister(n4, n3);
                if (n2 == 0) break;
                aRM7TDMI.setCFlag(bl);
                break;
            }
            case 0x200000: {
                n3 = n8 ^ n5;
                aRM7TDMI.setRegister(n4, n3);
                if (n2 == 0) break;
                aRM7TDMI.setCFlag(bl);
                break;
            }
            case 0x400000: {
                n3 = n8 - n5;
                aRM7TDMI.setRegister(n4, n3);
                if (n2 == 0) break;
                aRM7TDMI.setVCFlagsForSUB(n8, n5, n3);
                break;
            }
            case 0x600000: {
                n3 = n5 - n8;
                aRM7TDMI.setRegister(n4, n3);
                if (n2 == 0) break;
                aRM7TDMI.setVCFlagsForSUB(n5, n8, n3);
                break;
            }
            case 0x800000: {
                n3 = n8 + n5;
                aRM7TDMI.setRegister(n4, n3);
                if (n2 == 0) break;
                aRM7TDMI.setVCFlagsForADD(n8, n5, n3);
                break;
            }
            case 0xA00000: {
                n3 = n8 + n5 + (aRM7TDMI.getCFlag() ? 1 : 0);
                aRM7TDMI.setRegister(n4, n3);
                if (n2 == 0) break;
                aRM7TDMI.setVCFlagsForADD(n8, n5, n3);
                break;
            }
            case 0xC00000: {
                n3 = n8 - n5 - (aRM7TDMI.getCFlag() ? 0 : 1);
                aRM7TDMI.setRegister(n4, n3);
                if (n2 == 0) break;
                aRM7TDMI.setVCFlagsForSUB(n8, n5, n3);
                break;
            }
            case 0xE00000: {
                n3 = n5 - n8 - (aRM7TDMI.getCFlag() ? 0 : 1);
                aRM7TDMI.setRegister(n4, n3);
                if (n2 == 0) break;
                aRM7TDMI.setVCFlagsForSUB(n5, n8, n3);
                break;
            }
            case 0x1000000: {
                n3 = n8 & n5;
                aRM7TDMI.setCFlag(bl);
                break;
            }
            case 0x1200000: {
                n3 = n8 ^ n5;
                aRM7TDMI.setCFlag(bl);
                break;
            }
            case 0x1400000: {
                n3 = n8 - n5;
                aRM7TDMI.setVCFlagsForSUB(n8, n5, n3);
                break;
            }
            case 0x1600000: {
                n3 = n8 + n5;
                aRM7TDMI.setVCFlagsForADD(n8, n5, n3);
                break;
            }
            case 0x1800000: {
                n3 = n8 | n5;
                aRM7TDMI.setRegister(n4, n3);
                if (n2 == 0) break;
                aRM7TDMI.setCFlag(bl);
                break;
            }
            case 0x1A00000: {
                n3 = n5;
                aRM7TDMI.setRegister(n4, n3);
                if (n2 == 0) break;
                aRM7TDMI.setCFlag(bl);
                break;
            }
            case 0x1C00000: {
                n3 = n8 & ~n5;
                aRM7TDMI.setRegister(n4, n3);
                if (n2 == 0) break;
                aRM7TDMI.setCFlag(bl);
                break;
            }
            case 0x1E00000: {
                n3 = ~n5;
                aRM7TDMI.setRegister(n4, n3);
                if (n2 == 0) break;
                aRM7TDMI.setCFlag(bl);
                break;
            }
            default: {
                n3 = 0;
            }
        }
        if (n2 != 0) {
            aRM7TDMI.setNFlag(n3 < 0);
            aRM7TDMI.setZFlag(n3 == 0);
        }
        if (n4 == 15) {
            if (n2 != 0) {
                aRM7TDMI.setCPSR(aRM7TDMI.getSPSR());
            }
            aRM7TDMI.flushPipeline();
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        String string;
        int n3 = n >>> 21 & 0xF;
        String string2 = ARMState.getPreconditionSuffix(n);
        boolean bl = n3 >= 8 && n3 <= 11;
        boolean bl2 = n3 == 13 || n3 == 15;
        String string3 = (n & 0x100000) == 0 || bl ? "" : "s";
        String string4 = aRM7TDMI.getRegisterName(n >>> 12 & 0xF);
        String string5 = aRM7TDMI.getRegisterName(n >>> 16 & 0xF);
        if ((n & 0x2000000) != 0) {
            int n4 = n & 0xFF;
            int n5 = (n & 0xF00) >>> 7;
            if (n5 != 0) {
                n4 = n4 << 32 - n5 | n4 >>> n5;
            }
            string = Hex.toHexString(n4);
        } else {
            int n6 = n >>> 5 & 3;
            string = aRM7TDMI.getRegisterName(n & 0xF) + ", " + ShiftInstructionName[n6];
            string = (n & 0x10) != 0 ? string + " " + aRM7TDMI.getRegisterName(n >>> 8 & 0xF) : string + "#" + (n >>> 7 & 0x1F);
        }
        return InstructionName[n3] + string2 + string3 + " " + (bl ? "" : string4 + ", ") + (bl2 ? "" : string5 + ", ") + string;
    }
}

