/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.cpu.instruction.ARMState;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class ARM_9 {
    static final String[] InstructionName = new String[]{"str", "ldr"};
    static final String[] ShiftInstructionName = new String[]{"lsl", "lsr", "asr", "ror"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (!ARMState.isPreconditionSatisfied(aRM7TDMI, n)) {
            return;
        }
        int n7 = n >>> 12 & 0xF;
        int n8 = n >>> 16 & 0xF;
        int n9 = aRM7TDMI.getRegister(n8);
        if ((n & 0x2000000) == 0) {
            n6 = n & 0xFFF;
        } else {
            n5 = n & 0xF;
            n4 = aRM7TDMI.getRegister(n5);
            n3 = n & 0x60;
            n2 = n >>> 7 & 0x1F;
            n6 = n4;
            switch (n3) {
                case 0: {
                    if (n2 == 0) break;
                    n6 <<= n2;
                    break;
                }
                case 32: {
                    if (n2 != 0) {
                        n6 >>>= n2;
                        break;
                    }
                    n6 = 0;
                    break;
                }
                case 64: {
                    if (n2 != 0) {
                        n6 >>= n2;
                        break;
                    }
                    n6 >>= 31;
                    break;
                }
                case 96: {
                    if (n2 != 0) {
                        n6 = n6 << 32 - n2 | n6 >>> n2;
                        break;
                    }
                    n6 >>>= 1;
                    if (!aRM7TDMI.getCFlag()) break;
                    n6 |= Integer.MIN_VALUE;
                }
            }
        }
        n5 = (n & 0x1000000) == 0 ? 1 : 0;
        n4 = (n & 0x800000) == 0 ? 1 : 0;
        n3 = (n & 0x400000) == 0 ? 1 : 0;
        int n10 = n2 = n5 != 0 || (n & 0x200000) != 0 ? 1 : 0;
        if (n4 != 0) {
            n6 = -n6;
        }
        if (n5 == 0) {
            n9 += n6;
        }
        if ((n & 0x100000) == 0) {
            int n11 = aRM7TDMI.getRegister(n7);
            if (n7 == 15) {
                n11 += 4;
            }
            if (n3 != 0) {
                memoryInterface.storeWord(n9, n11);
            } else {
                memoryInterface.storeByte(n9, (byte)n11);
            }
        } else {
            if (n3 != 0) {
                aRM7TDMI.setRegister(n7, memoryInterface.loadWord(n9));
            } else {
                aRM7TDMI.setRegister(n7, memoryInterface.loadByte(n9) & 0xFF);
            }
            if (n7 == 15) {
                aRM7TDMI.flushARMPipeline();
            }
            if (n7 == n8) {
                return;
            }
        }
        if (n2 != 0) {
            if (n5 != 0) {
                n9 += n6;
            }
            aRM7TDMI.setRegister(n8, n9);
            if (n8 == 15) {
                aRM7TDMI.flushARMPipeline();
            }
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        String string;
        String string2;
        String string3;
        String string4;
        int n3 = n >>> 20 & 1;
        String string5 = ARMState.getPreconditionSuffix(n);
        boolean bl = (n & 0x1000000) == 0;
        boolean bl2 = (n & 0x200000) != 0;
        String string6 = (n & 0x400000) != 0 ? "b" : "";
        String string7 = bl2 && bl ? "t" : "";
        String string8 = aRM7TDMI.getRegisterName(n >>> 12 & 0xF);
        String string9 = aRM7TDMI.getRegisterName(n >>> 16 & 0xF);
        String string10 = string4 = (n & 0x800000) == 0 ? "-" : "";
        if ((n & 0x2000000) == 0) {
            string3 = "<" + string4 + Hex.toHexString(n & 0xFFF, (byte)3) + ">";
        } else {
            int n4 = n >>> 5 & 3;
            int n5 = n >>> 7 & 0xF;
            string3 = string4 + aRM7TDMI.getRegisterName(n & 0xF);
            if (n4 != 0 || n5 != 0) {
                string3 = string3 + ", " + ShiftInstructionName[n4] + "#" + n5;
            }
        }
        if (bl) {
            string2 = "[" + string9 + "], ";
            string = "";
        } else {
            string2 = "[" + string9 + ", ";
            string = "]" + (bl2 ? "!" : "");
        }
        string3 = string2 + string3 + string;
        return InstructionName[n3] + string5 + string6 + string7 + " " + string8 + ", " + string3;
    }
}

