/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class THUMB_12 {
    static final String InstructionName = "add";

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2 = n >>> 8 & 7;
        int n3 = (n & 0x800) == 0 ? aRM7TDMI.getPC() & 0xFFFFFFFC : aRM7TDMI.getSP();
        int n4 = (n & 0xFF) << 2;
        aRM7TDMI.setRegister(n2, n3 + n4);
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        String string = aRM7TDMI.getRegisterName(n >>> 8 & 7);
        String string2 = aRM7TDMI.getRegisterName((n & 0x800) == 0 ? 15 : 13);
        int n3 = (n & 0xFF) << 2;
        return "add " + string + ", " + string2 + ", " + Hex.toHexString(n3, (byte)3);
    }
}

