/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class THUMB_3 {
    static final String[] InstructionName = new String[]{"mov", "cmp", "add", "sub"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2 = n >>> 8 & 7;
        int n3 = aRM7TDMI.getRegister(n2);
        int n4 = 0;
        int n5 = n & 0xFF;
        switch (n & 0x1800) {
            case 0: {
                n4 = n5;
                aRM7TDMI.setRegister(n2, n4);
                break;
            }
            case 2048: {
                n4 = n3 - n5;
                aRM7TDMI.setVCFlagsForSUB(n3, n5, n4);
                break;
            }
            case 4096: {
                n4 = n3 + n5;
                aRM7TDMI.setVCFlagsForADD(n3, n5, n4);
                aRM7TDMI.setRegister(n2, n4);
                break;
            }
            case 6144: {
                n4 = n3 - n5;
                aRM7TDMI.setVCFlagsForSUB(n3, n5, n4);
                aRM7TDMI.setRegister(n2, n4);
                break;
            }
        }
        aRM7TDMI.setZFlag(n4 == 0);
        aRM7TDMI.setNFlag(n4 < 0);
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 11 & 3;
        String string = aRM7TDMI.getRegisterName(n >>> 8 & 7);
        int n4 = n & 0xFF;
        return InstructionName[n3] + " " + string + ", " + Hex.toHexString(n4, (byte)2);
    }
}

