/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;

public final class THUMB_5 {
    static final String[] InstructionName = new String[]{"add", "cmp", "mov", "bx"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2 = n >>> 3 & 0xF;
        int n3 = aRM7TDMI.getRegister(n2);
        switch (n & 0x300) {
            case 0: {
                int n4 = n & 7 | (n & 0x80) >>> 4;
                int n5 = aRM7TDMI.getRegister(n4);
                aRM7TDMI.setRegister(n4, n5 + n3);
                if (n4 != 15) break;
                aRM7TDMI.flushTHUMBPipeline();
                break;
            }
            case 256: {
                int n6 = n & 7 | (n & 0x80) >>> 4;
                int n7 = aRM7TDMI.getRegister(n6);
                int n8 = n7 - n3;
                aRM7TDMI.setVCFlagsForSUB(n7, n3, n8);
                aRM7TDMI.setZFlag(n8 == 0);
                aRM7TDMI.setNFlag(n8 < 0);
                break;
            }
            case 512: {
                int n9 = n & 7 | (n & 0x80) >>> 4;
                aRM7TDMI.setRegister(n9, n3);
                if (n9 != 15) break;
                aRM7TDMI.flushTHUMBPipeline();
                break;
            }
            case 768: {
                aRM7TDMI.setTFlag((n3 & 1) != 0);
                aRM7TDMI.setPC(n3);
                aRM7TDMI.flushPipeline();
                break;
            }
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 8 & 3;
        String string = aRM7TDMI.getRegisterName(n >>> 3 & 0xF);
        String string2 = aRM7TDMI.getRegisterName(n & 7 | (n & 0x80) >>> 4);
        return InstructionName[n3] + " " + (n3 != 3 ? string2 + ", " : "") + string;
    }
}

