/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;

public final class THUMB_8 {
    static final String[] InstructionName = new String[]{"strh", "ldsb", "ldrh", "ldsh"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2 = n & 7;
        int n3 = n >>> 3 & 7;
        int n4 = n >>> 6 & 7;
        int n5 = aRM7TDMI.getRegister(n3) + aRM7TDMI.getRegister(n4);
        switch (n & 0xC00) {
            case 0: {
                memoryInterface.storeHalfWord(n5, (short)aRM7TDMI.getRegister(n2));
                break;
            }
            case 1024: {
                aRM7TDMI.setRegister(n2, memoryInterface.loadByte(n5));
                break;
            }
            case 2048: {
                aRM7TDMI.setRegister(n2, memoryInterface.loadHalfWord(n5) & 0xFFFF);
                break;
            }
            case 3072: {
                aRM7TDMI.setRegister(n2, memoryInterface.loadHalfWord(n5));
                break;
            }
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 10 & 3;
        String string = aRM7TDMI.getRegisterName(n & 7);
        String string2 = aRM7TDMI.getRegisterName(n >>> 3 & 7);
        String string3 = aRM7TDMI.getRegisterName(n >>> 6 & 7);
        return InstructionName[n3] + " " + string + ", [" + string2 + ", " + string3 + "]";
    }
}

