/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class THUMB_9 {
    static final String[] InstructionName = new String[]{"str", "ldr", "strb", "ldrb"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2 = n & 7;
        int n3 = n >>> 3 & 7;
        int n4 = aRM7TDMI.getRegister(n3);
        int n5 = n >>> 6 & 0x1F;
        switch (n & 0x1800) {
            case 0: {
                memoryInterface.storeWord(n4 + (n5 << 2), aRM7TDMI.getRegister(n2));
                break;
            }
            case 2048: {
                aRM7TDMI.setRegister(n2, memoryInterface.loadWord(n4 + (n5 << 2)));
                break;
            }
            case 4096: {
                memoryInterface.storeByte(n4 + n5, (byte)aRM7TDMI.getRegister(n2));
                break;
            }
            case 6144: {
                aRM7TDMI.setRegister(n2, memoryInterface.loadByte(n4 + n5) & 0xFF);
                break;
            }
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 11 & 3;
        String string = aRM7TDMI.getRegisterName(n & 7);
        String string2 = aRM7TDMI.getRegisterName(n >>> 3 & 7);
        int n4 = n >>> 6 & 0x1F;
        if ((n & 0x1000) == 0) {
            n4 <<= 2;
        }
        return InstructionName[n3] + " " + string + ", [" + string2 + ", " + Hex.toHexString(n4, (byte)2) + "]";
    }
}

