/*
 * Decompiled with CFR 0.152.
 */
package ygba.memory;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import ygba.dma.DirectMemoryAccess;
import ygba.gfx.GFX;
import ygba.memory.EWorkMemory;
import ygba.memory.GamePakMemory;
import ygba.memory.IORegMemory;
import ygba.memory.IWorkMemory;
import ygba.memory.MemoryInterface;
import ygba.memory.MemoryManager;
import ygba.memory.ObjectMemory;
import ygba.memory.PaletteMemory;
import ygba.memory.SaveMemory;
import ygba.memory.SystemMemory;
import ygba.memory.UnusedMemory;
import ygba.memory.VideoMemory;
import ygba.time.Time;
import ygba.util.Hex;

public final class Memory
implements MemoryInterface {
    private final int MemoryBankMask = 0xF000000;
    private final int MemoryAddressMask = 0xFFFFFF;
    private MemoryInterface[] bank = new MemoryInterface[16];
    private SystemMemory sysMem = new SystemMemory();
    private GamePakMemory gp1Mem = new GamePakMemory(1);
    private GamePakMemory gp2Mem = new GamePakMemory(2);
    private boolean isBIOSLoaded;
    private boolean isROMLoaded;
    private long fileSize;

    public Memory() {
        this.bank[0] = this.sysMem;
        this.bank[1] = new UnusedMemory();
        this.bank[2] = new EWorkMemory();
        this.bank[3] = new IWorkMemory();
        this.bank[4] = new IORegMemory();
        this.bank[5] = new PaletteMemory();
        this.bank[6] = new VideoMemory();
        this.bank[7] = new ObjectMemory();
        this.bank[10] = this.bank[12] = this.gp1Mem;
        this.bank[8] = this.bank[12];
        this.bank[11] = this.bank[13] = this.gp2Mem;
        this.bank[9] = this.bank[13];
        this.bank[14] = this.bank[15] = new SaveMemory();
        this.isROMLoaded = false;
        this.isBIOSLoaded = false;
        this.fileSize = 0L;
    }

    public void connectToDMA(DirectMemoryAccess directMemoryAccess) {
        this.getIORegMemory().connectToDMA(directMemoryAccess);
    }

    public void connectToGraphics(GFX gFX) {
        this.getIORegMemory().connectToGraphics(gFX);
    }

    public void connectToTime(Time time) {
        this.getIORegMemory().connectToTime(time);
    }

    public MemoryInterface getBank(int n) {
        return this.bank[n & 0xF];
    }

    public IORegMemory getIORegMemory() {
        return (IORegMemory)this.getBank(4);
    }

    public int getInternalOffset(int n, int n2) {
        return ((MemoryManager)this.getBank(n)).getInternalOffset(n2);
    }

    public int getSize(int n) {
        return ((MemoryManager)this.getBank(n)).getSize();
    }

    public String getDescription(int n) {
        String string = Hex.toAddrString(n << 24, (byte)8);
        MemoryManager memoryManager = (MemoryManager)this.bank[n];
        String string2 = memoryManager.getName();
        String string3 = memoryManager.getSize() / 1024 + "KB";
        return string + " - " + string2 + " - " + string3;
    }

    public byte getByte(int n) {
        return this.bank[(n & 0xF000000) >>> 24].getByte(n);
    }

    public short getHalfWord(int n) {
        return this.bank[(n & 0xF000000) >>> 24].getHalfWord(n);
    }

    public int getWord(int n) {
        return this.bank[(n & 0xF000000) >>> 24].getWord(n);
    }

    public void setByte(int n, byte by) {
        this.bank[(n & 0xF000000) >>> 24].setByte(n, by);
    }

    public void setHalfWord(int n, short s) {
        this.bank[(n & 0xF000000) >>> 24].setHalfWord(n, s);
    }

    public void setWord(int n, int n2) {
        this.bank[(n & 0xF000000) >>> 24].setWord(n, n2);
    }

    public byte loadByte(int n) {
        return this.bank[(n & 0xF000000) >>> 24].loadByte(n);
    }

    public short loadHalfWord(int n) {
        return this.bank[(n & 0xF000000) >>> 24].loadHalfWord(n);
    }

    public int loadWord(int n) {
        return this.bank[(n & 0xF000000) >>> 24].loadWord(n);
    }

    public void storeByte(int n, byte by) {
        this.bank[(n & 0xF000000) >>> 24].storeByte(n, by);
    }

    public void storeHalfWord(int n, short s) {
        this.bank[(n & 0xF000000) >>> 24].storeHalfWord(n, s);
    }

    public void storeWord(int n, int n2) {
        this.bank[(n & 0xF000000) >>> 24].storeWord(n, n2);
    }

    public void softReset() {
        for (int i = 0; i < this.bank.length; ++i) {
            ((MemoryManager)this.bank[i]).softReset();
        }
    }

    public void hardReset() {
        for (int i = 0; i < this.bank.length; ++i) {
            ((MemoryManager)this.bank[i]).hardReset();
        }
    }

    public void reset() {
        this.softReset();
    }

    private boolean isGBAFile(String string) {
        return (string = string.toLowerCase()).endsWith(".gba") || string.endsWith(".agb") || string.endsWith(".bin");
    }

    private InputStream openFile(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        String string = uRL.getFile();
        if (string.toLowerCase().endsWith(".zip")) {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) == null || !this.isGBAFile(string = zipEntry.getName())) {
            }
            this.fileSize = zipEntry.getSize();
            return zipInputStream;
        }
        if (this.isGBAFile(string)) {
            this.fileSize = uRLConnection.getContentLength();
            return inputStream;
        }
        return null;
    }

    private void readStream(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        while ((n = inputStream.read(byArray, n2 += n, n3 -= n)) != -1 && n3 > 0) {
        }
    }

    public boolean isBIOSLoaded() {
        return this.isBIOSLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadBIOS(URL uRL) {
        try {
            InputStream inputStream = this.openFile(uRL);
            int n = (int)this.fileSize;
            if (n != 16384) {
                throw new IOException("Wrong BIOS size");
            }
            this.readStream(inputStream, this.sysMem.getSpace());
            inputStream.close();
            this.isBIOSLoaded = true;
            return this.isBIOSLoaded;
        }
        catch (IOException iOException) {
            System.out.println("Failed loading BIOS file: " + iOException.getMessage());
            this.unloadBIOS();
        }
        finally {
            return this.isBIOSLoaded;
        }
    }

    public void unloadBIOS() {
        this.sysMem.hardReset();
        this.fileSize = 0L;
        this.isBIOSLoaded = false;
    }

    public boolean isROMLoaded() {
        return this.isROMLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadROM(URL uRL) {
        try {
            int n;
            int n2;
            InputStream inputStream = this.openFile(uRL);
            int n3 = (int)this.fileSize;
            if (n3 <= 0x1000000) {
                n2 = n3;
                n = 0;
            } else if (n3 <= 0x2000000) {
                n2 = 0x1000000;
                n = n3 - n2;
            } else {
                throw new IOException("Invalid ROM size");
            }
            byte[] byArray = this.gp1Mem.createSpace(n2);
            byte[] byArray2 = this.gp2Mem.createSpace(n);
            this.readStream(inputStream, byArray);
            this.readStream(inputStream, byArray2);
            inputStream.close();
            this.isROMLoaded = true;
            return this.isROMLoaded;
        }
        catch (IOException iOException) {
            System.out.println("Failed loading ROM file: " + iOException.getMessage());
            this.unloadROM();
        }
        finally {
            return this.isROMLoaded;
        }
    }

    public void unloadROM() {
        this.gp1Mem.createSpace(0);
        this.gp2Mem.createSpace(0);
        this.fileSize = 0L;
        this.isROMLoaded = false;
    }
}

