/*
 * Decompiled with CFR 0.152.
 */
package ygba.memory;

import ygba.memory.MemoryManager_16_32;

public final class ObjectMemory
extends MemoryManager_16_32 {
    public ObjectMemory() {
        super("Object RAM", 1024);
    }

    public int getPriority(int n) {
        int n2 = n << 3;
        return this.space[n2 + 5] >>> 2 & 3;
    }

    public int getXSize(int n) {
        int n2 = n << 3;
        switch ((this.space[n2 + 1] & 0xC0) >>> 6 | (this.space[n2 + 3] & 0xC0) >>> 4) {
            case 0: 
            case 2: 
            case 6: {
                return 8;
            }
            case 1: 
            case 4: 
            case 10: {
                return 16;
            }
            case 5: 
            case 8: 
            case 9: 
            case 14: {
                return 32;
            }
            case 12: 
            case 13: {
                return 64;
            }
        }
        return 0;
    }

    public int getYSize(int n) {
        int n2 = n << 3;
        switch ((this.space[n2 + 1] & 0xC0) >>> 6 | (this.space[n2 + 3] & 0xC0) >>> 4) {
            case 0: 
            case 1: 
            case 5: {
                return 8;
            }
            case 2: 
            case 4: 
            case 9: {
                return 16;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                return 32;
            }
            case 12: 
            case 14: {
                return 64;
            }
        }
        return 0;
    }

    public int getXCoordinate(int n) {
        int n2 = n << 3;
        return this.space[n2 + 2] & 0xFF | this.space[n2 + 3] << 31 >> 23;
    }

    public int getYCoordinate(int n) {
        int n2 = n << 3;
        return this.space[n2] & 0xFF;
    }

    public boolean isMosaicEnabled(int n) {
        int n2 = n << 3;
        return (this.space[n2 + 1] & 0x10) != 0;
    }

    public boolean is256ColorPalette(int n) {
        int n2 = n << 3;
        return (this.space[n2 + 1] & 0x20) != 0;
    }

    public int getPaletteNumber(int n) {
        int n2 = n << 3;
        return (this.space[n2 + 5] & 0xF0) >>> 4;
    }

    public int getTileNumber(int n) {
        int n2 = n << 3;
        return this.space[n2 + 4] & 0xFF | (this.space[n2 + 5] & 3) << 8;
    }

    public boolean isRotScalEnabled(int n) {
        int n2 = n << 3;
        return (this.space[n2 + 1] & 1) != 0;
    }

    public boolean isDoubleSizeEnabled(int n) {
        int n2 = n << 3;
        return (this.space[n2 + 1] & 2) != 0;
    }

    public int getRotScalGroupNumber(int n) {
        int n2 = n << 3;
        return this.space[n2 + 3] >>> 1 & 0x1F;
    }

    public short getPA(int n) {
        int n2 = (n << 5) + 6;
        return (short)(this.space[n2 + 1] << 8 | this.space[n2] & 0xFF);
    }

    public short getPB(int n) {
        int n2 = (n << 5) + 14;
        return (short)(this.space[n2 + 1] << 8 | this.space[n2] & 0xFF);
    }

    public short getPC(int n) {
        int n2 = (n << 5) + 22;
        return (short)(this.space[n2 + 1] << 8 | this.space[n2] & 0xFF);
    }

    public short getPD(int n) {
        int n2 = (n << 5) + 30;
        return (short)(this.space[n2 + 1] << 8 | this.space[n2] & 0xFF);
    }

    public boolean isDisplayable(int n) {
        int n2 = n << 3;
        return (this.space[n2 + 1] & 2) == 0;
    }

    public boolean isHFlipEnabled(int n) {
        int n2 = n << 3;
        return (this.space[n2 + 3] & 0x10) != 0;
    }

    public boolean isVFlipEnabled(int n) {
        int n2 = n << 3;
        return (this.space[n2 + 3] & 0x20) != 0;
    }
}

