/*
 * Decompiled with CFR 0.152.
 */
package ygba.ui;

import ygba.cpu.ARM7TDMI;
import ygba.memory.Memory;
import ygba.ui.InternationalTableModel;
import ygba.util.Hex;

final class ProgramViewerTableModel
extends InternationalTableModel {
    private ARM7TDMI cpu;
    private Memory memory;
    private int memoryBank;

    public ProgramViewerTableModel(ARM7TDMI aRM7TDMI, Memory memory) {
        this.cpu = aRM7TDMI;
        this.memory = memory;
        this.columnName = new String[3];
        this.columnName[0] = "Offset";
        this.columnName[1] = "Opcode";
        this.columnName[2] = "Instruction";
        this.memoryBank = 0;
    }

    protected int getMemoryBank() {
        return this.memoryBank;
    }

    protected void setMemoryBank(int n) {
        this.memoryBank = n;
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.memory.getSize(this.memoryBank) >>> (this.cpu.getTFlag() ? 1 : 2);
    }

    public Object getValueAt(int n, int n2) {
        int n3 = this.memoryBank << 24;
        if (this.cpu.getTFlag()) {
            n3 += n << 1;
            switch (n2) {
                case 0: {
                    return Hex.toAddrString(n3, (byte)8);
                }
                case 1: {
                    return Hex.toHexString(this.memory.getHalfWord(n3), (byte)4);
                }
                case 2: {
                    return this.cpu.disassembleTHUMB(n3);
                }
            }
            return "";
        }
        n3 += n << 2;
        switch (n2) {
            case 0: {
                return Hex.toAddrString(n3, (byte)8);
            }
            case 1: {
                return Hex.toHexString(this.memory.getWord(n3), (byte)8);
            }
            case 2: {
                return this.cpu.disassembleARM(n3);
            }
        }
        return "";
    }
}

