/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;

public final class ARMState {
    private static final String[] PreconditionSuffix = new String[]{"eq", "ne", "cs", "cc", "mi", "pl", "vs", "vc", "hi", "ls", "ge", "lt", "gt", "le", "", "nv"};

    protected static boolean isPreconditionSatisfied(ARM7TDMI aRM7TDMI, int n) {
        boolean bl;
        switch (n & 0xF0000000) {
            case 0: {
                bl = aRM7TDMI.getZFlag();
                break;
            }
            case 0x10000000: {
                bl = !aRM7TDMI.getZFlag();
                break;
            }
            case 0x20000000: {
                bl = aRM7TDMI.getCFlag();
                break;
            }
            case 0x30000000: {
                bl = !aRM7TDMI.getCFlag();
                break;
            }
            case 0x40000000: {
                bl = aRM7TDMI.getNFlag();
                break;
            }
            case 0x50000000: {
                bl = !aRM7TDMI.getNFlag();
                break;
            }
            case 0x60000000: {
                bl = aRM7TDMI.getVFlag();
                break;
            }
            case 0x70000000: {
                bl = !aRM7TDMI.getVFlag();
                break;
            }
            case -2147483648: {
                bl = aRM7TDMI.getCFlag() && !aRM7TDMI.getZFlag();
                break;
            }
            case -1879048192: {
                bl = !aRM7TDMI.getCFlag() || aRM7TDMI.getZFlag();
                break;
            }
            case -1610612736: {
                bl = aRM7TDMI.getNFlag() == aRM7TDMI.getVFlag();
                break;
            }
            case -1342177280: {
                bl = aRM7TDMI.getNFlag() != aRM7TDMI.getVFlag();
                break;
            }
            case -1073741824: {
                bl = !aRM7TDMI.getZFlag() && aRM7TDMI.getNFlag() == aRM7TDMI.getVFlag();
                break;
            }
            case -805306368: {
                bl = aRM7TDMI.getZFlag() || aRM7TDMI.getNFlag() != aRM7TDMI.getVFlag();
                break;
            }
            case -536870912: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    protected static String getPreconditionSuffix(int n) {
        return PreconditionSuffix[n >>> 28 & 0xF];
    }
}

