/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.cpu.instruction.ARMState;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class ARM_10 {
    static final String[] InstructionName = new String[]{"str%h", "ldr%h", "ldr%sb", "ldr%sh"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        boolean bl;
        int n2;
        int n3;
        int n4;
        if (!ARMState.isPreconditionSatisfied(aRM7TDMI, n)) {
            return;
        }
        int n5 = n >>> 12 & 0xF;
        int n6 = n >>> 16 & 0xF;
        int n7 = aRM7TDMI.getRegister(n6);
        if ((n & 0x400000) == 0) {
            n4 = n & 0xF;
            n2 = n3 = aRM7TDMI.getRegister(n4);
        } else {
            n2 = (n & 0xF00) >>> 4 | n & 0xF;
        }
        n4 = (n & 0x1000000) == 0 ? 1 : 0;
        n3 = (n & 0x800000) == 0 ? 1 : 0;
        boolean bl2 = bl = n4 != 0 || (n & 0x200000) != 0;
        if (n3 != 0) {
            n2 = -n2;
        }
        if (n4 == 0) {
            n7 += n2;
        }
        int n8 = n & 0x60;
        if ((n & 0x100000) == 0) {
            if (n8 == 32) {
                int n9 = aRM7TDMI.getRegister(n5);
                if (n5 == 15) {
                    n9 += 4;
                }
                memoryInterface.storeHalfWord(n7, (short)n9);
            }
        } else {
            switch (n8) {
                case 32: {
                    aRM7TDMI.setRegister(n5, memoryInterface.loadHalfWord(n7) & 0xFFFF);
                    break;
                }
                case 64: {
                    aRM7TDMI.setRegister(n5, memoryInterface.loadByte(n7));
                    break;
                }
                case 96: {
                    aRM7TDMI.setRegister(n5, memoryInterface.loadHalfWord(n7));
                    break;
                }
                default: {
                    return;
                }
            }
            if (n5 == 15) {
                aRM7TDMI.flushARMPipeline();
            }
            if (n5 == n6) {
                return;
            }
        }
        if (bl) {
            if (n4 != 0) {
                n7 += n2;
            }
            aRM7TDMI.setRegister(n6, n7);
            if (n6 == 15) {
                aRM7TDMI.flushARMPipeline();
            }
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        String string;
        String string2;
        String string3;
        String string4;
        int n3 = n >>> 5 & 3;
        if ((n & 0x100000) == 0) {
            if (n3 != 1) {
                return "[ unknown ]";
            }
            n3 = 0;
        } else if (n3 == 0) {
            return "[ unknown ]";
        }
        String string5 = ARMState.getPreconditionSuffix(n);
        boolean bl = (n & 0x1000000) == 0;
        boolean bl2 = (n & 0x200000) != 0;
        String string6 = aRM7TDMI.getRegisterName(n >>> 12 & 0xF);
        String string7 = aRM7TDMI.getRegisterName(n >>> 16 & 0xF);
        String string8 = string4 = (n & 0x800000) == 0 ? "-" : "";
        if ((n & 0x400000) == 0) {
            string3 = string4 + aRM7TDMI.getRegisterName(n & 0xF);
        } else {
            int n4 = (n & 0xF00) >>> 4 | n & 0xF;
            string3 = "<" + string4 + Hex.toHexString(n4, (byte)2) + ">";
        }
        if (bl) {
            string2 = "[" + string7 + "], ";
            string = "";
        } else {
            string2 = "[" + string7 + ", ";
            string = "]" + (bl2 ? "!" : "");
        }
        string3 = string2 + string3 + string;
        return InstructionName[n3].replace("%", string5) + " " + string6 + ", " + string3;
    }
}

