/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.cpu.instruction.ARMState;
import ygba.memory.MemoryInterface;

public final class ARM_12 {
    static final String InstructionName = "swp";

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        if (!ARMState.isPreconditionSatisfied(aRM7TDMI, n)) {
            return;
        }
        int n2 = n >>> 16 & 0xF;
        int n3 = aRM7TDMI.getRegister(n2);
        int n4 = n & 0xF;
        int n5 = aRM7TDMI.getRegister(n4);
        int n6 = n >>> 12 & 0xF;
        int n7 = memoryInterface.loadWord(n3);
        if ((n & 0x400000) == 0) {
            aRM7TDMI.setRegister(n6, n7);
            memoryInterface.storeWord(n3, n5);
        } else {
            aRM7TDMI.setRegister(n6, n7 & 0xFF);
            memoryInterface.storeByte(n3, (byte)n5);
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        String string = ARMState.getPreconditionSuffix(n);
        String string2 = (n & 0x400000) != 0 ? "b" : "";
        String string3 = aRM7TDMI.getRegisterName(n >>> 16 & 0xF);
        String string4 = aRM7TDMI.getRegisterName(n >>> 12 & 0xF);
        String string5 = aRM7TDMI.getRegisterName(n & 0xF);
        return InstructionName + string + string2 + " " + string4 + ", " + string5 + ", " + "[" + string3 + "]";
    }
}

