/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.cpu.instruction.ARMState;
import ygba.memory.MemoryInterface;

public final class ARM_8 {
    static final String[] InstructionName = new String[]{"umull", "umlal", "smull", "smlal"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        long l;
        if (!ARMState.isPreconditionSatisfied(aRM7TDMI, n)) {
            return;
        }
        int n2 = n >>> 12 & 0xF;
        int n3 = n >>> 16 & 0xF;
        int n4 = aRM7TDMI.getRegister(n & 0xF);
        int n5 = aRM7TDMI.getRegister(n >>> 8 & 0xF);
        switch (n & 0x600000) {
            case 0: {
                l = ((long)n4 & 0xFFFFFFFFL) * ((long)n5 & 0xFFFFFFFFL);
                break;
            }
            case 0x200000: {
                int n6 = aRM7TDMI.getRegister(n2);
                int n7 = aRM7TDMI.getRegister(n3);
                l = ((long)n4 & 0xFFFFFFFFL) * ((long)n5 & 0xFFFFFFFFL);
                l += (long)n7 << 32 | (long)n6 & 0xFFFFFFFFL;
                break;
            }
            case 0x400000: {
                l = n4 * n5;
                break;
            }
            case 0x600000: {
                int n8 = aRM7TDMI.getRegister(n2);
                int n9 = aRM7TDMI.getRegister(n3);
                l = n4 * n5;
                l += (long)n9 << 32 | (long)n8 & 0xFFFFFFFFL;
                break;
            }
            default: {
                l = 0L;
            }
        }
        aRM7TDMI.setRegister(n2, (int)l);
        aRM7TDMI.setRegister(n3, (int)(l >>> 32));
        if ((n & 0x100000) != 0) {
            aRM7TDMI.setZFlag(l == 0L);
            aRM7TDMI.setNFlag(l < 0L);
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 21 & 3;
        String string = ARMState.getPreconditionSuffix(n);
        String string2 = (n & 0x100000) == 0 ? "" : "s";
        String string3 = aRM7TDMI.getRegisterName(n >>> 12 & 0xF);
        String string4 = aRM7TDMI.getRegisterName(n >>> 16 & 0xF);
        String string5 = aRM7TDMI.getRegisterName(n & 0xF);
        String string6 = aRM7TDMI.getRegisterName(n >>> 8 & 0xF);
        return InstructionName[n3] + string + string2 + " " + string3 + ", " + string4 + ", " + string5 + ", " + string6;
    }
}

