/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;

public final class THUMB_1 {
    static final String[] InstructionName = new String[]{"lsl", "lsr", "asr"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2 = n & 7;
        int n3 = n >>> 3 & 7;
        int n4 = aRM7TDMI.getRegister(n3);
        int n5 = 0;
        int n6 = n >>> 6 & 0x1F;
        switch (n & 0x1800) {
            case 0: {
                if (n6 == 0) break;
                aRM7TDMI.setCFlag((n4 & 1 << 32 - n6) != 0);
                n5 = n4 << n6;
                break;
            }
            case 2048: {
                if (n6 == 0) {
                    aRM7TDMI.setCFlag(n4 < 0);
                    n5 = 0;
                    break;
                }
                aRM7TDMI.setCFlag((n4 & 1 << n6 - 1) != 0);
                n5 = n4 >>> n6;
                break;
            }
            case 4096: {
                if (n6 == 0) {
                    aRM7TDMI.setCFlag(n4 < 0);
                    n5 = n4 >> 31;
                    break;
                }
                aRM7TDMI.setCFlag((n4 & 1 << n6 - 1) != 0);
                n5 = n4 >> n6;
                break;
            }
        }
        aRM7TDMI.setRegister(n2, n5);
        aRM7TDMI.setZFlag(n5 == 0);
        aRM7TDMI.setNFlag(n5 < 0);
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 11 & 3;
        if (n3 >= InstructionName.length) {
            return "[ unknown ]";
        }
        String string = aRM7TDMI.getRegisterName(n & 7);
        String string2 = aRM7TDMI.getRegisterName(n >>> 3 & 7);
        int n4 = n >>> 6 & 0x1F;
        return InstructionName[n3] + " " + string + ", " + string2 + ", #" + n4;
    }
}

