/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class THUMB_10 {
    static final String[] InstructionName = new String[]{"strh", "ldrh"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2 = n & 7;
        int n3 = n >>> 3 & 7;
        int n4 = aRM7TDMI.getRegister(n3);
        int n5 = n >>> 5 & 0x3E;
        if ((n & 0x800) == 0) {
            memoryInterface.storeHalfWord(n4 + n5, (short)aRM7TDMI.getRegister(n2));
        } else {
            aRM7TDMI.setRegister(n2, memoryInterface.loadHalfWord(n4 + n5) & 0xFFFF);
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 11 & 1;
        String string = aRM7TDMI.getRegisterName(n & 7);
        String string2 = aRM7TDMI.getRegisterName(n >>> 3 & 7);
        int n4 = n >>> 5 & 0x3E;
        return InstructionName[n3] + " " + string + ", [" + string2 + ", " + Hex.toHexString(n4, (byte)2) + "]";
    }
}

