/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class THUMB_11 {
    static final String[] InstructionName = new String[]{"str", "ldr"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2 = n >>> 8 & 7;
        int n3 = aRM7TDMI.getSP();
        int n4 = (n & 0xFF) << 2;
        if ((n & 0x800) == 0) {
            memoryInterface.storeWord(n3 + n4, aRM7TDMI.getRegister(n2));
        } else {
            aRM7TDMI.setRegister(n2, memoryInterface.loadWord(n3 + n4));
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 11 & 1;
        String string = aRM7TDMI.getRegisterName(n >>> 8 & 7);
        String string2 = aRM7TDMI.getRegisterName(13);
        int n4 = (n & 0xFF) << 2;
        return InstructionName[n3] + " " + string + ", [" + string2 + ", " + Hex.toHexString(n4, (byte)3) + "]";
    }
}

