/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;

public final class THUMB_14 {
    static final String[] InstructionName = new String[]{"push", "pop"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2 = aRM7TDMI.getSP() & 0xFFFFFFFC;
        if ((n & 0x800) == 0) {
            if ((n & 0x100) != 0) {
                memoryInterface.storeWord(n2 -= 4, aRM7TDMI.getLR());
            }
            for (int i = 7; i >= 0; --i) {
                if ((n & 1 << i) == 0) continue;
                memoryInterface.storeWord(n2 -= 4, aRM7TDMI.getRegister(i));
            }
        } else {
            for (int i = 0; i <= 7; ++i) {
                if ((n & 1 << i) == 0) continue;
                aRM7TDMI.setRegister(i, memoryInterface.loadWord(n2));
                n2 += 4;
            }
            if ((n & 0x100) != 0) {
                aRM7TDMI.setPC(memoryInterface.loadWord(n2));
                n2 += 4;
                aRM7TDMI.flushTHUMBPipeline();
            }
        }
        aRM7TDMI.setSP(n2);
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 11 & 1;
        String string = "";
        int n4 = n & 0xFF;
        int n5 = -1;
        for (int n6 = 0; n6 <= 8; n6 = (int)((byte)(n6 + 1))) {
            if ((n4 & 1 << n6) == 0) {
                if (n5 == -1) continue;
                string = string + "%" + aRM7TDMI.getRegisterName(n5);
                int n7 = n6 - 1;
                if (n5 < n7) {
                    string = n5 == n7 - 1 ? string + "%" + aRM7TDMI.getRegisterName(n7) : string + "-" + aRM7TDMI.getRegisterName(n7);
                }
                n5 = -1;
                continue;
            }
            if (n5 != -1) continue;
            n5 = n6;
        }
        if ((n & 0x100) != 0) {
            string = string + "%" + aRM7TDMI.getRegisterName(n3 == 0 ? 14 : 15);
        }
        string = string.replaceFirst("%", "").replaceAll("%", ", ");
        return InstructionName[n3] + " " + "{" + string + "}";
    }
}

