/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class THUMB_16 {
    static final String[] InstructionName = new String[]{"beq", "bne", "bcs", "bcc", "bmi", "bpl", "bvs", "bvc", "bhi", "bls", "bge", "blt", "bgt", "ble"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        boolean bl;
        switch (n & 0xF00) {
            case 0: {
                bl = aRM7TDMI.getZFlag();
                break;
            }
            case 256: {
                bl = !aRM7TDMI.getZFlag();
                break;
            }
            case 512: {
                bl = aRM7TDMI.getCFlag();
                break;
            }
            case 768: {
                bl = !aRM7TDMI.getCFlag();
                break;
            }
            case 1024: {
                bl = aRM7TDMI.getNFlag();
                break;
            }
            case 1280: {
                bl = !aRM7TDMI.getNFlag();
                break;
            }
            case 1536: {
                bl = aRM7TDMI.getVFlag();
                break;
            }
            case 1792: {
                bl = !aRM7TDMI.getVFlag();
                break;
            }
            case 2048: {
                bl = aRM7TDMI.getCFlag() && !aRM7TDMI.getZFlag();
                break;
            }
            case 2304: {
                bl = !aRM7TDMI.getCFlag() || aRM7TDMI.getZFlag();
                break;
            }
            case 2560: {
                bl = aRM7TDMI.getNFlag() == aRM7TDMI.getVFlag();
                break;
            }
            case 2816: {
                bl = aRM7TDMI.getNFlag() != aRM7TDMI.getVFlag();
                break;
            }
            case 3072: {
                bl = !aRM7TDMI.getZFlag() && aRM7TDMI.getNFlag() == aRM7TDMI.getVFlag();
                break;
            }
            case 3328: {
                bl = aRM7TDMI.getZFlag() || aRM7TDMI.getNFlag() != aRM7TDMI.getVFlag();
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            int n2 = (byte)(n & 0xFF) << 1;
            aRM7TDMI.setPC(aRM7TDMI.getPC() + n2);
            aRM7TDMI.flushTHUMBPipeline();
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 8 & 0xF;
        if (n3 >= InstructionName.length) {
            return "[ unknown ]";
        }
        int n4 = n2 + 4 + ((byte)(n & 0xFF) << 1);
        return InstructionName[n3] + " " + Hex.toAddrString(n4, (byte)8);
    }
}

