/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class THUMB_18 {
    static final String InstructionName = "b";

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2 = (n & 0x3FF) << 1;
        if ((n & 0x400) != 0) {
            n2 |= 0xFFFFF800;
        }
        aRM7TDMI.setPC(aRM7TDMI.getPC() + n2);
        aRM7TDMI.flushTHUMBPipeline();
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = (n & 0x3FF) << 1;
        if ((n & 0x400) != 0) {
            n3 |= 0xFFFFF800;
        }
        int n4 = n2 + 4 + n3;
        return "b " + Hex.toAddrString(n4, (byte)8);
    }
}

