/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class THUMB_19 {
    static final String InstructionName = "bl";

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2 = n & 0x7FF;
        if ((n & 0x800) == 0) {
            if ((n & 0x400) != 0) {
                n2 |= 0xFFFFF800;
            }
            aRM7TDMI.setLR(aRM7TDMI.getPC() + (n2 << 12));
        } else {
            int n3 = aRM7TDMI.getLR();
            int n4 = aRM7TDMI.getCurrentPC();
            aRM7TDMI.setPC(n3 + (n2 << 1));
            aRM7TDMI.setLR(n4 | 1);
            aRM7TDMI.flushTHUMBPipeline();
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        if ((n & 0x800) == 0) {
            int n3 = (n & 0x7FF) << 21 >> 21 << 12;
            int n4 = (memoryInterface.getHalfWord(n2 - 2) & 0x7FF) << 1;
            return "bl " + Hex.toAddrString((n3 | n4) + n2 + 2, (byte)8);
        }
        return "blh " + Hex.toAddrString((n & 0x7FF) << 1, (byte)4);
    }
}

