/*
 * Decompiled with CFR 0.152.
 */
package ygba.memory;

import ygba.memory.MemoryInterface;

abstract class MemoryManager
implements MemoryInterface {
    String name;
    int size;
    int mask;
    byte[] space;
    private static final int MinMemSize = 4;

    public MemoryManager(String string, int n) {
        this.name = string;
        this.createSpace(n);
    }

    protected byte[] createSpace(int n) {
        this.size = n < 4 ? 4 : n;
        this.mask = this.size - 1;
        this.space = new byte[this.size];
        return this.space;
    }

    public final String getName() {
        return this.name;
    }

    public final int getSize() {
        return this.size;
    }

    public final byte[] getSpace() {
        return this.space;
    }

    public final byte[] getBytes() {
        return this.getSpace();
    }

    public int getInternalOffset(int n) {
        return n & this.mask;
    }

    public final byte getByte(int n) {
        return this.space[this.getInternalOffset(n)];
    }

    public final short getHalfWord(int n) {
        n = this.getInternalOffset(n);
        return (short)(this.space[n] & 0xFF | this.space[n + 1] << 8);
    }

    public final int getWord(int n) {
        n = this.getInternalOffset(n);
        return this.space[n] & 0xFF | (this.space[n + 1] & 0xFF) << 8 | (this.space[n + 2] & 0xFF) << 16 | this.space[n + 3] << 24;
    }

    public final void setByte(int n, byte by) {
        n = this.getInternalOffset(n);
        this.space[n] = by;
    }

    public final void setHalfWord(int n, short s) {
        n = this.getInternalOffset(n);
        this.space[n] = (byte)s;
        this.space[n + 1] = (byte)(s >>> 8);
    }

    public final void setWord(int n, int n2) {
        n = this.getInternalOffset(n);
        this.space[n] = (byte)n2;
        this.space[n + 1] = (byte)(n2 >>> 8);
        this.space[n + 2] = (byte)(n2 >>> 16);
        this.space[n + 3] = (byte)(n2 >>> 24);
    }

    public void softReset() {
        this.hardReset();
    }

    public final void hardReset() {
        for (int i = 0; i < this.space.length; ++i) {
            this.space[i] = 0;
        }
    }

    protected final void handleAccessViolation(int n) {
    }
}

