/*
 * Decompiled with CFR 0.152.
 */
package ygba.time;

import ygba.memory.IORegMemory;
import ygba.memory.Memory;

public final class Timer {
    private int time;
    private int rest;
    private int period;
    private boolean isEnabled;
    private boolean isIRQEnabled;
    private boolean isCascadeEnabled;
    private Timer nextTimer;
    private int timerNumber;
    private short timerInterruptBit;
    private IORegMemory iorMem;

    public Timer(Timer timer, int n) {
        this.nextTimer = timer;
        this.timerNumber = n;
        this.timerInterruptBit = (short)(8 << n);
        this.reset();
    }

    public void connectToMemory(Memory memory) {
        this.iorMem = memory.getIORegMemory();
    }

    public void reset() {
        this.time = 0;
        this.rest = 0;
        this.period = 1;
        this.isCascadeEnabled = false;
        this.isIRQEnabled = false;
        this.isEnabled = false;
    }

    public void updateState(short s) {
        switch (s & 3) {
            case 0: {
                this.period = 1;
                break;
            }
            case 1: {
                this.period = 64;
                break;
            }
            case 2: {
                this.period = 256;
                break;
            }
            case 3: {
                this.period = 1024;
            }
        }
        this.isEnabled = (s & 0x80) != 0;
        this.isIRQEnabled = (s & 0x40) != 0;
        this.isCascadeEnabled = (s & 4) != 0;
    }

    public String getName() {
        return "Timer" + this.timerNumber;
    }

    public short getTime() {
        return (short)this.time;
    }

    public void setTime(int n) {
        this.time = n & 0xFFFF;
        this.rest = 0;
    }

    public void addTime(int n) {
        if (this.isEnabled) {
            this.rest += n;
            while (this.rest > this.period) {
                ++this.time;
                if (this.time > 65535) {
                    if (this.nextTimer != null) {
                        this.nextTimer.addOverflowTime(this.time >>> 16);
                    }
                    if (this.isIRQEnabled) {
                        this.iorMem.generateInterrupt(this.timerInterruptBit);
                    }
                    this.time &= 0xFFFF;
                }
                this.rest -= this.period;
            }
        }
    }

    public void addOverflowTime(int n) {
        if (this.isCascadeEnabled) {
            this.addTime(n);
        }
    }
}

