/*
 * Decompiled with CFR 0.152.
 */
package ygba.ui;

import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableColumnModel;
import ygba.YGBA;
import ygba.cpu.ARM7TDMI;
import ygba.memory.Memory;
import ygba.ui.FlagViewerTableModel;
import ygba.ui.ProgramViewerTableModel;
import ygba.ui.RegisterViewerTableModel;

final class DebuggerDialog
extends JDialog
implements ActionListener,
KeyListener {
    private YGBA ygba;
    private ARM7TDMI cpu;
    private Memory memory;
    private JComboBox memoryBankSelector;
    private JScrollPane programViewerScrollPane;
    private JTable programViewerTable;
    private ProgramViewerTableModel programViewerTableModel;
    private JViewport programViewerViewport;
    private JScrollPane registerViewerScrollPane;
    private JTable registerViewerTable;
    private RegisterViewerTableModel registerViewerTableModel;
    private JScrollPane flagViewerScrollPane;
    private JTable flagViewerTable;
    private FlagViewerTableModel flagViewerTableModel;
    private JButton refreshButton;
    private JButton stepButton;
    private JButton closeButton;
    private JPanel buttonsPanel;
    private Container container;
    private static final int RefreshKey = 116;
    private static final int StepKey = 118;
    private static final int CloseKey = 27;
    private static final String SwitchMemoryBankCommand = "SWITCH_MEM_BANK";
    private static final String RefreshCommand = "REFRESH";
    private static final String StepCommand = "STEP";
    private static final String CloseCommand = "CLOSE";

    public DebuggerDialog(YGBA yGBA) {
        this.ygba = yGBA;
        this.cpu = yGBA.getCPU();
        this.memory = yGBA.getMemory();
        this.memoryBankSelector = new JComboBox();
        for (int i = 0; i < 16; ++i) {
            this.memoryBankSelector.addItem(this.memory.getDescription(i));
        }
        this.memoryBankSelector.setActionCommand(SwitchMemoryBankCommand);
        this.memoryBankSelector.addActionListener(this);
        this.memoryBankSelector.addKeyListener(this);
        this.programViewerTableModel = new ProgramViewerTableModel(this.cpu, this.memory);
        this.programViewerTable = new JTable(this.programViewerTableModel);
        this.programViewerTable.addKeyListener(this);
        this.programViewerTable.setRowHeight(20);
        TableColumnModel tableColumnModel = this.programViewerTable.getTableHeader().getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(100);
        tableColumnModel.getColumn(1).setPreferredWidth(100);
        tableColumnModel.getColumn(2).setPreferredWidth(250);
        this.programViewerScrollPane = new JScrollPane(this.programViewerTable);
        this.programViewerViewport = this.programViewerScrollPane.getViewport();
        this.registerViewerTableModel = new RegisterViewerTableModel(this.cpu);
        this.registerViewerTable = new JTable(this.registerViewerTableModel);
        this.registerViewerTable.addKeyListener(this);
        this.registerViewerTable.setFont(new Font(null, 0, 10));
        this.registerViewerTable.setRowHeight(15);
        TableColumnModel tableColumnModel2 = this.registerViewerTable.getTableHeader().getColumnModel();
        tableColumnModel2.getColumn(0).setPreferredWidth(75);
        tableColumnModel2.getColumn(1).setPreferredWidth(105);
        this.registerViewerScrollPane = new JScrollPane(this.registerViewerTable);
        this.flagViewerTableModel = new FlagViewerTableModel(this.cpu);
        this.flagViewerTable = new JTable(this.flagViewerTableModel);
        this.flagViewerTable.setFont(new Font(null, 0, 10));
        this.flagViewerTable.addKeyListener(this);
        this.flagViewerTable.setRowHeight(15);
        TableColumnModel tableColumnModel3 = this.flagViewerTable.getTableHeader().getColumnModel();
        tableColumnModel3.getColumn(0).setPreferredWidth(75);
        tableColumnModel3.getColumn(1).setPreferredWidth(105);
        this.flagViewerScrollPane = new JScrollPane(this.flagViewerTable);
        this.refreshButton = new JButton();
        this.refreshButton.setText("Refresh " + KeyEvent.getKeyText(116));
        this.refreshButton.setActionCommand(RefreshCommand);
        this.refreshButton.addActionListener(this);
        this.refreshButton.addKeyListener(this);
        this.stepButton = new JButton();
        this.stepButton.setText("Step " + KeyEvent.getKeyText(118));
        this.stepButton.setActionCommand(StepCommand);
        this.stepButton.addActionListener(this);
        this.stepButton.addKeyListener(this);
        this.closeButton = new JButton();
        this.closeButton.setText("Close " + KeyEvent.getKeyText(27));
        this.closeButton.setActionCommand(CloseCommand);
        this.closeButton.addActionListener(this);
        this.closeButton.addKeyListener(this);
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.add(this.refreshButton);
        this.buttonsPanel.add(this.stepButton);
        this.buttonsPanel.add(this.closeButton);
        this.container = this.getContentPane();
        this.container.setLayout(null);
        this.memoryBankSelector.setBounds(5, 5, 450, 25);
        this.container.add(this.memoryBankSelector);
        this.programViewerScrollPane.setBounds(5, 40, 450, 360);
        this.container.add(this.programViewerScrollPane);
        this.buttonsPanel.setBounds(5, 405, 450, 40);
        this.container.add(this.buttonsPanel);
        this.registerViewerScrollPane.setBounds(460, 5, 180, 290);
        this.container.add(this.registerViewerScrollPane);
        this.flagViewerScrollPane.setBounds(460, 300, 180, 140);
        this.container.add(this.flagViewerScrollPane);
        this.refresh();
        this.setTitle("Debugger");
        this.setSize(650, 500);
        this.setResizable(false);
        this.setModal(true);
        this.setVisible(true);
    }

    private void go(int n) {
        int n2 = n >>> 24 & 0xF;
        this.memoryBankSelector.setSelectedIndex(n2);
        int n3 = this.memory.getInternalOffset(n2, n) >>> (this.cpu.getTFlag() ? 1 : 2);
        if (!this.programViewerViewport.getViewRect().contains(0, n3 * 20, 1, 20)) {
            this.programViewerViewport.setViewPosition(new Point(0, n3 * 20));
        }
        this.programViewerTable.grabFocus();
        this.programViewerTable.setRowSelectionInterval(n3, n3);
        this.registerViewerTableModel.fireTableDataChanged();
        this.flagViewerTableModel.fireTableDataChanged();
    }

    private void refresh() {
        this.go(this.cpu.getCurrentPC());
    }

    private void step() {
        this.cpu.run(4);
        this.refresh();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SwitchMemoryBankCommand)) {
            int n = this.programViewerTableModel.getMemoryBank();
            int n2 = this.memoryBankSelector.getSelectedIndex();
            if (n2 != n) {
                this.programViewerTableModel.setMemoryBank(n2);
                this.programViewerViewport.validate();
                this.programViewerViewport.setViewPosition(new Point(0, 0));
            }
        } else if (string.equals(RefreshCommand)) {
            this.refresh();
        } else if (string.equals(StepCommand)) {
            this.step();
        } else if (string.equals(CloseCommand)) {
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 116: {
                this.refresh();
                break;
            }
            case 118: {
                this.step();
                break;
            }
            case 27: {
                this.dispose();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

