/*
 * Decompiled with CFR 0.152.
 */
package ygba.ui;

import ygba.cpu.ARM7TDMI;
import ygba.ui.InternationalTableModel;
import ygba.util.Hex;

final class RegisterViewerTableModel
extends InternationalTableModel {
    private ARM7TDMI cpu;

    public RegisterViewerTableModel(ARM7TDMI aRM7TDMI) {
        this.cpu = aRM7TDMI;
        this.columnName = new String[2];
        this.columnName[0] = "Register";
        this.columnName[1] = "Value";
    }

    public int getRowCount() {
        return 18;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.cpu.getRegisterName(n).toUpperCase();
            }
            case 1: {
                int n3;
                switch (n) {
                    case 16: {
                        n3 = this.cpu.getCPSR();
                        break;
                    }
                    case 17: {
                        if (ARM7TDMI.SPSR == -1) {
                            return "";
                        }
                        n3 = this.cpu.getSPSR();
                        break;
                    }
                    default: {
                        n3 = this.cpu.getRegister(n);
                    }
                }
                return Hex.toHexString(n3, (byte)8);
            }
        }
        return "";
    }
}

