/*
 * Decompiled with CFR 0.152.
 */
package ygba;

import ygba.cpu.ARM7TDMI;
import ygba.memory.IORegMemory;
import ygba.memory.Memory;
import ygba.time.Time;

final class YGBACore
implements Runnable {
    private ARM7TDMI cpu;
    private IORegMemory iorMem;
    private Time time;
    private boolean stopped;
    private static final int HDrawDots = 240;
    private static final int HBlankDots = 68;
    private static final int HDots = 308;
    private static final int VDrawLines = 160;
    private static final int VBlankLines = 68;
    private static final int VLines = 228;
    private static final int CyclesPerDot = 4;
    private static final int CyclesPerHDraw = 960;
    private static final int CyclesPerHBlank = 272;
    private static final int CyclesPerLine = 1232;

    public YGBACore(ARM7TDMI aRM7TDMI, Memory memory, Time time) {
        this.cpu = aRM7TDMI;
        this.iorMem = memory.getIORegMemory();
        this.time = time;
        this.stopped = true;
    }

    public void run() {
        this.stopped = false;
        while (!this.stopped) {
            for (int i = 0; i < 228; ++i) {
                this.iorMem.setCurrentScanline(i);
                this.cpu.run(960);
                this.iorMem.enterHBlank();
                this.cpu.run(272);
                this.iorMem.exitHBlank();
                this.time.addTime(1232);
                if (i == 159) {
                    this.iorMem.enterVBlank();
                    continue;
                }
                if (i != 227) continue;
                this.iorMem.exitVBlank();
            }
        }
    }

    public void stop() {
        this.stopped = true;
    }
}

