/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.cpu.instruction.ARMState;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class ARM_13 {
    static final String InstructionName = "swi";

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        if (!ARMState.isPreconditionSatisfied(aRM7TDMI, n)) {
            return;
        }
        aRM7TDMI.generateSoftwareInterrupt(aRM7TDMI.getCurrentPC());
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        String string = ARMState.getPreconditionSuffix(n);
        return InstructionName + string + " " + Hex.toHexString(n & 0xFFFFFF, (byte)6);
    }
}

