/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.cpu.instruction.ARMState;
import ygba.memory.MemoryInterface;

public final class ARM_3 {
    static final String InstructionName = "bx";

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        if (!ARMState.isPreconditionSatisfied(aRM7TDMI, n)) {
            return;
        }
        int n2 = n & 0xF;
        int n3 = aRM7TDMI.getRegister(n2);
        aRM7TDMI.setTFlag((n3 & 1) != 0);
        aRM7TDMI.setPC(n3);
        aRM7TDMI.flushPipeline();
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        String string = ARMState.getPreconditionSuffix(n);
        String string2 = aRM7TDMI.getRegisterName(n & 0xF);
        return InstructionName + string + " " + string2;
    }
}

