/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.cpu.instruction.ARMState;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class ARM_4 {
    static final String[] InstructionName = new String[]{"b", "bl"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        if (!ARMState.isPreconditionSatisfied(aRM7TDMI, n)) {
            return;
        }
        int n2 = n & 0xFFFFFF;
        if ((n2 & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        n2 <<= 2;
        if ((n & 0x1000000) != 0) {
            aRM7TDMI.setLR(aRM7TDMI.getCurrentPC());
        }
        aRM7TDMI.setPC(aRM7TDMI.getPC() + n2);
        aRM7TDMI.flushARMPipeline();
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = (n & 0x1000000) >>> 24;
        String string = ARMState.getPreconditionSuffix(n);
        int n4 = n & 0xFFFFFF;
        if ((n4 & 0x800000) != 0) {
            n4 |= 0xFF000000;
        }
        return InstructionName[n3] + string + " " + Hex.toAddrString(n2 + 8 + (n4 <<= 2), (byte)8);
    }
}

