/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.cpu.instruction.ARMState;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class ARM_6 {
    static final String[] InstructionName = new String[]{"mrs", "msr"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2;
        int n3;
        if (!ARMState.isPreconditionSatisfied(aRM7TDMI, n)) {
            return;
        }
        if ((n & 0x400000) == 0) {
            n3 = 16;
            n2 = aRM7TDMI.getCPSR();
        } else {
            if (ARM7TDMI.SPSR == -1) {
                return;
            }
            n3 = ARM7TDMI.SPSR;
            n2 = aRM7TDMI.getSPSR();
        }
        if ((n & 0x200000) == 0) {
            int n4 = n >>> 12 & 0xF;
            aRM7TDMI.setRegister(n4, n2);
        } else {
            int n5;
            if ((n & 0x2000000) == 0) {
                int n6 = n & 0xF;
                n5 = aRM7TDMI.getRegister(n6);
            } else {
                n5 = n & 0xFF;
                int n7 = (n & 0xF00) >>> 7;
                if (n7 != 0) {
                    n5 = n5 << 32 - n7 | n5 >>> n7;
                }
            }
            if (aRM7TDMI.getMode() != 16) {
                if ((n & 0x10000) != 0) {
                    n2 = n2 & 0xFFFFFF00 | n5 & 0xFF;
                }
                if ((n & 0x20000) != 0) {
                    n2 = n2 & 0xFFFF00FF | n5 & 0xFF00;
                }
                if ((n & 0x40000) != 0) {
                    n2 = n2 & 0xFF00FFFF | n5 & 0xFF0000;
                }
            }
            if ((n & 0x80000) != 0) {
                n2 = n2 & 0xFFFFFF | n5 & 0xFF000000;
            }
            n2 |= 0x10;
            if (n3 == 16) {
                aRM7TDMI.setPC(aRM7TDMI.getCurrentPC());
                aRM7TDMI.setCPSR(n2);
                aRM7TDMI.flushPipeline();
            } else {
                aRM7TDMI.setRegister(n3, n2);
            }
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        String string;
        String string2;
        int n3 = n >>> 21 & 1;
        String string3 = ARMState.getPreconditionSuffix(n);
        String string4 = aRM7TDMI.getRegisterName(n >>> 22 & 1 | 0x10);
        if (n3 == 0) {
            string2 = aRM7TDMI.getRegisterName(n >>> 12 & 0xF);
            string = string4;
        } else {
            string2 = string4 + "_";
            if ((n & 0x10000) != 0) {
                string2 = string2 + "f";
            }
            if ((n & 0x20000) != 0) {
                string2 = string2 + "s";
            }
            if ((n & 0x40000) != 0) {
                string2 = string2 + "x";
            }
            if ((n & 0x80000) != 0) {
                string2 = string2 + "c";
            }
            if ((n & 0x2000000) == 0) {
                string = aRM7TDMI.getRegisterName(n & 0xF);
            } else {
                int n4 = n & 0xFF;
                int n5 = (n & 0xF00) >>> 7;
                if (n5 != 0) {
                    n4 = n4 << 32 - n5 | n4 >>> n5;
                }
                string = Hex.toHexString(n4);
            }
        }
        return InstructionName[n3] + string3 + " " + string2 + ", " + string;
    }
}

