/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.cpu.instruction.ARMState;
import ygba.memory.MemoryInterface;

public final class ARM_7 {
    static final String[] InstructionName = new String[]{"mul", "mla"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2;
        if (!ARMState.isPreconditionSatisfied(aRM7TDMI, n)) {
            return;
        }
        int n3 = n & 0xF;
        int n4 = aRM7TDMI.getRegister(n3);
        int n5 = n >>> 8 & 0xF;
        int n6 = aRM7TDMI.getRegister(n5);
        int n7 = n >>> 16 & 0xF;
        if ((n & 0x200000) == 0) {
            n2 = n4 * n6;
        } else {
            int n8 = n >>> 12 & 0xF;
            int n9 = aRM7TDMI.getRegister(n8);
            n2 = n4 * n6 + n9;
        }
        aRM7TDMI.setRegister(n7, n2);
        if ((n & 0x100000) != 0) {
            aRM7TDMI.setZFlag(n2 == 0);
            aRM7TDMI.setNFlag(n2 < 0);
        }
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 21 & 1;
        String string = ARMState.getPreconditionSuffix(n);
        String string2 = (n & 0x100000) == 0 ? "" : "s";
        String string3 = aRM7TDMI.getRegisterName(n & 0xF);
        String string4 = aRM7TDMI.getRegisterName(n >>> 8 & 0xF);
        String string5 = aRM7TDMI.getRegisterName(n >>> 16 & 0xF);
        String string6 = n3 == 0 ? null : aRM7TDMI.getRegisterName(n >>> 12 & 0xF);
        return InstructionName[n3] + string + string2 + " " + string5 + ", " + string3 + ", " + string4 + (string6 == null ? "" : ", " + string6);
    }
}

