/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;

public final class THUMB_15 {
    static final String[] InstructionName = new String[]{"stmia", "ldmia"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2 = n >>> 8 & 7;
        int n3 = aRM7TDMI.getRegister(n2) & 0xFFFFFFFC;
        if ((n & 0x800) == 0) {
            for (int i = 0; i <= 7; ++i) {
                if ((n & 1 << i) == 0) continue;
                memoryInterface.storeWord(n3, aRM7TDMI.getRegister(i));
                n3 += 4;
            }
        } else {
            for (int i = 0; i <= 7; ++i) {
                if ((n & 1 << i) == 0) continue;
                aRM7TDMI.setRegister(i, memoryInterface.loadWord(n3));
                n3 += 4;
            }
        }
        aRM7TDMI.setRegister(n2, n3);
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 11 & 1;
        String string = aRM7TDMI.getRegisterName(n >>> 8 & 7);
        String string2 = "";
        int n4 = n & 0xFF;
        int n5 = -1;
        for (int n6 = 0; n6 <= 8; n6 = (int)((byte)(n6 + 1))) {
            if ((n4 & 1 << n6) == 0) {
                if (n5 == -1) continue;
                string2 = string2 + "%" + aRM7TDMI.getRegisterName(n5);
                int n7 = n6 - 1;
                if (n5 < n7) {
                    string2 = n5 == n7 - 1 ? string2 + "%" + aRM7TDMI.getRegisterName(n7) : string2 + "-" + aRM7TDMI.getRegisterName(n7);
                }
                n5 = -1;
                continue;
            }
            if (n5 != -1) continue;
            n5 = n6;
        }
        string2 = string2.replaceFirst("%", "").replaceAll("%", ", ");
        return InstructionName[n3] + " " + string + "!, " + "{" + string2 + "}";
    }
}

