/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;
import ygba.util.Hex;

public final class THUMB_2 {
    static final String[] InstructionName = new String[]{"add", "sub"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2;
        int n3 = n & 7;
        int n4 = n >>> 3 & 7;
        int n5 = aRM7TDMI.getRegister(n4);
        int n6 = n >>> 6 & 7;
        if ((n & 0x400) == 0) {
            n6 = aRM7TDMI.getRegister(n6);
        }
        if ((n & 0x200) == 0) {
            n2 = n5 + n6;
            aRM7TDMI.setVCFlagsForADD(n5, n6, n2);
        } else {
            n2 = n5 - n6;
            aRM7TDMI.setVCFlagsForSUB(n5, n6, n2);
        }
        aRM7TDMI.setRegister(n3, n2);
        aRM7TDMI.setZFlag(n2 == 0);
        aRM7TDMI.setNFlag(n2 < 0);
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = (n & 0x200) >>> 9;
        String string = aRM7TDMI.getRegisterName(n & 7);
        String string2 = aRM7TDMI.getRegisterName(n >>> 3 & 7);
        int n4 = n >>> 6 & 7;
        String string3 = (n & 0x400) == 0 ? aRM7TDMI.getRegisterName(n4) : Hex.toHexString(n4, (byte)1);
        return InstructionName[n3] + " " + string + ", " + string2 + ", " + string3;
    }
}

