/*
 * Decompiled with CFR 0.152.
 */
package ygba.cpu.instruction;

import ygba.cpu.ARM7TDMI;
import ygba.memory.MemoryInterface;

public final class THUMB_4 {
    static final String[] InstructionName = new String[]{"and", "eor", "lsl", "lsr", "asr", "adc", "sbc", "ror", "tst", "neg", "cmp", "cmn", "orr", "mul", "bic", "mvn"};

    public static void execute(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n) {
        int n2;
        int n3 = n & 7;
        int n4 = n >>> 3 & 7;
        int n5 = aRM7TDMI.getRegister(n4);
        int n6 = n2 = aRM7TDMI.getRegister(n3);
        switch (n & 0x3C0) {
            case 0: {
                aRM7TDMI.setRegister(n3, n6 &= n5);
                break;
            }
            case 64: {
                aRM7TDMI.setRegister(n3, n6 ^= n5);
                break;
            }
            case 128: {
                if (n5 == 0) break;
                if (n5 < 32) {
                    aRM7TDMI.setCFlag((n2 & 1 << 32 - n5) != 0);
                    n6 <<= n5;
                } else if (n5 == 32) {
                    aRM7TDMI.setCFlag((n2 & 1) != 0);
                    n6 = 0;
                } else {
                    aRM7TDMI.setCFlag(false);
                    n6 = 0;
                }
                aRM7TDMI.setRegister(n3, n6);
                break;
            }
            case 192: {
                if (n5 == 0) break;
                if (n5 < 32) {
                    aRM7TDMI.setCFlag((n2 & 1 << n5 - 1) != 0);
                    n6 >>>= n5;
                } else if (n5 == 32) {
                    aRM7TDMI.setCFlag((n2 & Integer.MIN_VALUE) != 0);
                    n6 = 0;
                } else {
                    aRM7TDMI.setCFlag(false);
                    n6 = 0;
                }
                aRM7TDMI.setRegister(n3, n6);
                break;
            }
            case 256: {
                if (n5 == 0) break;
                if (n5 < 32) {
                    aRM7TDMI.setCFlag((n2 & 1 << n5 - 1) != 0);
                    n6 >>= n5;
                } else {
                    aRM7TDMI.setCFlag((n2 & Integer.MIN_VALUE) != 0);
                    n6 >>= 31;
                }
                aRM7TDMI.setRegister(n3, n6);
                break;
            }
            case 320: {
                n6 = n2 + n5 + (aRM7TDMI.getCFlag() ? 1 : 0);
                aRM7TDMI.setVCFlagsForADD(n2, n5, n6);
                aRM7TDMI.setRegister(n3, n6);
                break;
            }
            case 384: {
                n6 = n2 - n5 - (aRM7TDMI.getCFlag() ? 0 : 1);
                aRM7TDMI.setVCFlagsForSUB(n2, n5, n6);
                aRM7TDMI.setRegister(n3, n6);
                break;
            }
            case 448: {
                if (n5 == 0) break;
                if ((n5 &= 0x1F) == 0) {
                    aRM7TDMI.setCFlag((n2 & Integer.MIN_VALUE) != 0);
                    break;
                }
                aRM7TDMI.setCFlag((n2 & 1 << n5 - 1) != 0);
                n6 = n2 << 32 - n5 | n2 >>> n5;
                aRM7TDMI.setRegister(n3, n6);
                break;
            }
            case 512: {
                n6 &= n5;
                break;
            }
            case 576: {
                n6 = -n5;
                aRM7TDMI.setVCFlagsForSUB(0, n5, n6);
                aRM7TDMI.setRegister(n3, n6);
                break;
            }
            case 640: {
                aRM7TDMI.setVCFlagsForSUB(n2, n5, n6 -= n5);
                break;
            }
            case 704: {
                aRM7TDMI.setVCFlagsForADD(n2, n5, n6 += n5);
                break;
            }
            case 768: {
                aRM7TDMI.setRegister(n3, n6 |= n5);
                break;
            }
            case 832: {
                aRM7TDMI.setRegister(n3, n6 *= n5);
                break;
            }
            case 896: {
                aRM7TDMI.setRegister(n3, n6 &= ~n5);
                break;
            }
            case 960: {
                n6 = ~n5;
                aRM7TDMI.setRegister(n3, n6);
                break;
            }
        }
        aRM7TDMI.setZFlag(n6 == 0);
        aRM7TDMI.setNFlag(n6 < 0);
    }

    public static String disassemble(ARM7TDMI aRM7TDMI, MemoryInterface memoryInterface, int n, int n2) {
        int n3 = n >>> 6 & 0xF;
        String string = aRM7TDMI.getRegisterName(n & 7);
        String string2 = aRM7TDMI.getRegisterName(n >>> 3 & 7);
        return InstructionName[n3] + " " + string + ", " + string2;
    }
}

