/*
 * Decompiled with CFR 0.152.
 */
package ygba.gfx;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import ygba.memory.IORegMemory;
import ygba.memory.Memory;
import ygba.memory.ObjectMemory;
import ygba.memory.PaletteMemory;
import ygba.memory.VideoMemory;

public final class GFX {
    public static final int XScreenSize = 240;
    public static final int YScreenSize = 160;
    private int[] pixels = new int[38400];
    private MemoryImageSource imageSource = new MemoryImageSource(240, 160, (ColorModel)new DirectColorModel(32, 0xFF0000, 65280, 255), this.pixels, 0, 240);
    private Image image;
    private IORegMemory iorMem;
    private PaletteMemory palMem;
    private VideoMemory vidMem;
    private ObjectMemory objMem;

    public GFX() {
        this.imageSource.setAnimated(true);
        this.image = Toolkit.getDefaultToolkit().createImage(this.imageSource);
    }

    public void connectToMemory(Memory memory) {
        this.iorMem = memory.getIORegMemory();
        this.palMem = (PaletteMemory)memory.getBank(5);
        this.vidMem = (VideoMemory)memory.getBank(6);
        this.objMem = (ObjectMemory)memory.getBank(7);
    }

    public void reset() {
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = 0;
        }
        this.imageSource.newPixels();
        this.image.flush();
    }

    public Image getImage() {
        return this.image;
    }

    public void drawLine(int n) {
        if (n < 160) {
            switch (this.iorMem.getVideoMode()) {
                case 0: {
                    this.drawMode0Line(n);
                    break;
                }
                case 1: {
                    this.drawMode1Line(n);
                    break;
                }
                case 2: {
                    this.drawMode2Line(n);
                    break;
                }
                case 3: {
                    this.drawMode3Line(n);
                    break;
                }
                case 4: {
                    this.drawMode4Line(n);
                    break;
                }
                case 5: {
                    this.drawMode5Line(n);
                }
            }
        } else if (n == 160) {
            this.imageSource.newPixels();
        }
    }

    private void drawMode0Line(int n) {
        boolean bl = this.iorMem.isBGEnabled(0);
        boolean bl2 = this.iorMem.isBGEnabled(1);
        boolean bl3 = this.iorMem.isBGEnabled(2);
        boolean bl4 = this.iorMem.isBGEnabled(3);
        boolean bl5 = this.iorMem.isOBJEnabled();
        int n2 = this.iorMem.getPriority(0);
        int n3 = this.iorMem.getPriority(1);
        int n4 = this.iorMem.getPriority(2);
        int n5 = this.iorMem.getPriority(3);
        this.drawBGLine(n);
        for (int i = 3; i >= 0; --i) {
            if (bl4 && n5 == i) {
                this.drawBGTextModeLine(n, 3);
            }
            if (bl3 && n4 == i) {
                this.drawBGTextModeLine(n, 2);
            }
            if (bl2 && n3 == i) {
                this.drawBGTextModeLine(n, 1);
            }
            if (bl && n2 == i) {
                this.drawBGTextModeLine(n, 0);
            }
            if (!bl5) continue;
            this.drawOBJLine(n, i);
        }
    }

    private void drawMode1Line(int n) {
        boolean bl = this.iorMem.isBGEnabled(0);
        boolean bl2 = this.iorMem.isBGEnabled(1);
        boolean bl3 = this.iorMem.isBGEnabled(2);
        boolean bl4 = this.iorMem.isOBJEnabled();
        int n2 = this.iorMem.getPriority(0);
        int n3 = this.iorMem.getPriority(1);
        int n4 = this.iorMem.getPriority(2);
        this.drawBGLine(n);
        for (int i = 3; i >= 0; --i) {
            if (bl3 & n4 == i) {
                this.drawBGRotScalModeLine(n, 2);
            }
            if (bl2 & n3 == i) {
                this.drawBGTextModeLine(n, 1);
            }
            if (bl & n2 == i) {
                this.drawBGTextModeLine(n, 0);
            }
            if (!bl4) continue;
            this.drawOBJLine(n, i);
        }
    }

    private void drawMode2Line(int n) {
        boolean bl = this.iorMem.isBGEnabled(2);
        boolean bl2 = this.iorMem.isBGEnabled(3);
        boolean bl3 = this.iorMem.isOBJEnabled();
        int n2 = this.iorMem.getPriority(2);
        int n3 = this.iorMem.getPriority(3);
        this.drawBGLine(n);
        for (int i = 3; i >= 0; --i) {
            if (bl2 & n3 == i) {
                this.drawBGRotScalModeLine(n, 3);
            }
            if (bl & n2 == i) {
                this.drawBGRotScalModeLine(n, 2);
            }
            if (!bl3) continue;
            this.drawOBJLine(n, i);
        }
    }

    private void drawMode3Line(int n) {
        boolean bl = this.iorMem.isBGEnabled(2);
        if (bl) {
            int n2;
            int n3;
            boolean bl2 = this.iorMem.isMosaicEnabled(2);
            int n4 = this.iorMem.getBGMosaicXSize();
            int n5 = this.iorMem.getBGMosaicYSize();
            int n6 = bl2 ? n - n % n5 : n;
            for (n3 = 0; n3 < 240; ++n3) {
                n2 = bl2 ? n3 - n3 % n4 : n3;
                short s = this.vidMem.getHalfWord((n6 * 240 + n2) * 2);
                this.pixels[n * 240 + n3] = GFX.toRGBA(s);
            }
            n3 = this.iorMem.isOBJEnabled() ? 1 : 0;
            if (n3 != 0) {
                for (n2 = 3; n2 >= 0; --n2) {
                    this.drawOBJLine(n, n2);
                }
            }
        }
    }

    private void drawMode4Line(int n) {
        boolean bl = this.iorMem.isBGEnabled(2);
        if (bl) {
            int n2;
            int n3;
            int n4 = this.iorMem.isFrame1Selected() ? 40960 : 0;
            boolean bl2 = this.iorMem.isMosaicEnabled(2);
            int n5 = this.iorMem.getBGMosaicXSize();
            int n6 = this.iorMem.getBGMosaicYSize();
            int n7 = bl2 ? n - n % n6 : n;
            for (n3 = 0; n3 < 240; ++n3) {
                n2 = bl2 ? n3 - n3 % n5 : n3;
                int n8 = this.vidMem.getByte(n4 + (n7 * 240 + n2)) & 0xFF;
                short s = this.palMem.getHalfWord(n8 * 2);
                this.pixels[n * 240 + n3] = GFX.toRGBA(s);
            }
            n3 = this.iorMem.isOBJEnabled() ? 1 : 0;
            if (n3 != 0) {
                for (n2 = 3; n2 >= 0; --n2) {
                    this.drawOBJLine(n, n2);
                }
            }
        }
    }

    private void drawMode5Line(int n) {
        System.out.println("Video Mode 5 unsupported");
    }

    private void drawBGLine(int n) {
        int n2 = GFX.toRGBA(this.palMem.getHalfWord(0));
        int n3 = n * 240;
        int n4 = (n + 1) * 240;
        for (int i = n3; i < n4; ++i) {
            this.pixels[i] = n2;
        }
    }

    private void drawBGTextModeLine(int n, int n2) {
        int n3 = this.iorMem.getCharacterBaseAddress(n2);
        int n4 = this.iorMem.getScreenBaseAddress(n2);
        int n5 = this.iorMem.getTextModeXSize(n2);
        int n6 = this.iorMem.getTextModeYSize(n2);
        int n7 = n5 - 1;
        int n8 = n6 - 1;
        int n9 = this.iorMem.getXOffset(n2);
        int n10 = this.iorMem.getYOffset(n2);
        boolean bl = n5 != 256;
        boolean bl2 = this.iorMem.is256ColorPalette(n2);
        boolean bl3 = this.iorMem.isMosaicEnabled(n2);
        int n11 = this.iorMem.getBGMosaicXSize();
        int n12 = this.iorMem.getBGMosaicYSize();
        int n13 = bl3 ? n - n % n12 : n;
        n13 = n13 + n10 & n8;
        int n14 = 0;
        if (bl) {
            if (n13 >= 256) {
                n14 = 4096;
            }
            n13 &= 0xFF;
        }
        int n15 = (n13 >>> 3) * 32;
        int n16 = n13 & 7;
        for (int i = 0; i < 240; ++i) {
            int n17;
            int n18;
            int n19 = bl3 ? i - i % n11 : i;
            n19 = n19 + n9 & n7;
            int n20 = 0;
            if (bl) {
                if (n19 >= 256) {
                    n20 = 2048;
                }
                n19 &= 0xFF;
            }
            int n21 = n19 >>> 3;
            int n22 = n19 & 7;
            int n23 = (n15 + n21) * 2 + (n14 + n20);
            short s = this.vidMem.getHalfWord(n4 + n23);
            int n24 = s & 0x3FF;
            if ((s & 0x400) != 0) {
                n22 = 7 - n22;
            }
            if ((s & 0x800) != 0) {
                n16 = 7 - n16;
            }
            if (bl2) {
                n18 = this.vidMem.getByte(n3 + n24 * 8 * 8 + n16 * 8 + n22) & 0xFF;
                if (n18 == 0) continue;
                n17 = this.palMem.getHalfWord(n18 * 2);
                this.pixels[n * 240 + i] = GFX.toRGBA((short)n17);
                continue;
            }
            n18 = this.vidMem.getByte(n3 + n24 * 8 * 4 + n16 * 4 + n22 / 2) & 0xFF;
            n18 = (n22 & 1) != 0 ? (n18 >>>= 4) : (n18 &= 0xF);
            if (n18 == 0) continue;
            n17 = s >>> 12 & 0xF;
            short s2 = this.palMem.getHalfWord((n17 * 16 + n18) * 2);
            this.pixels[n * 240 + i] = GFX.toRGBA(s2);
        }
    }

    private void drawBGRotScalModeLine(int n, int n2) {
        int n3 = this.iorMem.getCharacterBaseAddress(n2);
        int n4 = this.iorMem.getScreenBaseAddress(n2);
        int n5 = this.iorMem.getRotScalModeXYSize(n2);
        int n6 = n5 - 1;
        int n7 = this.iorMem.getXCoordinate(n2);
        int n8 = this.iorMem.getYCoordinate(n2);
        short s = this.iorMem.getPA(n2);
        short s2 = this.iorMem.getPB(n2);
        short s3 = this.iorMem.getPC(n2);
        short s4 = this.iorMem.getPD(n2);
        boolean bl = this.iorMem.isWraparoundOverflow(n2);
        int n9 = n * s2 + n7;
        int n10 = n * s4 + n8;
        for (int i = 0; i < 240; ++i) {
            int n11 = n9 >> 8;
            int n12 = n10 >> 8;
            if (bl) {
                n11 &= n6;
                n12 &= n6;
            }
            if (n11 >= 0 && n11 < n5 && n12 >= 0 && n12 < n5) {
                int n13 = n11 >>> 3;
                int n14 = n12 >>> 3;
                int n15 = n11 & 7;
                int n16 = n12 & 7;
                int n17 = this.vidMem.getByte(n4 + n14 * (n5 / 8) + n13) & 0xFF;
                int n18 = this.vidMem.getByte(n3 + n17 * 8 * 8 + n16 * 8 + n15) & 0xFF;
                if (n18 != 0) {
                    short s5 = this.palMem.getHalfWord(n18 * 2);
                    this.pixels[n * 240 + i] = GFX.toRGBA(s5);
                }
            }
            n9 += s;
            n10 += s3;
        }
    }

    private void drawOBJLine(int n, int n2) {
        int n3 = 65536;
        int n4 = 512;
        boolean bl = this.iorMem.isOBJ1DMapping();
        int n5 = this.iorMem.getOBJMosaicXSize();
        int n6 = this.iorMem.getOBJMosaicYSize();
        for (int i = 127; i >= 0; --i) {
            boolean bl2;
            int n7;
            int n8 = this.objMem.getPriority(i);
            if (n8 != n2) continue;
            boolean bl3 = this.objMem.isRotScalEnabled(i);
            int n9 = this.objMem.getXSize(i);
            int n10 = this.objMem.getYSize(i);
            int n11 = n9 >>> 3;
            int n12 = n10 >>> 3;
            int n13 = this.objMem.getXCoordinate(i);
            int n14 = this.objMem.getYCoordinate(i);
            boolean bl4 = this.objMem.is256ColorPalette(i);
            int n15 = this.objMem.getPaletteNumber(i);
            int n16 = this.objMem.getTileNumber(i);
            if (bl) {
                n7 = bl4 ? n11 * 2 : n11;
            } else {
                n7 = 32;
                if (bl4) {
                    n16 &= 0xFFFE;
                }
            }
            boolean bl5 = this.objMem.isMosaicEnabled(i);
            if (bl3 || !(bl2 = this.objMem.isDisplayable(i))) continue;
            boolean bl6 = this.objMem.isHFlipEnabled(i);
            boolean bl7 = this.objMem.isVFlipEnabled(i);
            if (n14 >= 160) {
                n14 -= 256;
            }
            if (n < n14 || n >= n14 + n10) continue;
            int n17 = n - n14;
            for (int j = 0; j < n9; ++j) {
                short s;
                int n18;
                int n19;
                int n20 = n13 + j;
                if (n20 < 0 || n20 >= 240) continue;
                int n21 = bl6 ? n9 - 1 - j : j;
                int n22 = bl7 ? n10 - 1 - n17 : n17;
                int n23 = n21 >>> 3;
                int n24 = n22 >>> 3;
                int n25 = n21 & 7;
                int n26 = n22 & 7;
                if (bl4) {
                    n19 = n16 + n24 * n7 + n23 * 2;
                    n18 = this.vidMem.getByte(n3 + n19 * 32 + n26 * 8 + n25) & 0xFF;
                    if (n18 == 0) continue;
                    s = this.palMem.getHalfWord(n4 + n18 * 2);
                    this.pixels[n * 240 + n20] = GFX.toRGBA(s);
                    continue;
                }
                n19 = n16 + n24 * n7 + n23;
                n18 = this.vidMem.getByte(n3 + n19 * 32 + n26 * 4 + n25 / 2) & 0xFF;
                n18 = (n25 & 1) != 0 ? (n18 >>>= 4) : (n18 &= 0xF);
                if (n18 == 0) continue;
                s = this.palMem.getHalfWord(n4 + (n15 * 16 + n18) * 2);
                this.pixels[n * 240 + n20] = GFX.toRGBA(s);
            }
        }
    }

    private static int toRGBA(short s) {
        int n = (s & 0x1F) << 19;
        int n2 = (s & 0x3E0) << 6;
        int n3 = (s & 0x7C00) >>> 7;
        int n4 = -16777216;
        return n | n2 | n3 | n4;
    }
}

