/*
 * Decompiled with CFR 0.152.
 */
package ygba.memory;

import ygba.dma.DMA;
import ygba.dma.DirectMemoryAccess;
import ygba.gfx.GFX;
import ygba.memory.MemoryManager_8_16_32;
import ygba.time.Time;
import ygba.time.Timer;

public final class IORegMemory
extends MemoryManager_8_16_32 {
    public static final int REG_DISPCNT = 0;
    public static final int REG_DISPSTAT = 4;
    public static final int REG_VCOUNT = 6;
    public static final int REG_BG0CNT = 8;
    public static final int REG_BG1CNT = 10;
    public static final int REG_BG2CNT = 12;
    public static final int REG_BG3CNT = 14;
    public static final int REG_BG0HOFS = 16;
    public static final int REG_BG0VOFS = 18;
    public static final int REG_BG1HOFS = 20;
    public static final int REG_BG1VOFS = 22;
    public static final int REG_BG2HOFS = 24;
    public static final int REG_BG2VOFS = 26;
    public static final int REG_BG3HOFS = 28;
    public static final int REG_BG3VOFS = 30;
    public static final int REG_BG2PA = 32;
    public static final int REG_BG2PB = 34;
    public static final int REG_BG2PC = 36;
    public static final int REG_BG2PD = 38;
    public static final int REG_BG2X = 40;
    public static final int REG_BG2Y = 44;
    public static final int REG_BG3PA = 48;
    public static final int REG_BG3PB = 50;
    public static final int REG_BG3PC = 52;
    public static final int REG_BG3PD = 54;
    public static final int REG_BG3X = 56;
    public static final int REG_BG3Y = 60;
    public static final int REG_WIN0H = 64;
    public static final int REG_WIN1H = 66;
    public static final int REG_WIN0V = 68;
    public static final int REG_WIN1V = 70;
    public static final int REG_WININ = 72;
    public static final int REG_WINOUT = 74;
    public static final int REG_MOSAIC = 76;
    public static final int REG_BLDMOD = 80;
    public static final int REG_COLEV = 82;
    public static final int REG_COLY = 84;
    public static final int REG_DMA0SAD = 176;
    public static final int REG_DMA0DAD = 180;
    public static final int REG_DMA0CNT_L = 184;
    public static final int REG_DMA0CNT_H = 186;
    public static final int REG_DMA1SAD = 188;
    public static final int REG_DMA1DAD = 192;
    public static final int REG_DMA1CNT_L = 196;
    public static final int REG_DMA1CNT_H = 198;
    public static final int REG_DMA2SAD = 200;
    public static final int REG_DMA2DAD = 204;
    public static final int REG_DMA2CNT_L = 208;
    public static final int REG_DMA2CNT_H = 210;
    public static final int REG_DMA3SAD = 212;
    public static final int REG_DMA3DAD = 216;
    public static final int REG_DMA3CNT_L = 220;
    public static final int REG_DMA3CNT_H = 222;
    public static final int REG_TM0D = 256;
    public static final int REG_TM0CNT = 258;
    public static final int REG_TM1D = 260;
    public static final int REG_TM1CNT = 262;
    public static final int REG_TM2D = 264;
    public static final int REG_TM2CNT = 266;
    public static final int REG_TM3D = 268;
    public static final int REG_TM3CNT = 270;
    public static final int REG_P1 = 304;
    public static final int REG_P1CNT = 306;
    public static final int REG_IE = 512;
    public static final int REG_IF = 514;
    public static final int REG_WSCNT = 516;
    public static final int REG_IME = 520;
    public static final int REG_HALTCNT = 768;
    private short keyInput;
    private DMA dma0;
    private DMA dma1;
    private DMA dma2;
    private DMA dma3;
    private GFX gfx;
    private Timer timer0;
    private Timer timer1;
    private Timer timer2;
    private Timer timer3;
    private static final int[] BGBit = new int[]{1, 2, 4, 8};
    private static final int[] WinBit = new int[]{32, 64};
    private static final int[] REG_BGxCNT = new int[]{8, 10, 12, 14};
    private static final int[] REG_BGxHOFS = new int[]{16, 20, 24, 28};
    private static final int[] REG_BGxVOFS = new int[]{18, 22, 26, 30};
    private static final int[] REG_BGxX = new int[]{0, 0, 40, 56};
    private static final int[] REG_BGxY = new int[]{0, 0, 44, 60};
    private static final int[] REG_BGxPA = new int[]{0, 0, 32, 48};
    private static final int[] REG_BGxPB = new int[]{0, 0, 34, 50};
    private static final int[] REG_BGxPC = new int[]{0, 0, 36, 52};
    private static final int[] REG_BGxPD = new int[]{0, 0, 38, 54};
    public static final short VBlankInterruptBit = 1;
    public static final short HBlankInterruptBit = 2;
    public static final short VCounterMatchInterruptBit = 4;

    public IORegMemory() {
        super("I/O Registers RAM", 1024);
    }

    void connectToDMA(DirectMemoryAccess directMemoryAccess) {
        this.dma0 = directMemoryAccess.getDMA(0);
        this.dma1 = directMemoryAccess.getDMA(1);
        this.dma2 = directMemoryAccess.getDMA(2);
        this.dma3 = directMemoryAccess.getDMA(3);
    }

    void connectToGraphics(GFX gFX) {
        this.gfx = gFX;
    }

    void connectToTime(Time time) {
        this.timer0 = time.getTimer(0);
        this.timer1 = time.getTimer(1);
        this.timer2 = time.getTimer(2);
        this.timer3 = time.getTimer(3);
    }

    public byte loadByte(int n) {
        n = this.getInternalOffset(n);
        int n2 = n & 0xFFFFFFFE;
        switch (n2) {
            case 176: {
                this.setHalfWord(n2, this.dma0.getSourceLRegister());
                break;
            }
            case 178: {
                this.setHalfWord(n2, this.dma0.getSourceHRegister());
                break;
            }
            case 180: {
                this.setHalfWord(n2, this.dma0.getDestinationLRegister());
                break;
            }
            case 182: {
                this.setHalfWord(n2, this.dma0.getDestinationHRegister());
                break;
            }
            case 184: {
                this.setHalfWord(n2, this.dma0.getCountRegister());
                break;
            }
            case 186: {
                this.setHalfWord(n2, this.dma0.getControlRegister());
                break;
            }
            case 188: {
                this.setHalfWord(n2, this.dma1.getSourceLRegister());
                break;
            }
            case 190: {
                this.setHalfWord(n2, this.dma1.getSourceHRegister());
                break;
            }
            case 192: {
                this.setHalfWord(n2, this.dma1.getDestinationLRegister());
                break;
            }
            case 194: {
                this.setHalfWord(n2, this.dma1.getDestinationHRegister());
                break;
            }
            case 196: {
                this.setHalfWord(n2, this.dma1.getCountRegister());
                break;
            }
            case 198: {
                this.setHalfWord(n2, this.dma1.getControlRegister());
                break;
            }
            case 200: {
                this.setHalfWord(n2, this.dma2.getSourceLRegister());
                break;
            }
            case 202: {
                this.setHalfWord(n2, this.dma2.getSourceHRegister());
                break;
            }
            case 204: {
                this.setHalfWord(n2, this.dma2.getDestinationLRegister());
                break;
            }
            case 206: {
                this.setHalfWord(n2, this.dma2.getDestinationHRegister());
                break;
            }
            case 208: {
                this.setHalfWord(n2, this.dma2.getCountRegister());
                break;
            }
            case 210: {
                this.setHalfWord(n2, this.dma2.getControlRegister());
                break;
            }
            case 212: {
                this.setHalfWord(n2, this.dma3.getSourceLRegister());
                break;
            }
            case 214: {
                this.setHalfWord(n2, this.dma3.getSourceHRegister());
                break;
            }
            case 216: {
                this.setHalfWord(n2, this.dma3.getDestinationLRegister());
                break;
            }
            case 218: {
                this.setHalfWord(n2, this.dma3.getDestinationHRegister());
                break;
            }
            case 220: {
                this.setHalfWord(n2, this.dma3.getCountRegister());
                break;
            }
            case 222: {
                this.setHalfWord(n2, this.dma3.getControlRegister());
                break;
            }
            case 256: {
                this.setHalfWord(n2, this.timer0.getTime());
                break;
            }
            case 260: {
                this.setHalfWord(n2, this.timer1.getTime());
                break;
            }
            case 264: {
                this.setHalfWord(n2, this.timer2.getTime());
                break;
            }
            case 268: {
                this.setHalfWord(n2, this.timer3.getTime());
            }
        }
        return this.space[n];
    }

    public short loadHalfWord(int n) {
        return (short)(this.loadByte(n &= 0xFFFFFFFE) & 0xFF | this.loadByte(n + 1) << 8);
    }

    public int loadWord(int n) {
        return this.loadByte(n &= 0xFFFFFFFC) & 0xFF | (this.loadByte(n + 1) & 0xFF) << 8 | (this.loadByte(n + 2) & 0xFF) << 16 | this.loadByte(n + 3) << 24;
    }

    private static short getValue16(boolean bl, short s, byte by) {
        return (short)(bl ? s & 0xFF00 | by & 0xFF : s & 0xFF | by << 8);
    }

    public void storeByte(int n, byte by) {
        n = this.getInternalOffset(n);
        int n2 = n & 0xFFFFFFFE;
        boolean bl = (n & 1) == 0;
        short s = IORegMemory.getValue16(bl, this.getHalfWord(n2), by);
        switch (n2) {
            case 6: {
                return;
            }
            case 176: {
                this.dma0.setSourceLRegister(s);
                break;
            }
            case 178: {
                this.dma0.setSourceHRegister(s);
                break;
            }
            case 180: {
                this.dma0.setDestinationLRegister(s);
                break;
            }
            case 182: {
                this.dma0.setDestinationHRegister(s);
                break;
            }
            case 184: {
                this.dma0.setCountRegister(s);
                break;
            }
            case 186: {
                this.dma0.setControlRegister(s);
                break;
            }
            case 188: {
                this.dma1.setSourceLRegister(s);
                break;
            }
            case 190: {
                this.dma1.setSourceHRegister(s);
                break;
            }
            case 192: {
                this.dma1.setDestinationLRegister(s);
                break;
            }
            case 194: {
                this.dma1.setDestinationHRegister(s);
                break;
            }
            case 196: {
                this.dma1.setCountRegister(s);
                break;
            }
            case 198: {
                this.dma1.setControlRegister(s);
                break;
            }
            case 200: {
                this.dma2.setSourceLRegister(s);
                break;
            }
            case 202: {
                this.dma2.setSourceHRegister(s);
                break;
            }
            case 204: {
                this.dma2.setDestinationLRegister(s);
                break;
            }
            case 206: {
                this.dma2.setDestinationHRegister(s);
                break;
            }
            case 208: {
                this.dma2.setCountRegister(s);
                break;
            }
            case 210: {
                this.dma2.setControlRegister(s);
                break;
            }
            case 212: {
                s = IORegMemory.getValue16(bl, this.dma3.getSourceLRegister(), by);
                this.dma3.setSourceLRegister(s);
                break;
            }
            case 214: {
                s = IORegMemory.getValue16(bl, this.dma3.getSourceHRegister(), by);
                this.dma3.setSourceHRegister(s);
                break;
            }
            case 216: {
                s = IORegMemory.getValue16(bl, this.dma3.getDestinationLRegister(), by);
                this.dma3.setDestinationLRegister(s);
                break;
            }
            case 218: {
                s = IORegMemory.getValue16(bl, this.dma3.getDestinationHRegister(), by);
                this.dma3.setDestinationHRegister(s);
                break;
            }
            case 220: {
                s = IORegMemory.getValue16(bl, this.dma3.getCountRegister(), by);
                this.dma3.setCountRegister(s);
                break;
            }
            case 222: {
                s = IORegMemory.getValue16(bl, this.dma3.getControlRegister(), by);
                this.dma3.setControlRegister(s);
                break;
            }
            case 256: {
                this.timer0.setTime(s);
                break;
            }
            case 258: {
                this.timer0.updateState(s);
                break;
            }
            case 260: {
                this.timer1.setTime(s);
                break;
            }
            case 262: {
                this.timer1.updateState(s);
                break;
            }
            case 264: {
                this.timer2.setTime(s);
                break;
            }
            case 266: {
                this.timer2.updateState(s);
                break;
            }
            case 268: {
                this.timer3.setTime(s);
                break;
            }
            case 270: {
                this.timer3.updateState(s);
                break;
            }
            case 304: {
                return;
            }
            case 514: {
                int n3 = n;
                this.space[n3] = (byte)(this.space[n3] & ~by);
                return;
            }
        }
        this.space[n] = by;
    }

    public void storeHalfWord(int n, short s) {
        this.storeByte(n &= 0xFFFFFFFE, (byte)s);
        this.storeByte(n + 1, (byte)(s >>> 8));
    }

    public void storeWord(int n, int n2) {
        this.storeByte(n &= 0xFFFFFFFC, (byte)n2);
        this.storeByte(n + 1, (byte)(n2 >>> 8));
        this.storeByte(n + 2, (byte)(n2 >>> 16));
        this.storeByte(n + 3, (byte)(n2 >>> 24));
    }

    public void softReset() {
        this.hardReset();
        this.setHalfWord(0, (short)128);
        this.setHalfWord(32, (short)256);
        this.setHalfWord(38, (short)256);
        this.setHalfWord(48, (short)256);
        this.setHalfWord(54, (short)256);
        this.setHalfWord(304, (short)1023);
        this.keyInput = (short)1023;
    }

    public int getVideoMode() {
        return this.getByte(0) & 7;
    }

    public boolean isFrame1Selected() {
        return (this.getByte(0) & 0x10) != 0;
    }

    public boolean isHBlankIntervalFree() {
        return (this.getByte(0) & 0x20) != 0;
    }

    public boolean isOBJ1DMapping() {
        return (this.getByte(0) & 0x40) != 0;
    }

    public boolean isForcedBlank() {
        return (this.getByte(0) & 0x80) != 0;
    }

    public boolean isBGEnabled(int n) {
        return (this.getByte(1) & BGBit[n]) != 0;
    }

    public boolean isWinEnabled(int n) {
        return (this.getByte(1) & WinBit[n]) != 0;
    }

    public boolean isOBJEnabled() {
        return (this.getByte(1) & 0x10) != 0;
    }

    public boolean isOBJWinEnabled() {
        return (this.getByte(1) & 0x80) != 0;
    }

    public void setVBlankFlag(boolean bl) {
        byte by = this.getByte(4);
        by = bl ? (byte)(by | 1) : (byte)(by & 0xFFFFFFFE);
        this.setByte(4, by);
    }

    public void setHBlankFlag(boolean bl) {
        byte by = this.getByte(4);
        by = bl ? (byte)(by | 2) : (byte)(by & 0xFFFFFFFD);
        this.setByte(4, by);
    }

    public boolean isVCounterMatchInterruptEnabled() {
        return (this.getByte(4) & 0x20) != 0;
    }

    public int getVCountSetting() {
        return this.getByte(5) & 0xFF;
    }

    public int getCurrentScanline() {
        return this.getByte(6) & 0xFF;
    }

    public void setCurrentScanline(int n) {
        this.setByte(6, (byte)n);
    }

    public int getPriority(int n) {
        return this.getByte(REG_BGxCNT[n]) & 3;
    }

    public int getCharacterBaseAddress(int n) {
        return (this.getByte(REG_BGxCNT[n]) & 0xC) << 12;
    }

    public int getScreenBaseAddress(int n) {
        return (this.getByte(REG_BGxCNT[n] + 1) & 0x1F) << 11;
    }

    public boolean isMosaicEnabled(int n) {
        return (this.getByte(REG_BGxCNT[n]) & 0x40) != 0;
    }

    public boolean is256ColorPalette(int n) {
        return (this.getByte(REG_BGxCNT[n]) & 0x80) != 0;
    }

    public boolean isWraparoundOverflow(int n) {
        return (this.getByte(REG_BGxCNT[n] + 1) & 0x20) != 0;
    }

    public int getTextModeXSize(int n) {
        return (this.getByte(REG_BGxCNT[n] + 1) & 0x40) == 0 ? 256 : 512;
    }

    public int getTextModeYSize(int n) {
        return (this.getByte(REG_BGxCNT[n] + 1) & 0x80) == 0 ? 256 : 512;
    }

    public int getRotScalModeXYSize(int n) {
        switch (this.getByte(REG_BGxCNT[n] + 1) & 0xC0) {
            case 0: {
                return 128;
            }
            case 64: {
                return 256;
            }
            case 128: {
                return 512;
            }
            case 192: {
                return 1024;
            }
        }
        return 0;
    }

    public int getXOffset(int n) {
        return this.getHalfWord(REG_BGxHOFS[n]) & 0x1FF;
    }

    public int getYOffset(int n) {
        return this.getHalfWord(REG_BGxVOFS[n]) & 0x1FF;
    }

    public int getXCoordinate(int n) {
        return this.getWord(REG_BGxX[n]) << 4 >> 4;
    }

    public int getYCoordinate(int n) {
        return this.getWord(REG_BGxY[n]) << 4 >> 4;
    }

    public short getPA(int n) {
        return this.getHalfWord(REG_BGxPA[n]);
    }

    public short getPB(int n) {
        return this.getHalfWord(REG_BGxPB[n]);
    }

    public short getPC(int n) {
        return this.getHalfWord(REG_BGxPC[n]);
    }

    public short getPD(int n) {
        return this.getHalfWord(REG_BGxPD[n]);
    }

    public int getBGMosaicXSize() {
        return (this.getByte(76) & 0xF) + 1;
    }

    public int getBGMosaicYSize() {
        return (this.getByte(76) >>> 4 & 0xF) + 1;
    }

    public int getOBJMosaicXSize() {
        return (this.getByte(77) & 0xF) + 1;
    }

    public int getOBJMosaicYSize() {
        return (this.getByte(77) >>> 4 & 0xF) + 1;
    }

    private static short keyInput(int n) {
        switch (n) {
            case 88: {
                return 1;
            }
            case 67: {
                return 2;
            }
            case 8: {
                return 4;
            }
            case 10: {
                return 8;
            }
            case 39: {
                return 16;
            }
            case 37: {
                return 32;
            }
            case 38: {
                return 64;
            }
            case 40: {
                return 128;
            }
            case 68: {
                return 256;
            }
            case 83: {
                return 512;
            }
        }
        return 0;
    }

    public void keyPressed(int n) {
        this.keyInput = (short)(this.keyInput & ~IORegMemory.keyInput(n));
        this.setHalfWord(304, this.keyInput);
    }

    public void keyReleased(int n) {
        this.keyInput = (short)(this.keyInput | IORegMemory.keyInput(n));
        this.setHalfWord(304, this.keyInput);
    }

    public boolean isInterruptMasterEnabled() {
        return (this.getByte(520) & 1) != 0;
    }

    public boolean isInterruptEnabled(short s) {
        return (this.getHalfWord(512) & s) != 0;
    }

    public void generateInterrupt(short s) {
        this.setHalfWord(514, (short)(this.getHalfWord(514) | this.getHalfWord(512) & s));
    }

    public void enterHBlank() {
        int n = this.getCurrentScanline();
        this.gfx.drawLine(n);
        this.dma0.signalHBlank();
        this.dma1.signalHBlank();
        this.dma2.signalHBlank();
        this.dma3.signalHBlank();
        this.generateInterrupt((short)2);
        this.setHBlankFlag(true);
        if (this.isVCounterMatchInterruptEnabled() && n == this.getVCountSetting()) {
            this.generateInterrupt((short)4);
        }
    }

    public void exitHBlank() {
        this.setHBlankFlag(false);
    }

    public void enterVBlank() {
        this.dma0.signalVBlank();
        this.dma1.signalVBlank();
        this.dma2.signalVBlank();
        this.dma3.signalVBlank();
        this.generateInterrupt((short)1);
        this.setVBlankFlag(true);
    }

    public void exitVBlank() {
        this.setVBlankFlag(false);
    }
}

