/*
 * Decompiled with CFR 0.152.
 */
package ygba.ui;

import ygba.cpu.ARM7TDMI;
import ygba.ui.InternationalTableModel;
import ygba.util.Hex;

final class FlagViewerTableModel
extends InternationalTableModel {
    private ARM7TDMI cpu;

    public FlagViewerTableModel(ARM7TDMI aRM7TDMI) {
        this.cpu = aRM7TDMI;
        this.columnName = new String[2];
        this.columnName[0] = "Flag";
        this.columnName[1] = "Value";
    }

    public int getRowCount() {
        return 8;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                switch (n) {
                    case 0: {
                        return "M";
                    }
                    case 1: {
                        return "T";
                    }
                    case 2: {
                        return "F";
                    }
                    case 3: {
                        return "I";
                    }
                    case 4: {
                        return "V";
                    }
                    case 5: {
                        return "C";
                    }
                    case 6: {
                        return "N";
                    }
                    case 7: {
                        return "Z";
                    }
                }
                return "";
            }
            case 1: {
                switch (n) {
                    case 0: {
                        return this.cpu.getModeName() + " (" + Hex.toHexString(this.cpu.getMode()) + ")";
                    }
                    case 1: {
                        return this.cpu.getTFlag();
                    }
                    case 2: {
                        return this.cpu.getFFlag();
                    }
                    case 3: {
                        return this.cpu.getIFlag();
                    }
                    case 4: {
                        return this.cpu.getVFlag();
                    }
                    case 5: {
                        return this.cpu.getCFlag();
                    }
                    case 6: {
                        return this.cpu.getNFlag();
                    }
                    case 7: {
                        return this.cpu.getZFlag();
                    }
                }
                return "";
            }
        }
        return "";
    }
}

