/*
 * Decompiled with CFR 0.152.
 */
package ygba.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import ygba.YGBA;
import ygba.gfx.GFXScreen;
import ygba.memory.IORegMemory;
import ygba.memory.Memory;
import ygba.ui.AboutDialog;
import ygba.ui.DebuggerDialog;
import ygba.ui.YGBAFileFilter;

public final class YGBAApplet
extends JApplet
implements ActionListener,
KeyListener,
MouseListener {
    private YGBA ygba;
    private Memory memory;
    private IORegMemory iorMem;
    private GFXScreen gfxScreen;
    private boolean isApplet;
    private URL biosURL;
    private URL romURL;
    private JPopupMenu popupMenu;
    private JMenu fileMenu;
    private JMenuItem openBIOSMenuItem;
    private JMenuItem openROMMenuItem;
    private JMenuItem resetMenuItem;
    private JCheckBoxMenuItem pauseMenuItem;
    private JMenu toolsMenu;
    private JMenuItem debuggerMenuItem;
    private JMenuItem aboutMenuItem;
    private JFileChooser biosFileChooser;
    private JFileChooser romFileChooser;
    private YGBAFileFilter fileFilter;
    private static final String OpenBIOSCommand = "OPEN_BIOS";
    private static final String OpenROMCommand = "OPEN_ROM";
    private static final String ResetCommand = "RESET";
    private static final String PauseCommand = "PAUSE";
    private static final String LaunchDebuggerCommand = "LAUNCH_DEBUGGER";
    private static final String DisplayAboutInfoCommand = "DISPLAY_ABOUT_INFO";
    private static final int OpenBIOSKey = 112;
    private static final int OpenROMKey = 113;
    private static final int ResetKey = 82;
    private static final int PauseKey = 80;
    private static final int LaunchDebuggerKey = 68;

    public YGBAApplet() {
        this(true);
    }

    public YGBAApplet(boolean bl) {
        this.isApplet = bl;
        this.romURL = null;
        this.biosURL = null;
    }

    public void init() {
        this.ygba = new YGBA();
        this.memory = this.ygba.getMemory();
        this.iorMem = this.memory.getIORegMemory();
        this.gfxScreen = new GFXScreen(this.ygba.getGraphics());
        this.openBIOSMenuItem = new JMenuItem("Open BIOS");
        this.openBIOSMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.openBIOSMenuItem.setActionCommand(OpenBIOSCommand);
        this.openBIOSMenuItem.addActionListener(this);
        this.openROMMenuItem = new JMenuItem("Open ROM");
        this.openROMMenuItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.openROMMenuItem.setActionCommand(OpenROMCommand);
        this.openROMMenuItem.addActionListener(this);
        this.resetMenuItem = new JMenuItem("Reset");
        this.resetMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.resetMenuItem.setActionCommand(ResetCommand);
        this.resetMenuItem.addActionListener(this);
        this.pauseMenuItem = new JCheckBoxMenuItem("Pause");
        this.pauseMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        this.pauseMenuItem.setActionCommand(PauseCommand);
        this.pauseMenuItem.addActionListener(this);
        this.pauseMenuItem.setSelected(false);
        this.fileMenu = new JMenu("File");
        this.fileMenu.add(this.openBIOSMenuItem);
        this.fileMenu.add(this.openROMMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.resetMenuItem);
        this.fileMenu.add(this.pauseMenuItem);
        this.debuggerMenuItem = new JMenuItem("Debugger");
        this.debuggerMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 512));
        this.debuggerMenuItem.setActionCommand(LaunchDebuggerCommand);
        this.debuggerMenuItem.addActionListener(this);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.add(this.debuggerMenuItem);
        this.aboutMenuItem = new JMenuItem("About");
        this.aboutMenuItem.setActionCommand(DisplayAboutInfoCommand);
        this.aboutMenuItem.addActionListener(this);
        this.setupPopupMenu(false);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.fileMenu);
        this.popupMenu.add(this.toolsMenu);
        this.popupMenu.add(this.aboutMenuItem);
        Container container = this.getContentPane();
        container.setBackground(Color.BLACK);
        container.add(this.gfxScreen);
        this.requestFocus();
        this.addKeyListener(this);
        this.addMouseListener(this);
        if (this.isApplet) {
            this.openBIOSMenuItem.setEnabled(false);
            this.openROMMenuItem.setEnabled(false);
            try {
                this.biosURL = new URL(this.getParameter("bios"));
                this.romURL = new URL(this.getParameter("rom"));
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            this.fileFilter = new YGBAFileFilter();
            this.biosFileChooser = new JFileChooser();
            this.biosFileChooser.setFileFilter(this.fileFilter);
            this.biosFileChooser.setDialogTitle("Open BIOS");
            this.romFileChooser = new JFileChooser();
            this.romFileChooser.setFileFilter(this.fileFilter);
            this.romFileChooser.setDialogTitle("Open ROM");
        }
    }

    public void start() {
        if (this.biosURL != null) {
            this.memory.loadBIOS(this.biosURL);
        }
        if (this.romURL != null) {
            this.memory.loadROM(this.romURL);
        }
        if (this.ygba.isReady()) {
            this.ygba.reset();
            this.ygba.run();
            this.setupPopupMenu(true);
        }
    }

    public void stop() {
        this.ygba.stop();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        boolean bl = this.pauseMenuItem.isSelected();
        if (string.equals(OpenBIOSCommand)) {
            int n = this.biosFileChooser.showOpenDialog(null);
            if (n == 0) {
                try {
                    this.biosURL = this.biosFileChooser.getSelectedFile().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.ygba.stop();
                this.memory.unloadBIOS();
                this.memory.loadBIOS(this.biosURL);
                if (this.ygba.isReady()) {
                    this.ygba.reset();
                    if (!bl) {
                        this.ygba.run();
                    }
                    this.setupPopupMenu(true);
                } else {
                    this.gfxScreen.clear();
                    this.setupPopupMenu(false);
                }
            }
        } else if (string.equals(OpenROMCommand)) {
            int n = this.romFileChooser.showOpenDialog(null);
            if (n == 0) {
                try {
                    this.romURL = this.romFileChooser.getSelectedFile().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.ygba.stop();
                this.memory.unloadROM();
                this.memory.loadROM(this.romURL);
                if (this.ygba.isReady()) {
                    this.ygba.reset();
                    if (!bl) {
                        this.ygba.run();
                    }
                    this.setupPopupMenu(true);
                } else {
                    this.gfxScreen.clear();
                    this.setupPopupMenu(false);
                }
            }
        } else if (string.equals(ResetCommand)) {
            this.ygba.stop();
            this.ygba.reset();
            if (!bl) {
                this.ygba.run();
            }
        } else if (string.equals(PauseCommand)) {
            if (bl) {
                this.ygba.stop();
            } else {
                this.ygba.run();
            }
        } else if (string.equals(LaunchDebuggerCommand)) {
            this.ygba.stop();
            new DebuggerDialog(this.ygba);
            if (!bl) {
                this.ygba.run();
            }
        } else if (string.equals(DisplayAboutInfoCommand)) {
            this.ygba.stop();
            new AboutDialog();
            if (this.ygba.isReady() & !bl) {
                this.ygba.run();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isControlDown();
        boolean bl2 = keyEvent.isAltDown();
        switch (n) {
            case 112: {
                this.openBIOSMenuItem.doClick();
                break;
            }
            case 113: {
                this.openROMMenuItem.doClick();
                break;
            }
            case 82: {
                if (!bl) break;
                this.resetMenuItem.doClick();
                break;
            }
            case 80: {
                if (!bl) break;
                this.pauseMenuItem.doClick();
                break;
            }
            case 68: {
                if (!bl2) break;
                this.debuggerMenuItem.doClick();
            }
        }
        this.iorMem.keyPressed(keyEvent.getKeyCode());
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.iorMem.keyReleased(keyEvent.getKeyCode());
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu.show(this.gfxScreen, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu.show(this.gfxScreen, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void setupPopupMenu(boolean bl) {
        this.resetMenuItem.setEnabled(bl);
        this.debuggerMenuItem.setEnabled(bl);
    }
}

