/******************************************************************************
Ootake
EVistaAEROɑΉ邽߁ADirect3Dł̕`BA@\Iɂ
  ScreenDD.c(DirectDraw`)ƓBJ[32rbĝݑΉƂB

Copyright(C)2006-2025 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

******************************************************************************/
#define _CRT_SECURE_NO_DEPRECATE

#define DIRECT3D_VERSION	0x0900

#define SOURCE_PITCH 		512

#include <D3D9.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include "ScreenD3D.h"
#include "Screen.h"
#include "WinMain.h"
#include "App.h"
#include "MainBoard.h"
#include "Printf.h"
#include "ADPCM.h"
#include "CDROM.h"

extern Uint32 _GammaTBL[0xFFFFFF+1]; //24bit̐FR[h(PCE9bit24(32)bit)̐Fe[uBBGRBv2.99
extern Uint32 _GammaTBLs80[0xFFFFFF+1]; //24bit̐FR[h(PCE9bit24(32)bit)̐Fe[uBBGRBXLC80%pBv2.99
extern Uint32 _GammaTBLs90[0xFFFFFF+1]; //24bit̐FR[h(PCE9bit24(32)bit)̐Fe[uBBGRBXLC90%pBv2.99
extern Uint32 _MonoTBL[0xFFFFFF+1]; //mNϊpe[uBBGRBO[fBXvC[h̎̓O[mNɂȂBv2.99
extern Uint32 _MonoTBLs80[0xFFFFFF + 1]; //XLC80%p
extern Uint32 _MonoTBLs90[0xFFFFFF + 1]; //XLC90%p

//KitaoǉBDirect3D9Exp`Bv2.21
static HINSTANCE _hD3D9Dll;
typedef HRESULT(WINAPI* FuncDirect3DCreate9Ex) (UINT, IDirect3D9Ex**);
static FuncDirect3DCreate9Ex _FuncDirect3DCreate9Ex;
static UINT		_MaxFrameLatency = 1; //rfĨRg[plŐݒ肳Ăuő僌_Ot[vBXPł͓邱ƂłȂ̂1ƂĂB

static LPDIRECT3D9				_pD3D = NULL; //Direct3D object
static LPDIRECT3DDEVICE9		_pD3DDev = NULL; //foCX
static IDirect3D9Ex*			_pD3DEx = NULL; //Direct3DEx objectBv2.21ǉBWin7/Vistaŕ`xȂ邽߂ɕKvB
static IDirect3DDevice9Ex*		_pD3DDevEx = NULL; //
static LPDIRECT3DSURFACE9		_pD3DSBack = NULL; //obNobt@(ɓ]Ǝۂɕ`悳)
static LPDIRECT3DSURFACE9		_pD3DSGame = NULL; //Cʗp
static LPDIRECT3DSURFACE9		_pD3DSText = NULL; //eLXgbZ[W,FPS,I[fBIOt\p
static D3DPRESENT_PARAMETERS	_pD3DParam;

static BOOL		_bIntelVideoChip = FALSE; //Ce̓rfI`bv̏ꍇTRUEɁBv2.79
static BOOL		_bOldVideoChip = FALSE; //ÂrfI`bv(rfIJ[h)̏ꍇTRUEɁBv2.19

static LONG		_SurfacePitch = 0;

static Sint32	_Width;
static Sint32	_Height;
static Sint32	_Magnification;
static Uint32	_Flags;
static HWND		_hWnd;
static Uint16* _pScreenPixels;
static BOOL		_bChangedFullScreen = FALSE;
static Sint32	_GameLeft;   //print_message()ŕ\ʒû߂ɁAQ[ʓ]̍WTĂB
static Sint32	_GameRight;  //
static Sint32	_GameTop;    //
static Sint32	_GameBottom; //

//Win9xpϐ
static DWORD	_PrevWidth;
static DWORD	_PrevHeight;
static DWORD	_PrevBitsPerPixel;
static DWORD	_PrevFrequency;

static Sint64	_LastTimeSyncTime; //OSyncƂ̃^C}[JEgBPʂ1/1000ms
static Sint64	_LastTimeSyncTime3; //3t[Pʂł́AOSyncƂ̃^C}[JEgBv2.43
static BOOL		_bVSyncScreen = TRUE;

static LONG		_Pitch;
static LONG		_Pitch2; //pitch2{̒lĂBxAbvpB
static LONG		_Pitch3; //pitch3{̒lĂBxAbvpB
static LONG		_Pitch4; //pitch4{̒lĂBxAbvpB
static LONG		_Pitch5; //pitch5{̒lĂBxAbvpB
static Uint32* _pPixels; //v2.13XVB32bitPʂň悤ɂB()

static char* _pMessageText = ""; //eLXgbZ[W\pobt@Bki擪0j̏ꍇA\B
static char* _pCenterText = ""; //Z^[eLXgbZ[W\pobt@Bki擪0j̏ꍇA\B

//I[fBIOt\Ƃ̃f[^B\Pt[OɂɕۑĂBPt[x点鎖ŉʂƂ̃^C~O߂ÂBv2.92
static Sint32	_PSGChannelStatus[6];
static Sint32	_PSGSampleL[6];
static Sint32	_PSGSampleR[6];
static Sint32	_ADPCMSample;
static Sint32	_CDDASampleL;
static Sint32	_CDDASampleR;

//D3DfoCX̊J
static void
d3dSurfaceRelease()
{
	if (_pD3DSText != NULL)
	{
		_pD3DSText->Release(); _pD3DSText = NULL;
	}

	if (_pD3DSGame != NULL)
	{
		_pD3DSGame->Release(); _pD3DSGame = NULL;
	}

	if (_pD3DSBack != NULL)
	{
		_pD3DSBack->Release(); _pD3DSBack = NULL;
	}
}

//Direct3DpXN[SɊJ܂B
void
SCREEND3D_Deinit()
{
	if (_pD3D != NULL)
	{
		d3dSurfaceRelease();
		if (APP_GetWindowsVista()) //Vistaȍ~Direct3D9Exgꍇ
		{
			if (_pD3DDevEx != NULL)
			{
				_pD3DDevEx->Release(); //ExŊJs
				_pD3DDevEx = NULL;
			}
			_pD3DEx->Release(); //ExŊJs
			_pD3DEx = NULL;
		}
		else //VistaOWindows̏ꍇAʂɊJB
		{
			if (_pD3DDev != NULL)
				_pD3DDev->Release();
			_pD3D->Release();
		}
		_pD3DDev = NULL;
		_pD3D = NULL;
	}
	if (APP_GetWindowsVista())
		FreeLibrary(_hD3D9Dll); //DLLJ
}

//v2.70XV
static HRESULT
d3dCreate()
{
	HRESULT		hr;

	if (APP_GetWindowsVista())
	{	//v2.21ǉ
		hr = _pD3DEx->CreateDeviceEx(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, _hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING,
			&_pD3DParam, NULL, &_pD3DDevEx); //v2.70XVBHARDWARÊقƂȂxȂCB
		if (FAILED(hr))
		{
			hr = _pD3DEx->CreateDeviceEx(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, _hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING,
				&_pD3DParam, NULL, &_pD3DDevEx); //v2.71XVBCěÂ`bvȂǂŃVF[_[̏ꍇG[ɂȂ̂ł̏ꍇSOFTWAREB
			if (FAILED(hr))
				MessageBox(_hWnd, "ERROR: DIRECT3D::CreateDeviceEx() failed.    ", "Ootake", MB_OK);
		}
		_pD3DDevEx->GetMaximumFrameLatency(&_MaxFrameLatency); //Rg[plŐݒ肳Ă郌_Ot[𓾂BRg[plŐݒ肵ĂĂ3KԂĂ悤Ȃ̂ŌgBv2.88
		_pD3DDevEx->SetMaximumFrameLatency(1); //xŏɗ}BAeroIt{łXPɁBRg[pl̐ݒɂĂ͌Ȃi̊ł̓ftHgݒŌȂĵŋCxߒxBv2.88XV
		_pD3DDev = _pD3DDevEx; //^LXgBƂ͒ʏDirect3D9ɔCB
		//{
		//	char s[100];
		//	sprintf(s,"MaxLatency = %d", _MaxFrameLatency);
		//	MessageBox(WINMAIN_GetHwnd(), s, "Test", MB_OK); //Kitao Test
		//}
	}
	else
	{
		hr = _pD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, _hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING,
			&_pD3DParam, &_pD3DDev); //v2.70XVBHARDWARÊقƂȂxȂCB
		if (FAILED(hr))
			hr = _pD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, _hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING,
				&_pD3DParam, &_pD3DDev); //v2.71XVBCěÂ`bvȂǂŃVF[_[̏ꍇG[ɂȂ̂ł̏ꍇSOFTWAREB
	}
	return hr;
}

static HRESULT
d3dDevReset()
{
	int			a;
	HRESULT		hr;

	if (_pD3DDev == NULL) //쐬̏ꍇ
	{
		hr = d3dCreate(); //2.70XV
	}
	else //łɍ쐬ς݂̏ꍇ
	{
		d3dSurfaceRelease();
		hr = _pD3DDev->Reset(&_pD3DParam);
		if (FAILED(hr)) //ZbgɎs蒼
		{
			_pD3DDev->Release();
			_pD3DDev = NULL;
			hr = d3dCreate(); //2.70XV
		}
	}
	if (FAILED(hr))
		return hr;

	//obNobt@[̃AhX擾
	_pD3DDev->GetBackBuffer(0, 0, D3DBACKBUFFER_TYPE_MONO, &_pD3DSBack);

	//C(Q[)ʕ\pItXN[T[tFX쐬
	if (_Magnification == 1)
		a = 512 + 8; //+8͉E[ɃNA}[WݗpBDirect3Dł͉E[ŃNAĂȂƃtB^̃oCg܂ŎQƂ̂ŉE[邱Ƃ悤Bv2.06XVB+1ővƎvÔ8̔{ɂB
	else //2{ȏ͑Sĉ2{BxAbv{邱ƂœKxɃoCjAtB^|肢ɂȂ
		a = 512 * 2 + 8; //+8͉E[ɃNA}[WݗpBDirect3Dł͉E[ŃNAĂȂƃtB^̃oCg܂ŎQƂ̂ŉE[邱Ƃ悤Bv2.06XVB+1ővƎvÔ8̔{ɂB
	_pD3DDev->CreateOffscreenPlainSurface(a, 256 * _Magnification, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &_pD3DSGame, NULL); //D3DPOOL_DEFAULTɂȂStretchRectgȂB

	//eLXg\pItXN[T[tFX쐬
	_pD3DDev->CreateOffscreenPlainSurface(512 * 2, 67, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &_pD3DSText, NULL);//I[fBIOt̂߂ɏc67hbgmہBv2.92XV

	return hr;
}

//Direct3DpXN[܂B
BOOL
SCREEND3D_Init(
	Sint32		width,
	Sint32		height,
	Sint32		magnification,
	Uint32		flags)
{
	DEVMODE					dm;
	D3DDISPLAYMODE			dmode;
	D3DADAPTER_IDENTIFIER9	di;
	HRESULT					hr;

	//p[^ۊ
	_Width = width;
	_Height = height;
	_Magnification = magnification;
	_Flags = flags;
	_hWnd = WINMAIN_GetHwnd();

	if (APP_GetWindowsVista()) //Vistaȍ~Direct3D9ExgȂ
	{	//v2.21ǉ
		_hD3D9Dll = LoadLibrary("d3d9.dll"); //VistaOWindowsŃG[NȂ߁AIDLL[hĊ֐gpB
		_FuncDirect3DCreate9Ex = (FuncDirect3DCreate9Ex)GetProcAddress(_hD3D9Dll, "Direct3DCreate9Ex");
		_FuncDirect3DCreate9Ex(D3D_SDK_VERSION, &_pD3DEx);
		_pD3D = _pD3DEx;
	}
	else //XPȑO
		_pD3D = Direct3DCreate9(D3D_SDK_VERSION);

	if (_pD3D == NULL)
	{
		MessageBox(_hWnd, "ERROR: DIRECT3D::Direct3DCreate9() failed.    ", "Ootake", MB_OK);
		return FALSE;
	}

	//tXN[̏ꍇA ʂ̉𑜓xݒ肵AEBhEɔzuʑS̑傫ɂB
	//	Direct3D9̃tXN[[h́Aj[⑼̃_CAO\ɏoȂ̂ŎgȂB蓮ŃtXN[ɐ؂ւĂEBhE[hgB
	//										 ^C}[̐iݕȂsAEBhE[hȂłB
	if (flags & SCREEN_FFULLSCREEN) //tXN[[hȂ
	{
		if (_bChangedFullScreen == FALSE) //EBhE(fXNgbv)tXN[ւ̐؂ւ
		{
			//̃AṽEBhȄԂۑĂBv2.24
			SCREEN_SaveWindowPosition();
			//Windows98/MȅꍇACDS_FULLSCREENȂAfXNgbvɖ߂Ȃ̂ŁA蓮Ōɖ߂ߕύXO̐ݒޔĂB
			if (APP_GetWindows9x())
			{
				memset(&dm, 0, sizeof(DEVMODE));
				dm.dmSize = sizeof(DEVMODE);
				EnumDisplaySettings(NULL, ENUM_CURRENT_SETTINGS, &dm);
				_PrevWidth = dm.dmPelsWidth;
				_PrevHeight = dm.dmPelsHeight;
				_PrevBitsPerPixel = dm.dmBitsPerPel;
				_PrevFrequency = dm.dmDisplayFrequency;
			}
		}
		memset(&dm, 0, sizeof(DEVMODE));
		dm.dmSize = sizeof(DEVMODE);
		dm.dmPelsWidth = width;
		dm.dmPelsHeight = height;
		dm.dmBitsPerPel = 32;
		dm.dmDisplayFrequency = APP_GetFullVSyncHz();
		dm.dmFields = DM_PELSWIDTH | DM_PELSHEIGHT | DM_BITSPERPEL | DM_DISPLAYFREQUENCY;
		if ((APP_GetResolutionAutoChange()) && (_bChangedFullScreen))
			hr = ChangeDisplaySettings(&dm, 0); //ݒTɐؑցBꕔ̊Őؑ֎̂Bv2.23BÂRADEONŐ؂ւɉ摜̗mFς݁Bv2.65
		else //ʏ
			ChangeDisplaySettings(&dm, CDS_FULLSCREEN);
		WINMAIN_SetFullScreenWindow(width, height);//v2.23ǉB̃^C~OŁAEBhEX^C̕ύXs悤ɂBp[̖}VłDirectXɎԂ|̂ł̃^C~Oŉʂ𐮂قǂB
		_bChangedFullScreen = TRUE;
	}
	else //EBhE[hȂ
	{
		if (_bChangedFullScreen) //tXN[EBhEւ̐؂ւ
		{
			if (APP_GetWindows9x()) //Windows98/MȅꍇACDS_FULLSCREENȂAŃfXNgbv̏Ԃɖ߂Ȃ̂ŁA蓮Ōɖ߂B
			{
				memset(&dm, 0, sizeof(DEVMODE));
				dm.dmSize = sizeof(DEVMODE);
				dm.dmPelsWidth = _PrevWidth;
				dm.dmPelsHeight = _PrevHeight;
				dm.dmBitsPerPel = _PrevBitsPerPixel;
				dm.dmDisplayFrequency = _PrevFrequency;
				dm.dmFields = DM_PELSWIDTH | DM_PELSHEIGHT | DM_BITSPERPEL | DM_DISPLAYFREQUENCY;
				ChangeDisplaySettings(&dm, 0);
			}
			else //Windows XP/2000/Vistaȍ~̏ꍇ	
				ChangeDisplaySettings(NULL, 0); //fXNgbvɖ߂
			SCREEN_LoadWindowPosition(); //̃AṽEBhEԂɖ߂Bv2.24
			Sleep(1000); //fXNgbvɖ߂鏈SɏI܂ŔÔ߂ɃEFCgBDirecDraŵƂ̂悤Direct3D̃foCX̍쐬sȂ̂ŁB
		}
		WINMAIN_SetNormalWindow(width, height);//v2.23ǉB̃^C~OŁAEBhEX^C̕ύXs悤ɂBp[̖}VłDirectXɎԂ|̂ł̃^C~Oŉʂ𐮂قǂB
		APP_WindowWithinScreen(); //EBhEʂ͂ݏoĂꍇAʓɎ܂悤ɈړB
		_bChangedFullScreen = FALSE;
	}

	//fBXvC[h擾BWindow[hɂVSync\ǂ̔fs߂ɗp
	_pD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &dmode);

	//fBXvCA_v^(rfI`bv)̏擾Bv2.19
	_pD3D->GetAdapterIdentifier(D3DADAPTER_DEFAULT, 0, &di);
	APP_StrToLower(di.Description);
	//PRINTF("VideoCard = %s", di.Description); //Testp
	if ((strstr(di.Description, "radeon ve") != NULL) ||
		(strstr(di.Description, "radeon 2")  != NULL) ||
		(strstr(di.Description, "radeon 3")  != NULL) ||
		(strstr(di.Description, "radeon 7")  != NULL) ||
		(strstr(di.Description, "radeon 8")  != NULL) ||
		(strstr(di.Description, "radeon 90") != NULL) ||
		(strstr(di.Description, "radeon 92") != NULL) ||
		(strstr(di.Description, "wonder ve") != NULL) ||
		(strstr(di.Description, "wonder 7")  != NULL) ||
		(strstr(di.Description, "wonder 90") != NULL) ||
		(strstr(di.Description, "wonder 92") != NULL))
	{
		//PRINTF("Old! VideoCard = %s ", di.Description); //Testp
		_bOldVideoChip = TRUE; //ÂrfI`bv
	}
	if (strstr(di.Description, "intel(r) hd graphics") != NULL)
	{
		//PRINTF("Intel! VideoChip = %s ", di.Description); //Testp
		_bIntelVideoChip = TRUE; //CeIrisÕ[p[rfI`bvB
	}

	//Direct3DfoCX쐬Bj[_CAO\̂߁AtXN[EBhEfoCXƂč쐬B
	ZeroMemory(&_pD3DParam, sizeof(_pD3DParam));
	_pD3DParam.hDeviceWindow = _hWnd;
	_pD3DParam.BackBufferWidth = width;
	_pD3DParam.BackBufferHeight = height;
	_pD3DParam.BackBufferFormat = D3DFMT_X8R8G8B8; //32rbgJ[p
	_pD3DParam.BackBufferCount = 1;
	_pD3DParam.Windowed = TRUE; //Window[hBQlFWinodwedTRUÊƂɃtbV[gݒ肷CreateG[
	if ((APP_GetVSyncScreen()) &&
		((dmode.RefreshRate == 60) || (dmode.RefreshRate == 59) || (dmode.RefreshRate == 61) ||
			(dmode.RefreshRate == 120) || (dmode.RefreshRate == 119) || (dmode.RefreshRate == 121) ||
			(APP_GetWindowsAutoVSyncBool()))) //tbV[g60Hz(5961܂)120HzA܂WindowsV-Syncݒ̂ƂVSyncOKɁB
	{	//V-Syncꍇ
		_pD3DParam.SwapEffect = D3DSWAPEFFECT_DISCARD; //COPYy
		_pD3DParam.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;
		if (APP_GetWindowsAutoVSyncBool()) //v2.65ǉ
			_pD3DParam.PresentationInterval = D3DPRESENT_INTERVAL_DEFAULT; //D3DPRESENT_INTERVAL_DEFAULTBD3DPRESENT_INTERVAL_ONEƂقړi\xjy悤ŒxȂ߁BhCoŐItɂĎ蓮VSyncقxȂ̂ŌݔgpBv2.94
																		   //ÂRADEON@V-Syncm点^C~OAoEgȂ悤Ȃ̂640x480tɂ͂(Windows̎V-Sync)gȂBv2.65
		//D3DSWAPEFFECT_FLIPɂācD3DSWAPEFFECT_DISCARD(COPY)ɂĎ蓮VSyncA]Ȃ邽߂CPUւׂ͌̕y
		//							  ̃^C~OxƂď(mCYڂ)₷悤Ȃ̂ŁADISCARD+IMMEDIATEōsB
		//_pD3DParam.SwapEffect = D3DSWAPEFFECT_FLIP;
		//_pD3DParam.PresentationInterval = D3DPRESENT_INTERVAL_ONE;
	}
	else //V-SyncȂ(orłȂ)ꍇ
	{
		_pD3DParam.SwapEffect = D3DSWAPEFFECT_DISCARD; //COPYy
		_pD3DParam.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;
	}
	_pD3DParam.Flags = D3DPRESENTFLAG_LOCKABLE_BACKBUFFER;
	hr = d3dDevReset(); //쐬
	if (FAILED(hr))
	{
		MessageBox(_hWnd, "ERROR: DIRECT3D::CreateDevice() failed.    ", "Ootake", MB_OK);
		SCREEND3D_Deinit();
		return FALSE;
	}

	//K}i邳jvZς݂̃e[upӁB
	SCREEN_SetGamma(APP_GetScanlineType(), APP_GetScanlineDensity());

	_LastTimeSyncTime = APP_QPCtimeGetTime1000(); //OSyncƂ̃^C}[JEg
	_LastTimeSyncTime3 = _LastTimeSyncTime; //v2.43ǉ
	SCREEND3D_InitAudioGraph(); //I[fBIOt\p̃obt@NABv2.92

	//ʂNA
	SCREEND3D_Clear(0, 0, 0);

	return TRUE;
}


//I[fBIOt\p̃obt@NABv2.92ǉ
void
SCREEND3D_InitAudioGraph()
{
	int	i;

	for (i = 0; i < 6; i++)
	{
		_PSGChannelStatus[i] = 0;
		_PSGSampleL[i] = 0;
		_PSGSampleR[i] = 0;
	}
	_ADPCMSample = 0;
	_CDDASampleL = 0;
	_CDDASampleR = 0;
}


//XN[[hύX܂B 
BOOL
SCREEND3D_ChangeMode(
	Sint32		width,
	Sint32		height,
	Sint32		magnification,
	Uint32		flags)
{
	SCREEND3D_Deinit();
	return SCREEND3D_Init(width, height, magnification, flags);
}

//AԂ҂܂B(VSync)
BOOL
SCREEND3D_WaitVBlank(
	BOOL	bDraw) //bDrawTRUEɂČĂԂƕ`sBFALSȄꍇVSync҂̂݁B
{
	Sint64				t, vt;
	D3DRASTER_STATUS	rs;
	HRESULT				hr;
	RECT				rc;
	UINT				bt, bt2;
	UINT				cy, cy2;
	UINT				gh;
	Sint32				top;
	Sint32				h2;
	Sint32				vSyncHz = MAINBOARD_GetVSyncHz();

	if (APP_GetWindowsAutoVSyncBool()) //v2.65ǉBIWindows̎V-Syncg[hݒuB\xN̂Ŕ񐄏AʏV-Sync܂sȂPC̂߂ɎB
	{
		//WaitOɕ`揈ς܂B
		if (bDraw)
		{
			hr = _pD3DDev->Present(NULL, NULL, NULL, NULL); //Direct3D́ASwapEffectVSync҂̂ɐݒ肷ƁAPresentsɎVSync҂ĂBVSyncƏdƂ̂Ō͎蓮ő҂B
			UpdateWindow(_hWnd); //x΍Bv2.89
		}
		return TRUE;
	}

	//Vistaȍ~"Aero""VistaX^_[h(Home Basicɂ̂ݑ)"C"Win8/10"̃fXNgbvṕAWindowŝV-SyncōŝŁAԂĒxȂȂ悤OotakeV-Syncɍ\킸Aɕ`ς܂Bv2.02
	if (APP_DwmIsCompositionEnabled())
	{
		//WaitOɕ`揈ς܂B
		if (bDraw)
		{
			//`揈
			hr = _pD3DDev->Present(NULL, NULL, NULL, NULL); //Direct3D́ASwapEffectVSync҂̂ɐݒ肷ƁAPresentsɎVSync҂ĂBVSyncƏdƂ̂Ō͎蓮ő҂B
			if (hr == D3DERR_DEVICELOST)
			{
				d3dDevReset();
				_pD3DDev->Present(NULL, NULL, NULL, NULL);
			}
			UpdateWindow(_hWnd); //x΍Bv2.89
			if (APP_GetRemoveDisplayLagFrame() >= 1) //\O팸[hiftHgj̏ꍇBv2.89
			{
				hr = _pD3DDev->Present(NULL, NULL, NULL, NULL);
				UpdateWindow(_hWnd); //x΍Bv2.89
				if (APP_GetRemoveDisplayLagFrame() >= 3) //\O팸[h3FiftHgj̏ꍇ
				{	//Aero(&Win8/10)̏ꍇA_Oobt@2t[Ԃ񂠂̂ł
					hr = _pD3DDev->Present(NULL, NULL, NULL, NULL);
					UpdateWindow(_hWnd); //x΍Bv2.89
					hr = _pD3DDev->Present(NULL, NULL, NULL, NULL);
					UpdateWindow(_hWnd); //x΍Bv2.89
				}
			}
			bDraw = FALSE; //`揈
		}
	}

	if (_bVSyncScreen)
	{
		if (vSyncHz == 240) //v2.94ǉBv2.98XV
			vt = 4167;
		else if (vSyncHz == 120)
			vt = 8333;
		else
			vt = 16667;
		t = APP_QPCtimeGetTime1000() - _LastTimeSyncTime;
		if (t <= vt) //16.667ms(1/60s)ȏo߂Ăꍇ͑҂Ȃ
		{
			//̃Av̂߂ɏx݁BVBlank҂[vCPUL100%ɂȂ̂ŁAƏȓd́BSleepȂꍇAAWaitꍇɏȂƂ̂ŁAꂪKvB
			if (vt == 16667)
			{
				t = 16667 - t - 200; //-200͏Ȃ߂̃}[WB-2GTX1060̏ȓd͓(ftHg)ɏBȉ߂ƃe|̗h炬킸ɉUCB16=PR}̎Ԗ16msBv2.94
								//}CiXl傫CDDA^C~O莞(IntelAtom640x480fullscreenŊmF)SleepZĘAVSyncJbgĂ܂ƂB-12NG
				if ((t >= 1) && (t <= 1667)) //^C}[JE^̃I[o[t[lāA͈̔͂̂ƂSleepȂB
					APP_QPCSleep1000(t);
			}
			else if (vt == 8333)
			{
				t = 8333 - t - 400; //-400͏Ȃ߂̃}[WB8=PR}̎Ԗ8msBv2.94XV
				if ((t >= 1) && (t <= 8333))
					APP_QPCSleep1000(t);
			}
			else //(vt == 4167) for 240Hz
			{
				t = 4167 - t - 1600; //-800͏Ȃ߂̃}[WB4167=PR}̎Ԗ4.167msBv3.05
				if ((t >= 1) && (t <= 4167))
					APP_QPCSleep1000(t);
				//APP_QPCSleep1000(957); //956OKB955Ƃ܂B941-950-980OKB940NGB240Hz̏ꍇԂ̗]TȂ̋ꂪ̂ōŒ̃EFCg
			}
			//҂BGetRasterStatus\bhŐB
			//		EBhEŏĂ鎞͂ȂPresentɂVSyncȂ(ɂ邩ȂDirect3D9̎dlۂ)̂ŁA蓮VSyncsB
			cy = (UINT)GetSystemMetrics(SM_CYSCREEN);
			cy2 = cy - (cy / 6); //c1200̃fBXvC̏ꍇ-200C(1200/6)܂Ń`FbNB1C̔肾SyncƂ̂ŁA}[WԂB-300LightPSGɂQVSyncĂ܂B}CiXȂSyncƂe|◐Bv2.92XV
			if (_Flags & SCREEN_FFULLSCREEN)
			{	//tXN[̎0CVSyncB
				//ʏ㕔̌(̌)vZ
				if (APP_GetFullStretched(TRUE))
				{
					//AXyNg4:3ɕۂ
					if (_Width / 4 >= _Height / 3)
					{	//ĉقẐŏcƂ
						if (MAINBOARD_GetShowOverscanLeft() > 0) //ẼI[o[XL̈\Ȃ
							top = (_Height - (Sint32)((double)_Height * 0.96137 + 0.5)) / 2; //0.96137=224/((268-256)/4*3+224)
						else
							top = 0;
					}
					else
					{	//̂قẐŉƂ
						h2 = (Sint32)((double)(_Width / 4.0 * 3.0 + 0.5));
						if (MAINBOARD_GetShowOverscanLeft() > 0) //ẼI[o[XL̈\Ȃ
							top = (_Height - (Sint32)((double)h2 * 0.96137 + 0.5)) / 2; //0.96137=224/((268-256)/4*3+224)
						else
							top = (_Height - h2) / 2;
					}
				}
				else if (APP_GetStretched())
				{
					//AXyNgTVʂƓ4:3ɁBc̒PCEW224̐{(Q{)ɂ
					top = (_Height - 224 * _Magnification) / 2;
					if (MAINBOARD_GetShowOverscanTop() > 0) //㑤̃I[o[XL̈\Ȃ
					{
						top -= MAINBOARD_GetShowOverscanTop() * _Magnification;
						if (top < 0) //ʂ͂ݏoĂ܂ꍇB1440x900,1600x900Ȃǂł蓾B
							top = (_Height - 224 * _Magnification) / 2; //AXyNgۂ߁AI[o[XLJbgB
					}
				}
				else //mXgb`̏ꍇ
				{
					top = (_Height - 224 * _Magnification) / 2;
					if (MAINBOARD_GetShowOverscanTop() > 0) //㑤̃I[o[XL̈\Ȃ
					{
						top -= MAINBOARD_GetShowOverscanTop() * _Magnification;
						if (top < 0) top = 0; //ʂ͂ݏoĂ܂ꍇ́AXgb`(k)đΉB1440x900,1600x900Ȃǂł蓾B
					}
				}
				bt = cy - top;
			}
			else if (IsIconic(_hWnd))
			{	//EBhEŏĂ鎞͍ŉ256CVSyncB
				bt = cy2;
			}
			else
			{	//EBhE[h̏ꍇAEBhE\̈ŉCzSyncBȂƉʏ㕔łSyncԂɍȂBv2.54
				GetWindowRect(_hWnd, &rc);
				bt = (UINT)rc.bottom - GetSystemMetrics(SM_CYFRAME);//v2.92XV
			}
			bt2 = bt + (cy - cy2);
			GetClientRect(_hWnd, &rc);
			gh = rc.bottom - rc.top;//Q[\ʂ̏cBv2.92
			//PRINTF("Test bt=%d bt2=%d cy=%d cy2=%d gh=%d", bt, bt2, cy, cy2, gh);//Testp
			while (TRUE)
			{
				_pD3DDev->GetRasterStatus(0, &rs);
				if (bt <= cy2)
				{
					if ((rs.ScanLine >= cy2) || (rs.ScanLine == 0) || (rs.InVBlank)) //XLC̔قSync𓦂e|Bv2.54
						break; //VBlankԂɓ烋[v𔲂oB
				}
				else //EBhÊقɂꍇ,̓tXN[[h
				{
					if ((APP_GetVSyncAdjust() > 0) && (((cy - bt) + (bt - gh) < cy / 3))) //c̋󂢂(EBhE̖)ʑŜ1/3ĂꍇitXN[܂́AtHDfBXvCx5EBhEjA]VBlankԓɏIȂ\̂ŁA߂ɓ]Jn邱ƂŃeBAOhBv2.92Bv2.94
					{															//										ʑŜ1/4x4TCY̎ɂꂪӂ̃eBAOpɂɋNB
						if ((rs.InVBlank) || (rs.ScanLine == 0) || (rs.ScanLine >= bt - (cy / 20)) || (rs.ScanLine <= bt2 - cy)) //20B19ƉB(cy(Windowsʂ̏c)/20)̃C߂VBlankԂɂ\肾JnBv2.92XV
							break; //VBlankԂɓ̂Ń[v𔲂oB
					}
					else //ʏ
					{
						if ((rs.InVBlank) || (rs.ScanLine == 0) || (rs.ScanLine >= bt) || (rs.ScanLine <= bt2 - cy))
							//if ((rs.InVBlank)||(rs.ScanLine == 0)||(rs.ScanLine >= 1148-50))//testB-50OKB-45NG
							//if ((rs.InVBlank)||(rs.ScanLine == 0)||(rs.ScanLine >= 1148-50))//testB-65OKB-70NG
							break; //VBlankԂɓ̂Ń[v𔲂oB
					}
				}
				t = APP_QPCtimeGetTime1000() - _LastTimeSyncTime;
				if (vSyncHz == 240) //v2.98XV
				{
					if ((t > 4167) || (t < 0)) //4.167mso߂ĂBorJE^I[o[t[
						break;
				}
				else if (vSyncHz == 120)
				{
					if ((t > 8333) || (t < 0)) //8.333mso߂ĂBorJE^I[o[t[
						break;
				}
				else
				{
					if ((t > 16667) || (t < 0)) //16.67mso߂ĂBorJE^I[o[t[
						break;
				}
			}
		}
		_LastTimeSyncTime = APP_QPCtimeGetTime1000(); //OSyncI^CƂċL^Ă
		if (bDraw)
		{
			//`揈
			hr = _pD3DDev->Present(NULL, NULL, NULL, NULL); //Direct3D́ASwapEffectVSync҂̂ɐݒ肷ƁAPresentsɎVSync҂ĂBVSyncƏdƂ̂Ō͎蓮ő҂B
			if (hr == D3DERR_DEVICELOST)
			{
				d3dDevReset();
				_pD3DDev->Present(NULL, NULL, NULL, NULL);
			}
			UpdateWindow(_hWnd); //x΍Bv2.89
			//Ƀ_Oobt@邽߂ɁAʂx`揈BxBv2.88ǉ
			if (APP_GetRemoveDisplayLagFrame() >= 1) //\O팸[hiftHgj̏ꍇ
			{
				hr = _pD3DDev->Present(NULL, NULL, NULL, NULL); //\̂őOʂɂ邽߁AXɓeŃobt@XVB1t[x팸ʂ
				UpdateWindow(_hWnd); //x΍Bv2.89
				//if (APP_GetRemoveDisplayLagFrame() >= 3) //\O팸[h3FiftHgj̏ꍇBAero/8/10̏ꍇAɕ`揈Ă邽߂̓JbgBAerȍꍇ͍̏sȂ̂ŃJbgB
				//{
				//	hr = _pD3DDev->Present(NULL, NULL, NULL, NULL); //Aero/8/10̂
				//	UpdateWindow(_hWnd); //x΍Bv2.89
				//	hr = _pD3DDev->Present(NULL, NULL, NULL, NULL); //Aero/8/10̂
				//	UpdateWindow(_hWnd); //x΍Bv2.89
				//}
			}
		}
		return TRUE;
	}
	else //_bVSyncScreen  FALSȄꍇBv3.05Windows11̃ftHgɂiWin11̓eAOŗ}Ă̂ŁjB
	{
		t = APP_QPCtimeGetTime1000() - _LastTimeSyncTime;
		if (t <= 16723) //16.723ms(16.667x60.0/59.4s)ȏo߂Ăꍇ͑҂Ȃ
		{
			//҂
			t = 16723 - t; //16723=PR}̎ԁB60.0HzPCE@59.8HzƂȂ悤ɂBv3.05
			if ((t >= 1) && (t <= 16723)) //^C}[JE^̃I[o[t[lāA͈̔͂̂ƂSleepȂB
				APP_QPCSleep1000(t);
		}
		_LastTimeSyncTime = APP_QPCtimeGetTime1000(); //OSyncI^CƂċL^Ă

		if (bDraw)
		{
			//`揈
			hr = _pD3DDev->Present(NULL, NULL, NULL, NULL); //PresentĂVSync҂`悾ݒɂȂĂ̂ŁA҂ɕ`悳B
			if (hr == D3DERR_DEVICELOST)
			{
				d3dDevReset();
				_pD3DDev->Present(NULL, NULL, NULL, NULL);
			}
			UpdateWindow(_hWnd); //x΍Bv2.89
		}
		return TRUE;
	}
}


void*
SCREEND3D_GetBuffer()
{
	return (void*)_pScreenPixels;
}


const Sint32
SCREEND3D_GetBufferPitch()
{
	return _SurfacePitch / 2;
}


//C(Q[)ʗpItXN[bNāA(`)pAhXݒ肷Bv2.13XVB32bitPʂň悤ɂB
static BOOL
lock_offscreen_surface(
	LONG* pPitch,
	Uint32** ppPixels)
{
	D3DLOCKED_RECT	pLockedRect;
	HRESULT			hr;

	hr = _pD3DSGame->LockRect(&pLockedRect, NULL, 0);
	if (hr == D3D_OK)
	{
		*pPitch = pLockedRect.Pitch >> 2; //PC̃oCgB32bitPʂň߂4ŊĂBv2.13XV
		*ppPixels = (Uint32*)pLockedRect.pBits;
		return TRUE;
	}
	else
		return FALSE;
}


//ʑŜNA܂B
void
SCREEND3D_Clear(
	byte	r,
	byte	g,
	byte	b) //v2.73XVBCӂ̐FŃNAł悤ɂB
{
	HRESULT		hr;

	_pD3DDev->Clear(0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(r, g, b), 1.0, 0);
	hr = _pD3DDev->Present(NULL, NULL, NULL, NULL); //PresentsȂƔfȂB
	if (hr == D3DERR_DEVICELOST)
	{
		d3dDevReset();
		_pD3DDev->Present(NULL, NULL, NULL, NULL);
	}
}


//eLXgbZ[Wݒ肵܂B
void
SCREEND3D_SetMessageText(
	char* pText)
{
	_pMessageText = pText;
}


//Z^[eLXgbZ[Wݒ肵܂B
void
SCREEND3D_SetCenterText(
	char* pText)
{
	_pCenterText = pText;
}


//eLXgbZ[W̕\
static void
print_message()
{
	HDC			dc;
	HFONT		prevFont;
	HFONT		hFont;
	LOGFONT		logFont;
	RECT		rcSrc;
	RECT		rcDst;
	RECT		rc;
	int			a, fs;

	if (!APP_GetInit())
		return; //ŏ̏SĊĂȂꍇ́A\sȂBCD-ROMQ[W[ƂɃbZ[W̂Bv1.67

	//foCXReLXg擾
	if (_pD3DSText->GetDC(&dc) != D3D_OK)
		return;

	//tHgTCY
	switch (_Magnification)
	{
	case 1: fs = 12; break;
	case 2:	fs = 16; break;
	case 3: fs = 12; break; //v2.44XV
	default: //4,5
		fs = 17; break; //v2.44XV
	}
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	GetObject(hFont, sizeof(LOGFONT), &logFont);
	logFont.lfHeight = fs;
	logFont.lfWidth = 0;
	hFont = CreateFontIndirect(&logFont);
	prevFont = (HFONT)SelectObject(dc, hFont);
	//obt@ɕ`
	rc.left = 0;
	rc.right = 0;
	rc.top = 0;
	rc.bottom = fs;
	SetBkColor(dc, RGB(48, 96, 48));//Z
	SetTextColor(dc, RGB(255, 255, 255));//
	//SetTextColor(dc, RGB(216,255,216));//
	DrawText(dc, _pMessageText, lstrlen(_pMessageText), &rc,
		DT_CALCRECT | DT_SINGLELINE | DT_NOPREFIX); //\V~[VBrcɕ\Ƃ̃TCYB
	DrawText(dc, _pMessageText, lstrlen(_pMessageText), &rc, DT_SINGLELINE | DT_NOPREFIX); //\

	SelectObject(dc, prevFont);
	DeleteObject(hFont);
	_pD3DSText->ReleaseDC(dc);

	//]ʒuTCY̒
	rcSrc.left = 0;
	rcSrc.top = 0;
	rcSrc.right = rc.right;
	rcSrc.bottom = fs;
	//]ʒu̒\͈̔͂₷邽߂Ɋg傷B
	if ((APP_GetOverscanHideBlackLR()) && (MAINBOARD_GetShowOverscanLeft() == 0)) //ẼI[o[XL̈ɍтtȂ
		rcDst.left = _GameLeft; //т̂ŃMM܂ōɊ񂹂ĂhOKB
	else //ʏ
		rcDst.left = _GameLeft + 3;
	if ((APP_GetOverscanHideBlackTop()) && (MAINBOARD_GetShowOverscanTop() < 8)) //㑤̃I[o[XL̈ɍтtȂ
	{
		rcDst.top = _GameTop; //т̂ŃMM܂ŏɊ񂹂ĂhOKB
		a = (8 - MAINBOARD_GetShowOverscanTop()) * _Magnification;
		if (a < 4) //ѕ4hbgȂ
			rcDst.top += (4 - a);
	}
	else //ʏ
		rcDst.top = _GameTop + 4;
	if (_Magnification >= 3)
	{
		rcDst.right = rcDst.left + rcSrc.right * 2; //Q{g
		rcDst.bottom = rcDst.top + fs * 2; //cQ{g
	}
	else
	{
		rcDst.right = rcDst.left + rcSrc.right;
		rcDst.bottom = rcDst.top + fs;
	}
	if (rcDst.right > _GameRight) //bZ[WĂ͂ݏoĂ܂ꍇ
	{
		rcSrc.right = (LONG)((double)rcSrc.right / ((double)rcDst.right / (double)_GameRight)); //\[X
		rcDst.right = _GameRight;
	}
	//]
	_pD3DDev->StretchRect(_pD3DSText, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_NONE); //̓NbL邽NONEgB
}


//FPS̕\
static void
print_fps()
{
	HDC			dc;
	HFONT		prevFont;
	HFONT		hFont;
	LOGFONT		logFont;
	RECT		rcSrc;
	RECT		rcDst;
	RECT		rc;
	int			fs;
	char		text[3 + 1]; //ꉞR܂ŗp
	int			a;

	//foCXReLXg擾
	if (_pD3DSText->GetDC(&dc) != D3D_OK)
		return;

	//tHgTCY
	switch (_Magnification)
	{
	case 1: fs = 12; break;
	case 2:	fs = 16; break;
	case 3: fs = 12; break; //v2.44XV
	default: //4,5
		fs = 17; break; //v2.44XV
	}
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	GetObject(hFont, sizeof(LOGFONT), &logFont);
	logFont.lfHeight = fs;
	logFont.lfWidth = 0;
	hFont = CreateFontIndirect(&logFont);
	prevFont = (HFONT)SelectObject(dc, hFont);
	//obt@ɕ`
	rc.left = 0;
	rc.right = 0;
	rc.top = 0;
	rc.bottom = fs;
	SetBkColor(dc, RGB(48, 96, 48));
	SetTextColor(dc, RGB(255, 255, 255));
	a = MAINBOARD_GetDisplayedFrames();
	if (a > 999) a = 999;
	sprintf(text, "%d", a);
	DrawText(dc, text, lstrlen(text), &rc,
		DT_CALCRECT | DT_SINGLELINE | DT_NOPREFIX); //\V~[VBrcɕ\Ƃ̃TCYB
	DrawText(dc, text, lstrlen(text), &rc, DT_SINGLELINE | DT_NOPREFIX); //\

	SelectObject(dc, prevFont);
	DeleteObject(hFont);
	_pD3DSText->ReleaseDC(dc);

	//]ʒuTCY̒
	rcSrc.left = 0;
	rcSrc.top = 0;
	rcSrc.right = rc.right;
	rcSrc.bottom = fs;
	//]ʒu̒\͈̔͂₷邽߂Ɋg傷B
	if ((APP_GetOverscanHideBlackLR()) && (MAINBOARD_GetShowOverscanLeft() == 0)) //ẼI[o[XL̈ɍтtȂ
		rcDst.left = _GameLeft; //т̂ŃMM܂ōɊ񂹂ĂhOKB
	else //ʏ
		rcDst.left = _GameLeft + 3;
	if ((APP_GetOverscanHideBlackBottom()) && (MAINBOARD_GetShowOverscanBottom() < 8)) //̃I[o[XL̈ɍтtȂ
	{
		rcDst.bottom = _GameBottom; //т̂ŃMM܂ŉɊ񂹂ĂhOKB
		a = (8 - MAINBOARD_GetShowOverscanBottom()) * _Magnification;
		if (a < 3) //ѕ3hbgȂ
			rcDst.bottom -= (3 - a);
	}
	else //ʏ
		rcDst.bottom = _GameBottom - 3; //ɕ\
	if (_Magnification >= 3)
	{
		rcDst.right = rcDst.left + rcSrc.right * 2; //Q{g
		rcDst.top = rcDst.bottom - fs * 2; //cQ{g
	}
	else
	{
		rcDst.right = rcDst.left + rcSrc.right;
		rcDst.top = rcDst.bottom - fs;
	}
	//]
	_pD3DDev->StretchRect(_pD3DSText, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_NONE); //̓NbL邽NONEgB
}


//I[fBIOt̕\Bv2.92
static void
print_audio_graph()
{
	HDC			dc;
	RECT		rc;
	//RECT		rc2;
	RECT		rcSrc;
	RECT		rcDst;
	int			gw, gh, bw, cd;
	int			a, i;
	HBRUSH		hBr0, hBr1, hBr2, hBr3, hBr4, hBr5, hBr6;

	//foCXReLXg擾
	if (_pD3DSText->GetDC(&dc) != D3D_OK)
		return;

	//OtTCY
	switch (_Magnification)
	{
	case 1: gw = 36; gh = 29; break;
	case 2:	gw = 48; gh = 38; break;
	case 3: gw = 60; gh = 48; break;
	default: //4,5
		gw = 84; gh = 67; break;
	}
	if (APP_GetCDGame())
	{
		gw = gw + (gw / 3); //CDQ[̏ꍇ͉Q񕪁iADPCMCD-DAj̃Ot𑝂₷
		cd = 2;
	}
	else
		cd = 0;

	//]ʒuTCY̒
	rcSrc.left = 0;
	rcSrc.top = 0;
	rcSrc.right = gw + (7 + cd);//7=Oť5+[2
	rcSrc.bottom = gh;
	hBr0 = CreateSolidBrush(RGB(48, 96, 48));//Z΁Bwi
	hBr1 = CreateSolidBrush(RGB(216, 255, 216));//΁Bʏ̉
	hBr2 = CreateSolidBrush(RGB(255, 255, 56));//FBDDATvỎ
	hBr3 = CreateSolidBrush(RGB(255, 200, 200));//sNBmCỶ
	hBr4 = CreateSolidBrush(RGB(255, 148, 0));//IWFBLFOϒ@\𗘗p`l0̉B͂ɂ񂴂AbLiHuJ[hŁjƃtbVnC_[XŗpĂB
											  //            LFOBHtB[hłgĂ̂v2.92̂̋@\ŔI
	hBr5 = CreateSolidBrush(RGB(248, 248, 248));//ɋ߂DFBCD-ROM2ADPCM
	hBr6 = CreateSolidBrush(RGB(216, 208, 255));//FBCD-ROM2CD-DA
	//Otobt@ɕ`
	FillRect(dc, &rcSrc, hBr0);
	if (APP_GetAudioGraphDelay() == 0) //I[fBIOt̕\x点Ȃݒ̏ꍇAPSG̏Ԃ݂̏ԂɍXV
	{
		for (i = 0; i < 6; i++)
		{
			_PSGChannelStatus[i] = PSG_GetChannelStatus(i);
			_PSGSampleL[i] = PSG_GetSampleL(i);
			_PSGSampleR[i] = PSG_GetSampleR(i);
		}
		_ADPCMSample = ADPCM_GetSample();
		_CDDASampleL = CDROM_GetCDDASampleL();
		_CDDASampleR = CDROM_GetCDDASampleR();
	}
	bw = gw / (12 + cd * 2);
	rc.left = 1;
	rc.top = 0;
	rc.right = 1 + bw;
	rc.bottom = gh;
	for (i = 0; i < 6; i++)
	{
		rc.top = (LONG)(gh - abs(_PSGSampleL[i]) / (double)(9000.0 * (48.0 / (double)gh)));//rbN}[h̃^Cgʂ̉yiʑ傫jŐU؂Ȃ悤ɍ킹B
		if (rc.top < 0)	rc.top = 0;//OtMAXɐU؂Ăꍇ
		switch (_PSGChannelStatus[i])
		{
		case 1: FillRect(dc, &rc, hBr1); break;
		case 2:
			if ((_PSGSampleL[i] != PSG_GetSampleL(i)) || (_PSGSampleR[i] != PSG_GetSampleR(i))) //DDATvO[h̏ꍇAg`ɕωꍇ͖ƂB[hX^WA'91XgQŉFOtĉBv2.95
				FillRect(dc, &rc, hBr2);
			break;
		case 3: FillRect(dc, &rc, hBr3); break;
		case 4: FillRect(dc, &rc, hBr4); break;
		}
		//rc2.left = rc.left;
		//rc2.top = rc.top;
		//rc2.right = rc2.left + 1;
		//rc2.bottom = rc2.top + 1;
		//FillRect(dc, &rc2, hBr0);//Ot̍pۂ߂
		rc.left += bw;
		rc.right += bw;
		rc.top = (LONG)(gh - abs(_PSGSampleR[i]) / (double)(9000.0 * (48.0 / (double)gh)));//rbN}[h̃^Cgʂ̉yiʑ傫jŐU؂Ȃ悤ɍ킹B
		if (rc.top < 0)	rc.top = 0;
		switch (_PSGChannelStatus[i])
		{
		case 1: FillRect(dc, &rc, hBr1); break;
		case 2:
			if ((_PSGSampleL[i] != PSG_GetSampleL(i)) || (_PSGSampleR[i] != PSG_GetSampleR(i))) //DDATvO[h̏ꍇAg`ɕωꍇ͖ƂB[hX^WA'91XgQŉFOtĉBv2.95
				FillRect(dc, &rc, hBr2);
			break;
		case 3: FillRect(dc, &rc, hBr3); break;
		case 4: FillRect(dc, &rc, hBr4); break;
		}
		//rc2.left = rc.left + 5;
		//rc2.top = rc.top;
		//rc2.right = rc2.left + 1;
		//rc2.bottom = rc2.top + 1;
		//FillRect(dc, &rc2, hBr0);//Ot̉Epۂ߂
		rc.left += bw + 1;
		rc.right += bw + 1;
	}
	rc.top = (LONG)(gh - abs(_ADPCMSample) / (double)(200.0 * (48.0 / (double)gh)));
	if (rc.top < 0)	rc.top = 0;
	rc.right += bw;
	FillRect(dc, &rc, hBr5);
	rc.left += bw + bw + 1;
	rc.right += bw + 1;
	rc.top = (LONG)(gh - abs(_CDDASampleL) / (double)(200.0 * (48.0 / (double)gh)));
	if (rc.top < 0)	rc.top = 0;
	FillRect(dc, &rc, hBr6);
	rc.left += bw;
	rc.right += bw;
	rc.top = (LONG)(gh - abs(_CDDASampleR) / (double)(200.0 * (48.0 / (double)gh)));
	if (rc.top < 0)	rc.top = 0;
	FillRect(dc, &rc, hBr6);
	DeleteObject(hBr0);
	DeleteObject(hBr1);
	DeleteObject(hBr2);
	DeleteObject(hBr3);
	DeleteObject(hBr4);
	DeleteObject(hBr5);
	DeleteObject(hBr6);
	_pD3DSText->ReleaseDC(dc);

	//]ʒu̒
	switch (APP_GetAudioGraphPos())
	{
	case 1: //
		if ((APP_GetOverscanHideBlackLR()) && (MAINBOARD_GetShowOverscanLeft() == 0)) //ẼI[o[XL̈ɍтtȂ
			rcDst.left = _GameLeft; //т̂ŃMM܂ōɊ񂹂ĂhOKB
		else //ʏ
			rcDst.left = _GameLeft + 3;
		if ((APP_GetOverscanHideBlackBottom()) && (MAINBOARD_GetShowOverscanBottom() < 8)) //̃I[o[XL̈ɍтtȂ
		{
			rcDst.bottom = _GameBottom; //т̂ŃMM܂ŉɊ񂹂ĂhOKB
			a = (8 - MAINBOARD_GetShowOverscanBottom()) * _Magnification;
			if (a < 3) //ѕ3hbgȂ
				rcDst.bottom -= (3 - a);
		}
		else //ʏ
			rcDst.top = _GameTop + 3; //㑤ɕ\
		rcDst.right = rcDst.left + rcSrc.right;
		rcDst.bottom = rcDst.top + rcSrc.bottom;
		break;
	case 2: //E
		if ((APP_GetOverscanHideBlackLR()) && (MAINBOARD_GetShowOverscanLeft() == 0)) //ẼI[o[XL̈ɍтtȂ
			rcDst.right = _GameRight; //т̂ŃMM܂ŉEɊ񂹂ĂhOKB
		else //ʏ
			rcDst.right = _GameRight - 3;
		if ((APP_GetOverscanHideBlackBottom()) && (MAINBOARD_GetShowOverscanBottom() < 8)) //̃I[o[XL̈ɍтtȂ
		{
			rcDst.bottom = _GameBottom; //т̂ŃMM܂ŉɊ񂹂ĂhOKB
			a = (8 - MAINBOARD_GetShowOverscanBottom()) * _Magnification;
			if (a < 3) //ѕ3hbgȂ
				rcDst.bottom -= (3 - a);
		}
		else //ʏ
			rcDst.top = _GameTop + 3; //㑤ɕ\
		rcDst.left = rcDst.right - rcSrc.right;
		rcDst.bottom = rcDst.top + rcSrc.bottom;
		break;
	case 3: //
		if ((APP_GetOverscanHideBlackLR()) && (MAINBOARD_GetShowOverscanLeft() == 0)) //ẼI[o[XL̈ɍтtȂ
			rcDst.left = _GameLeft; //т̂ŃMM܂ōɊ񂹂ĂhOKB
		else //ʏ
			rcDst.left = _GameLeft + 3;
		if ((APP_GetOverscanHideBlackBottom()) && (MAINBOARD_GetShowOverscanBottom() < 8)) //̃I[o[XL̈ɍтtȂ
		{
			rcDst.bottom = _GameBottom; //т̂ŃMM܂ŉɊ񂹂ĂhOKB
			a = (8 - MAINBOARD_GetShowOverscanBottom()) * _Magnification;
			if (a < 3) //ѕ3hbgȂ
				rcDst.bottom -= (3 - a);
		}
		else //ʏ
			rcDst.bottom = _GameBottom - 3; //ɕ\
		rcDst.right = rcDst.left + rcSrc.right;
		rcDst.top = rcDst.bottom - rcSrc.bottom;
		break;
	case 4: //E
		if ((APP_GetOverscanHideBlackLR()) && (MAINBOARD_GetShowOverscanLeft() == 0)) //ẼI[o[XL̈ɍтtȂ
			rcDst.right = _GameRight; //т̂ŃMM܂ŉEɊ񂹂ĂhOKB
		else //ʏ
			rcDst.right = _GameRight - 3;
		if ((APP_GetOverscanHideBlackBottom()) && (MAINBOARD_GetShowOverscanBottom() < 8)) //̃I[o[XL̈ɍтtȂ
		{
			rcDst.bottom = _GameBottom; //т̂ŃMM܂ŉɊ񂹂ĂhOKB
			a = (8 - MAINBOARD_GetShowOverscanBottom()) * _Magnification;
			if (a < 3) //ѕ3hbgȂ
				rcDst.bottom -= (3 - a);
		}
		else //ʏ
			rcDst.bottom = _GameBottom - 3; //ɕ\
		rcDst.left = rcDst.right - rcSrc.right;
		rcDst.top = rcDst.bottom - rcSrc.bottom;
		break;
	}

	//]
	_pD3DDev->StretchRect(_pD3DSText, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_NONE); //Ot̓NbL邽NONEgB

	//ɕ\Ot̃f[^̏uԂɎ擾ĒuB܂f[^Pt[x点ĕ\Bۂ̔ƃOt\̃^C~O߂ÂB
	for (i = 0; i < 6; i++)
	{
		_PSGChannelStatus[i] = PSG_GetChannelStatus(i);
		_PSGSampleL[i] = PSG_GetSampleL(i);
		_PSGSampleR[i] = PSG_GetSampleR(i);
	}
	_ADPCMSample = ADPCM_GetSample();
	_CDDASampleL = CDROM_GetCDDASampleL();
	_CDDASampleR = CDROM_GetCDDASampleR();
}


//ʂ̒ɃbZ[W\Bv2.77ǉ
void
print_center_message()
{
	HDC			dc;
	HFONT		prevFont;
	HFONT		hFont;
	LOGFONT		logFont;
	RECT		rcSrc;
	RECT		rcDst;
	RECT		rc;
	int			fs;
	LONG		adjust;

	//foCXReLXg擾
	if (_pD3DSText->GetDC(&dc) != D3D_OK)
		return;

	//tHgTCY
	switch (_Magnification)
	{
	case 1: fs = 12; break;
	case 2:	fs = 16; break;
	case 3: fs = 12; break; //v2.44XV
	default: //4,5
		fs = 17; break; //v2.44XV
	}
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	GetObject(hFont, sizeof(LOGFONT), &logFont);
	logFont.lfHeight = fs;
	logFont.lfWidth = 0;
	hFont = CreateFontIndirect(&logFont);
	prevFont = (HFONT)SelectObject(dc, hFont);
	//obt@ɕ`
	rc.left = 0;
	rc.right = 0;
	rc.top = 0;
	rc.bottom = fs;
	SetBkColor(dc, RGB(48, 96, 48));
	SetTextColor(dc, RGB(255, 255, 255));
	DrawText(dc, _pCenterText, lstrlen(_pCenterText), &rc,
		DT_CALCRECT | DT_SINGLELINE | DT_NOPREFIX); //\V~[VBrcɕ\Ƃ̃TCYB
	DrawText(dc, _pCenterText, lstrlen(_pCenterText), &rc, DT_SINGLELINE | DT_NOPREFIX); //\

	SelectObject(dc, prevFont);
	DeleteObject(hFont);
	_pD3DSText->ReleaseDC(dc);

	//]ʒuTCY̒
	rcSrc.left = 0;
	rcSrc.top = 0;
	rcSrc.right = rc.right;
	rcSrc.bottom = fs;
	//]ʒu̒\͈̔͂₷邽߂Ɋg傷B
	rcDst.left = _GameLeft;
	rcDst.top = 0;
	if (_Magnification >= 3)
	{
		rcDst.right = rcDst.left + rcSrc.right * 2; //Q{g
		rcDst.bottom = fs * 2; //cQ{g
	}
	else
	{
		rcDst.right = rcDst.left + rcSrc.right;
		rcDst.bottom = fs;
	}
	//Z^O
	adjust = (_GameRight - _GameLeft) / 2 - (rcDst.right - rcDst.left) / 2;
	rcDst.left += adjust;
	rcDst.right += adjust;
	adjust = (_GameBottom - _GameTop) / 2 - (rcDst.bottom - rcDst.top) / 2;
	rcDst.top += adjust;
	rcDst.bottom += adjust;
	//]
	_pD3DDev->StretchRect(_pD3DSText, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_NONE); //̓NbL邽NONEgB
}


//`pobNT[tFX֓]鏈ȂǁB
static void
zoom_d3dTensou(
	Uint16* pTvW,	//]̉sNZB[0]`[255]16+224+16(Overscan)CԂBɂ͕\Jn(.I[o[XL\Ȃꍇ[16]ɂȂ)̃AhXB
	Sint32		h,	//]̏csNZBʏ224B㉺̃I[o[XLꍇ̂Ԃ񑝂₵ĂĂԁB
	Sint32		executeCode)
{
	RECT		rcSrc;
	RECT		rcDst;
	Sint32		a, b, c, d, s, i, w2, h2;
	BOOL		bRasterChange = FALSE; //X^ƂɈقȂ𑜓xݒ肳ĂꍇTRUE
	Uint16* pTvW2;
	Sint32		ot = 16 - MAINBOARD_GetShowOverscanTop(); //]̊JnYW
	Sint32		wMag; //̃\[X{
	Sint32		hMag; //c̃\[X{
	Sint32		scanlineType;
	Sint32		tvWidth = VDC_GetTvWidth(); //PCEʕ`抮_ł̉𑜓x[hBv2.98

	if (APP_GetOverscanTV()) //I[o[XLTV\[h̏ꍇBv2.95
	{
		h -= 4; //c̉4hbgJbg
		//㑤Jbgݒ̏ꍇA]W𒲐B
		ot += APP_GetOverscanTvShift();
		pTvW += APP_GetOverscanTvShift();
	}

	//]̉ 
	pTvW2 = pTvW;
	s = (*pTvW2);
	//PRINTF("TvW2 = %d",s);//test
	for (i = 0; i < h; i++)
	{
		if ((*pTvW2) != s)
		{
			bRasterChange = TRUE;
			if ((*pTvW) < s)
				s = (*pTvW); //s=ԏBtXgb`ɂ݂oȂ悤ɁB
		}
		pTvW2++;
	}

	//]̈ʒu 
	if (_Flags & SCREEN_FFULLSCREEN)
	{
		if (APP_GetFullStretched(TRUE))
		{
			//AXyNg4:3ɕۂ
			if (_Width / 4 >= _Height / 3)
			{	//ĉقẐŏcƂ
				w2 = (Sint32)((double)(_Height / 3.0 * 4.0 + 0.5));
				a = (_Width - w2) / 2;
				if ((MAINBOARD_GetShowOverscanLeft() > 0) && (tvWidth != 512) && (executeCode != 3)) //ẼI[o[XL̈\Ȃ
					b = (_Height - (Sint32)((double)_Height * 0.96137 + 0.5)) / 2; //0.96137=224/((274-262)/4*3+224)
				else
					b = 0;
				c = _Width - a;
				d = _Height - b;
			}
			else
			{	//̂قẐŉƂ
				h2 = (Sint32)((double)(_Width / 4.0 * 3.0 + 0.5));
				a = 0;
				if ((MAINBOARD_GetShowOverscanLeft() > 0) && (tvWidth != 512) && (executeCode != 3)) //ẼI[o[XL̈\Ȃ
					b = (_Height - (Sint32)((double)h2 * 0.96137 + 0.5)) / 2; //0.96137=224/((274-262)/4*3+224)
				else
					b = (_Height - h2) / 2;
				c = _Width;
				d = _Height - b;
			}
			//tXgb`͏㉺̃I[o[XL̈\łȂ߁A㉺̃I[o[XL̈JbgB
			h -= MAINBOARD_GetShowOverscanTop() + MAINBOARD_GetShowOverscanBottom();
			ot = 16;
			bRasterChange = FALSE; //tXgb`̓X^Ƃ̉𑜓xύXłȂB
		}
		else if (APP_GetStretched())
		{
			if (APP_GetOverscanTV()) //I[o[XLTV\[h̏ꍇBv2.95
				w2 = 292 * _Magnification; //v3.01
			else if ((MAINBOARD_GetShowOverscanLeft() > 0) && (executeCode != 3)) //ẼI[o[XL̈\Ȃ
				w2 = 320 * _Magnification;
			else
				w2 = 298 * _Magnification; //AXyNgŒ̂߉298(2{596)̕\͈́B
			if (APP_GetVStretched()) //cʃ[hȂ
				w2 = (Sint32)((double)w2 * TATEGAMEN + 0.5);
			//AXyNgTVʂƓ4:3ɁBc̒PCEW224̐{(Q{)ɂ
			a = (_Width - w2) / 2;
			b = (_Height - 224 * _Magnification) / 2;
			c = a + w2;
			d = b + 224 * _Magnification;
			if (APP_GetOverscanTV()) //I[o[XLTV\[h̏ꍇBv2.95
			{
				b += 2 * _Magnification;
				d -= 2 * _Magnification;
			}
			else
			{
				if (MAINBOARD_GetShowOverscanTop() > 0) //㑤̃I[o[XL̈\Ȃ
				{
					b -= MAINBOARD_GetShowOverscanTop() * _Magnification;
					if (b < 0) //ʂ͂ݏoĂ܂ꍇB1440x900,1600x900Ȃǂł蓾B
					{	//AXyNgۂ߁AI[o[XLJbgB
						b = (_Height - 224 * _Magnification) / 2;
						h -= MAINBOARD_GetShowOverscanTop();
						ot = 16;
					}
				}
				if (MAINBOARD_GetShowOverscanBottom() > 0) //̃I[o[XL̈\Ȃ
				{
					d += MAINBOARD_GetShowOverscanBottom() * _Magnification;
					if (d > _Height) //ʂ͂ݏoĂ܂ꍇB1440x900,1600x900Ȃǂł蓾B
					{	//AXyNgۂ߁AI[o[XLJbgB
						d = b + 224 * _Magnification;
						h -= MAINBOARD_GetShowOverscanBottom();
					}
				}
				if (MAINBOARD_GetShowOverscanLeft() > 0) //ẼI[o[XL̈\Ȃ
				{
					//PRINTF("Test = %d", tvWidth);//test
					if (tvWidth == 350) //350[h͍̎E3hbgԂ񍕑тtBv2.98
					{
						if (APP_GetVStretched()) //cʃ[hȂ
						{
							a += (Sint32)(2.55 * (double)_Magnification + 0.5); //2.55=(298/262)*(262/350)*(262/350)*4dotBv3.01XV
							c -= (Sint32)(2.55 * (double)_Magnification + 0.5);
						}
						else //ʏ
						{
							a += (Sint32)(3.4057 * (double)_Magnification + 0.5); //3.4057=298/350*4dotBv3.01XV
							c -= (Sint32)(3.4057 * (double)_Magnification + 0.5);
						}
					}
					else if (tvWidth == 262) //262[h͍̎E5hbgԂ񍕑тtBv2.98
					{
						if (APP_GetVStretched()) //cʃ[hȂ
						{
							a += (Sint32)(3.4057 * (double)_Magnification + 0.5); //3.4057=(298/262)*(262/350)*4dotBv3.01XV
							c -= (Sint32)(3.4057 * (double)_Magnification + 0.5);
						}
						else //ʏ
						{
							a += (Sint32)(4.5496 * (double)_Magnification + 0.5); //4.5496=298/262*4dotBv3.01XV
							c -= (Sint32)(4.5496 * (double)_Magnification + 0.5);
						}
					}
				}
			}
		}
		else //Xgb`Ȃꍇ
		{
			if (APP_GetOverscanTV()) //I[o[XLTV\[h̏ꍇAE̍тJbgBv2.95
			{
				switch (tvWidth)
				{
				case 262: w2 = (tvWidth - 3 * 2) * _Magnification; break; //̂ƂEѕ̃\[X3hbgx{B
				case 350: w2 = (tvWidth - 4 * 2) * _Magnification; break; //̂ƂEѕ̃\[X4.01(3x(350/262))hbgx{B
				default: //512
					w2 = tvWidth * _Magnification; break;//̂ƂEѕ̃\[X͂ȂB
				}
			}
			else
				w2 = tvWidth * _Magnification;
			if (w2 > _Width) w2 = _Width; //ʂ͂ݏoĂ܂ꍇ́AXgb`(k)đΉB
			a = (_Width - w2) / 2;
			b = (_Height - 224 * _Magnification) / 2;
			c = a + w2;
			d = b + 224 * _Magnification;
			if (APP_GetOverscanTV()) //I[o[XLTV\[h̏ꍇA㉺4hbgԂ]̈߂Bv2.95
			{
				b += 2 * _Magnification;
				d -= 2 * _Magnification;
			}
			else
			{
				if (MAINBOARD_GetShowOverscanTop() > 0) //㑤̃I[o[XL̈\Ȃ
				{
					b -= MAINBOARD_GetShowOverscanTop() * _Magnification;
					if (b < 0) b = 0; //ʂ͂ݏoĂ܂ꍇ́AXgb`(k)đΉB1440x900,1600x900Ȃǂł蓾B
				}
				if (MAINBOARD_GetShowOverscanBottom() > 0) //̃I[o[XL̈\Ȃ
				{
					d += MAINBOARD_GetShowOverscanBottom() * _Magnification;
					if (d > _Height) d = _Height; //ʂ͂ݏoĂ܂ꍇ́AXgb`(k)đΉB1440x900,1600x900Ȃǂł蓾B
				}
			}
		}
	}
	else //EBhE[ĥƂ
	{
		//Direct3DStretchRectłWindoẅʒug̑ԂȂǂKvȂB(0,0)`̍ɂȂB
		a = 0;
		b = 0;
		if (APP_GetOverscanHideBlackTop()) //㑤̃I[o[XL̈ɍтĉBݒȂ
			b += (8 - MAINBOARD_GetShowOverscanTop()) * _Magnification;
		c = APP_GetGameWidth(_Magnification);
		d = b + APP_GetGameHeight(_Magnification);
		if (APP_GetOverscanTV()) //I[o[XLTV[h
		{
			if (APP_GetOverscanHideBlackTop()) //v2.98ǉ
			{
				b += 2 * _Magnification;
				d += 2 * _Magnification;
			}
			if (APP_GetOverscanHideBlackLR()) //v2.98ǉ
			{
				if (APP_GetVStretched()) //cʃ[hȂ
				{
					a += (Sint32)(7.6629 * (double)_Magnification + 0.5); // 7.6629=(298/262)*(262/350)*9dot
					c += (Sint32)(12.7714 * (double)_Magnification + 0.5); //12.7714=(298/262)*(262/350)*15dot
				}
				else if (APP_GetStretched())
				{
					a += (Sint32)(10.2366 * (double)_Magnification + 0.5); //10.2366=298/262*9dot
					c += (Sint32)(17.0611 * (double)_Magnification + 0.5); //17.0611=298/262*15dot
				}
			}
		}
		else //ʏ
		{
			if (((MAINBOARD_GetShowOverscanLeft() > 0) && (tvWidth == 512)) || //𑜓x512͉̎I[o[XL\Ȃ
				((MAINBOARD_GetShowOverscanLeft() == 0) && (APP_GetOverscanHideBlackLR())) ||
				(executeCode == 3))
			{	//Eɍтzu
				if (APP_GetVStretched()) //cʃ[hȂ
				{
					a += (Sint32)(5.1086 * (double)_Magnification + 0.5); //5.1086=(298/262)*(262/350)*6dotBv3.01XV
					c -= (Sint32)(5.1086 * (double)_Magnification + 0.5);
				}
				else if (APP_GetStretched())
				{
					a += (Sint32)(6.8244 * (double)_Magnification + 0.5); //6.8244=298/262*6dot
					c -= (Sint32)(6.8244 * (double)_Magnification + 0.5);
				}
			}
			if ((tvWidth == 512) && (APP_GetStretched())) //𑜓x512͍̎E6hbgԂ񍕑тtBI[o[XLTV[h͍ѕtȂBv2.98
			{
				a += (Sint32)(3.4122 * (double)_Magnification + 0.5); //3.4122=298/524*6dot
				c -= (Sint32)(3.4122 * (double)_Magnification + 0.5);
			}
			if (APP_GetOverscanHideBlackTop()) //㑤̃I[o[XL̈ɍтtȂ
				d -= (8 - MAINBOARD_GetShowOverscanTop()) * _Magnification; //]̏c͈͂ѕJbg
			if (APP_GetOverscanHideBlackBottom()) //̃I[o[XL̈ɍтtȂ
				d -= (8 - MAINBOARD_GetShowOverscanBottom()) * _Magnification; //]̏c͈͂ѕJbg
		}
	}
	//A[P[h̈ڐAQ[̎ۂɓXɏoĂsNZAXyNgɋ߂L\ŗVԁBv3.05
	if (APP_GetArcadeStretched() == 1)
	{
		a += (Sint32)(14.0 * (double)_Magnification); //𑜓x1.03{(256)ɏk߂i1.143{(256)ꂽ̂獶E14hbgԂ񂾂kj
		c -= (Sint32)(14.0 * (double)_Magnification); //
	}
	if (APP_GetArcadeStretched() == 2)
	{
		a += (Sint32)(10.0 * (double)_Magnification); //𑜓x1.06{(256)ɏk߂i1.143{(256)ꂽ̂獶E10hbgԂ񂾂kj
		c -= (Sint32)(10.0 * (double)_Magnification); //
	}
	if (APP_GetArcadeStretched() == 3)
	{
		a += (Sint32)(6.0 * (double)_Magnification); //𑜓x1.09{(256)ɏk߂i1.143{(256)ꂽ̂獶E6hbgԂ񂾂kj
		c -= (Sint32)(6.0 * (double)_Magnification); //
	}

	//PRINTF("%d, %d, %d, %d, w=%d, h=%d", a, b, c, d, APP_GetGameWidth(_Magnification), APP_GetGameHeight(_Magnification));//test
	_GameLeft   = a; //print_message()ŕ\ʒû߂ɁAQ[ʓ]̍WTĂB
	_GameRight  = c; //
	_GameTop    = b; //
	_GameBottom = d; //

	if (IsIconic(_hWnd)) //EBhEŏĂ鎞BhesŏĒƂȂǂɏyB
		if (executeCode != 2) //XN[Vbgp֓]ȊȌꍇ
		{
			//AԂ҂
			SCREEN_WaitVBlank(FALSE); //`揈͍sȂ
			return;
		}

	//`𑜓x̕ύXꍇAS~cȂ悤ɉʑŜNAB
	if ((MAINBOARD_GetUpdateFullScreen()) && (MAINBOARD_GetResolutionChange()))//tXN[
		_pD3DDev->Clear(0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0, 0, 0), 1.0, 0);
	else if ((APP_GetArcadeStretched() > 0) || (tvWidth == 512)) //v3.05ǉBArcadeXgb`[h512A`𑜓x̕ύXꍇiXN[VbgȂǁjAS~cȂ悤ɉʑŜNAB
			if ((MAINBOARD_GetResolutionChange()) || (executeCode == 2))
				_pD3DDev->Clear(0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0, 0, 0), 1.0, 0);

	//\[X͈͂肵AfoCX̃obNT[tFX(DirectDrawł̃vC}T[tFXƓl)֓]B
	if (_Magnification >= 2) //x2ȏ̏ꍇ
	{
		scanlineType = APP_GetScanlineType();
		if (((scanlineType >= 1) && (scanlineType <= 6)) || (scanlineType == 11)) //XLC(c܂)
		{
			if ((scanlineType == 3) || (scanlineType == 4) || (scanlineType == 11))
				wMag = 1;
			else
				wMag = 2; //x2ȏ͂Q{hbgŒBixAbv{g傳ꂽƂɃoCjAtB^ɂj
			if (scanlineType == 11) //XLCڂ₯TV[h
				hMag = 2;
			else
				hMag = _Magnification; //c͔{Ԃ̃\[Xpӂē]B
		}
		else //mXLC
		{
			if (scanlineType == 9) //mXLTV[h
			{
				wMag = 1;
				if (_Magnification <= 3)
					hMag = 1; //ڂ₯邽߃\[XP{ŁBv2.92
				else
					hMag = _Magnification - 2; //4x,5x̂Ƃ́Aꂼ2x,3xɊgBKxȂڂ₯Bv2.92
			}
			else if (scanlineType == 10) //mXLڂ₯TV[h
			{
				wMag = 1;
				hMag = 1; //ڂ₯邽߃\[XP{ŁBv2.92
			}
			else //mXLTV[hȊO
			{
				wMag = 2;
				if (_Magnification == 2)
					hMag = _Magnification; //c͔{Ԃ̃\[Xpӂē]B
				else
					hMag = _Magnification - 1; //3x,4x,5x̂Ƃ́Aꂼ2x,3x,4xɊgBiWM[yxAbvj
			}
		}
	}
	else //x1̏ꍇ
		wMag = hMag = 1;

	if (!bRasterChange)
	{	//ʏ
		if (MAINBOARD_GetFourSplitScreen()) //dL,[hR[g,͂ɂ񂴂,p[htg,TCR`FCT[̂Sʂ̏ꍇBv2.27XV
		{
			SetRect(&rcSrc, s / 4 * wMag, ot * hMag, (s / 4 + s / 2) * wMag, (ot + h) * hMag); //\[X̍EѕJbg
			//ŜPɏkĂS]
			c = a + (c - a) / 2;
			d = b + (d - b) / 2;
			w2 = c - a;
			h2 = d - b;
			for (i = 1; i <= 4; i++)
			{
				SetRect(&rcDst, a, b, c, d);
				switch (APP_GetD3DEffect())
				{
				case 1:
					if ((APP_GetHalfMode()) && ((_Magnification == 2) || (_Magnification == 4)))
						_pD3DDev->StretchRect(_pD3DSGame, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_LINEAR); //Half[hx2,x4POINT1/4k̉eŉʂÂȂ̂LINEARɂB
					else
						_pD3DDev->StretchRect(_pD3DSGame, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_POINT); //ԃhbgNbL
					break;
				case 2: _pD3DDev->StretchRect(_pD3DSGame, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_LINEAR); //傤ǂz
					break;
				default: //0
					_pD3DDev->StretchRect(_pD3DSGame, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_NONE); //ȂhbgNbL
					break;
				}
				switch (i)
				{
					case 1:	a += w2; c += w2; break; //͉E
					case 2:	b += h2; d += h2; break; //͉E
					case 3:	a -= w2; c -= w2; break; //͍
				}
			}
		}
		else //ʏ
		{
			SetRect(&rcDst, a, b, c, d);
			if ((!APP_GetStretched()) && ((_Flags & SCREEN_FFULLSCREEN) == 0)) //EBhE[hŃXgb`ȂꍇBv2.14XV
			{
				w2 = c / _Magnification;
				//PRINTF("%d, %d", s,w2);//test
				w2 = (s - w2) / 2;
				SetRect(&rcSrc, w2 * wMag, ot * hMag, (s - w2) * wMag, (ot + h) * hMag); //]]Ɠhbgɍ킹B
			}
			else if (APP_GetOverscanTV()) //I[o[XLTV\[h̏ꍇBv2.95
			{
				switch (tvWidth)
				{
					case 262: SetRect(&rcSrc, 3 * wMag, ot * hMag, (s - 3) * wMag, (ot + h) * hMag); break;//̂ƂEѕ̃\[X3hbgx{B
					case 350: SetRect(&rcSrc, 4 * wMag, ot * hMag, (s - 4) * wMag, (ot + h) * hMag); break; //̂ƂEѕ̃\[X4.01hbgx{B
					default: //512
						SetRect(&rcSrc, 0, ot * hMag, s * wMag, (ot + h) * hMag); break;//̂ƂEѕ̃\[X͂ȂB
				}
			}
			else if (executeCode == 5) //I[o[XL̈̍EJbgꍇ
				SetRect(&rcSrc, 6 * wMag, ot * hMag, (s - 6) * wMag, (ot + h) * hMag); //̂ƂEѕ̃\[X6hbgx{B
			else //ʏ
			{
				if (MAINBOARD_GetShowOverscanLeft() > 0) //ẼI[o[XL̈\Ȃ
				{
					if (tvWidth == 350) //350\̏ꍇBv2.98XV
						SetRect(&rcSrc, 4, ot * hMag, s * wMag, (ot + h) * hMag); //\[X(352Ԃ񂠂)̎QƊJnE4hbgVtgđŜZ^OB
					else
						SetRect(&rcSrc, 0, ot * hMag, s * wMag, (ot + h) * hMag);
				}
				else
				{
					if (tvWidth == 350) //350\̏ꍇBv2.98XV
						SetRect(&rcSrc, 1 * wMag, ot * hMag, s * wMag, (ot + h) * hMag); //\[X(352Ԃ񂠂)̎QƊJnE1hbgVtg
					else //ʏ
						SetRect(&rcSrc, 0, ot * hMag, s * wMag, (ot + h) * hMag);
				}
			}

			if (APP_GetArcadeStretched() == 4) //v3.05ǉ
			{
				//\[X̍E[JbgĂ̂Ԃ񉡉𑜓x󂩂牡352hbg[h1.04{A256[h1.06{Ɋg傷
				SetRect(&rcSrc, rcSrc.left+7*wMag, rcSrc.top, rcSrc.right-7*wMag, rcSrc.bottom); //7B7ŉ256[h1.06{B14ŉ256[h1.12{(hbgoChbg1.29{)
			}

			switch (APP_GetD3DEffect())
			{
				case 1: _pD3DDev->StretchRect(_pD3DSGame, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_POINT); //ԃhbgNbL
					break;
				case 2: _pD3DDev->StretchRect(_pD3DSGame, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_LINEAR); //傤ǂz
					break;
				default: //0
					_pD3DDev->StretchRect(_pD3DSGame, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_NONE); //ȂhbgNbL
					break;
			}
		}
	}
	else
	{	//X^ƂɈقȂ𑜓xݒ肳ĂƂBv1.28XVBPC]悤ɂBv2.00XVBDirect3DȂVistałB
		for (i = 0; i < h; i++)
		{
			if (((*pTvW) == 512) && (MAINBOARD_GetShowOverscanLeft() > 0)) //512̂Ƃ̓I[o[XL\Ȃ
			{	//Eɍтzu
				if (APP_GetVStretched()) //cʃ[hȂ
					SetRect(&rcDst, a + (int)(5.126 * (double)_Magnification + 0.5), b + i * _Magnification,
						c - (int)(5.126 * (double)_Magnification + 0.5) - 1, b + i * _Magnification + _Magnification);
				else if (APP_GetStretched())
					SetRect(&rcDst, a + (int)(6.847 * (double)_Magnification + 0.5), b + i * _Magnification,
						c - (int)(6.847 * (double)_Magnification + 0.5) - 1, b + i * _Magnification + _Magnification);
				else
					SetRect(&rcDst, a, b + i * _Magnification, c, b + i * _Magnification + _Magnification);
			}
			else //ʏ
				SetRect(&rcDst, a, b + i * _Magnification, c, b + i * _Magnification + _Magnification);
			if (APP_GetOverscanTV()) //I[o[XLTV\[h̏ꍇBv2.95
			{
				switch ((*pTvW))
				{
				case 262: SetRect(&rcSrc, 3 * wMag, (ot + i) * hMag, ((*pTvW) - 3) * wMag, (ot + i) * hMag + hMag); break; //̂ƂEѕ̃\[X3hbgx{B
				case 350: SetRect(&rcSrc, 4 * wMag, (ot + i) * hMag, ((*pTvW) - 4) * wMag, (ot + i) * hMag + hMag); break; //̂ƂEѕ̃\[X4.01hbgx{B
				case 512: SetRect(&rcSrc, 0, (ot + i) * hMag, (*pTvW) * wMag, (ot + i) * hMag + hMag); break;//̂ƂEѕ̃\[X͂ȂB
				}
			}
			else if (executeCode == 5) //I[o[XL̈̍EJbgꍇ
				SetRect(&rcSrc, 6 * wMag, (ot + i) * hMag, ((*pTvW) - 6) * wMag, (ot + i) * hMag + hMag);
			else //ʏ
			{
				if ((*pTvW) == 350) //350\̏ꍇBv2.98XV
					SetRect(&rcSrc, 1 * wMag, (ot + i) * hMag, 350 * wMag, (ot + i) * hMag + hMag);
				else
					SetRect(&rcSrc, 0, (ot + i) * hMag, (*pTvW) * wMag, (ot + i) * hMag + hMag);
			}
			if (APP_GetArcadeStretched() == 4) //v3.05ǉ
			{
				//\[X̍E[JbgĂ̂Ԃ񉡉𑜓x󂩂牡352hbg[h1.04{A256[h1.06{Ɋg傷
				SetRect(&rcSrc, rcSrc.left+7*wMag, rcSrc.top, rcSrc.right-7*wMag, rcSrc.bottom); //7B7ŉ256[h1.06{B14ŉ256[h1.12{(hbgoChbg1.29{)
			}
			switch (APP_GetD3DEffect())
			{
			case 1: _pD3DDev->StretchRect(_pD3DSGame, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_POINT); //ԃhbgNbL
				break;
			case 2: _pD3DDev->StretchRect(_pD3DSGame, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_LINEAR); //傤ǂz
				break;
			default: //0
				_pD3DDev->StretchRect(_pD3DSGame, &rcSrc, _pD3DSBack, &rcDst, D3DTEXF_NONE); //ȂhbgNbL
				break;
			}
			pTvW++;
		}
	}

	if (executeCode == 2) return;//XN[Vbgp֓]̏ꍇŏI

	if (executeCode != 6) //g莞̏ꍇAI[fBIOtFPSAeLXg̕\͍sȂBv2.92
	{
		//I[fBIOt̕\Bv2.92ǉBFPSeLXgbZ[W̕\D悷邽߁Adˍ킹ɂ͉B悤I[fBIOt͈ԍŏɕ\sB
		if (APP_GetShowAudioGraph())
			print_audio_graph();

		//FPS̕\Bv1.50ǉ
		if (APP_GetShowFPS())
			print_fps();

		//eLXgbZ[W̕\BDirect3D9StretchRect̓v[T[tFXm̓{]oȂ̂ŁA
		//							DirectDraŵƂƈႢAeLXgbZ[WobNobt@[֒ړ]悤ɂB
		if (*_pMessageText != 0) //bZ[Wݒ肳Ă
			print_message();
	}

	//Z^[eLXgbZ[W̕\Bv2.77ǉ
	if (*_pCenterText != 0)
		print_center_message();

	//AԂ҂ۂ̕`揈
	SCREEN_WaitVBlank(TRUE);
}


//`BݏB
//zoom3x()Czoom2x()Czoom1x()pӁBxd̂߂ꂼʃ[`ɁBCƂɉ𑜓xςĂQ[ɑΉB
//32rbgJ[xT{p
static void
zoom5x_dd32(
	Uint32*	pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16*	pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32*	pSrc0;
	Uint32*	pDst;
	Uint32*	pDst0;
	Uint32	d;
	Uint32	a;

	// XLC80%
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch5;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
		{
			d = *pSrc++; //ʏ"& 0xFFFFFF"Ń}XNׂ̂ߏȗBd0xFFFFFF𒴂ĂƂĂAł͔z񂩂͓ǂݏô݂Ȃ̂ŕsɂ͂ȂȂB
			*pDst++ = _GammaTBL[d]; //PhbgԂ񏑂܂B
			*pDst++ = _GammaTBLs90[d]; //PhbgԂ񏑂܂BQ{g(90%cXLC)
		}
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Qڂ90XLCŁBv2.34XVB̓Of[VtɕRɂقaȂB
		{
			a = _GammaTBLs90[*pSrc++];
			*pDst++ = a; //4byteԂ(Phbg)܂Bv2.98XV
			*pDst++ = a; //4byteԂ(Phbg)܂BQ{g(90%cXLC)
		}
		*pDst = 0;
		pDst = pDst0 + _Pitch2;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Rڂ90%XLCŁBv2.34XVB̓Of[VtɕRɂقaȂB
		{
			a = _GammaTBLs90[*pSrc++];
			*pDst++ = a; //v2.98XV
			*pDst++ = a; //Q{g(90%cXLC)
		}
		*pDst = 0;
		pDst = pDst0 + _Pitch3;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Sڂ90%XLCŁB̓Of[VtɕRɂقaȂB
		{
			a = _GammaTBLs90[*pSrc++];
			*pDst++ = a; //v2.98XV
			*pDst++ = a; //Q{g(90%cXLC)
		}
		*pDst = 0;
		pDst = pDst0 + _Pitch4;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
		{
			a = _GammaTBLs80[*pSrc++];
			*pDst++ = a; //v2.98XV
			*pDst++ = a; //Q{g(80%cXLC)
		}
		*pDst = 0;
		pDst0 += _Pitch5;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//32rbgJ[xS{p
static void
zoom4x_dd32(
	Uint32*	pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16*	pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32*	pSrc0;
	Uint32*	pDst;
	Uint32*	pDst0;
	Uint32	d;
	Uint32	a;

	// XLC80%
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch4;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
		{
			d = *pSrc++;
			*pDst++ = _GammaTBL[d]; //PhbgԂ񏑂܂B
			*pDst++ = _GammaTBLs90[d]; //PhbgԂ񏑂܂BQ{g(90%cXLC)
		}
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Qڂ90XLCŁBv2.34XVB̓Of[VtɕRɂقaȂB
		{
			a = _GammaTBLs90[*pSrc++];
			*pDst++ = a; //4byteԂ(Phbg)܂Bv2.98XV
			*pDst++ = a; //4byteԂ(Phbg)܂BQ{g(90%cXLC)
		}
		*pDst = 0;
		pDst = pDst0 + _Pitch2;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Rڂ90%XLCŁBv2.34XVB̓Of[VtɕRɂقaȂB
		{
			a = _GammaTBLs90[*pSrc++];
			*pDst++ = a; //v2.98XV
			*pDst++ = a; //Q{g(90%cXLC)
		}
		*pDst = 0;
		pDst = pDst0 + _Pitch3;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
		{
			a = _GammaTBLs80[*pSrc++];
			*pDst++ = a; //v2.98XV
			*pDst++ = a; //Q{g(80%cXLC)
		}
		*pDst = 0;
		pDst0 += _Pitch4;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//32rbgJ[xR{p
static void
zoom3x_dd32(
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32*	pSrc0;
	Uint32*	pDst;	//v2.13XVB32bitPʂɂčB
	Uint32*	pDst0;
	Uint32	d;
	Uint32	a;

	// XLC80%
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch3;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
		{
			d = *pSrc++;
			*pDst++ = _GammaTBL[d]; //4byteԂ(Phbg)܂B
			*pDst++ = _GammaTBLs90[d]; //4byteԂ(Phbg)܂BQ{g(90%cXLC)
		}
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Qڂ90%XLCɂB
		{
			a = _GammaTBLs90[*pSrc++];
			*pDst++ = a; //4byteԂ(Phbg)܂Bv2.98XV
			*pDst++ = a; //4byteԂ(Phbg)܂BQ{g(90%cXLC)
		}
		*pDst = 0;
		pDst = pDst0 + _Pitch2;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
		{
			a = _GammaTBLs80[*pSrc++];
			*pDst++ = a; //4byteԂ(Phbg)܂Bv2.98XV
			*pDst++ = a; //4byteԂ(Phbg)܂BQ{g(80%cXLC)
		}
		*pDst = 0;
		pDst0 += _Pitch3;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//32rbgJ[xQ{pB
static void
zoom2x_dd32(
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;
	Uint32	d;
	Uint32	a;

	// XLC80%
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch2;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
		{
			d = *pSrc++;
			*pDst++ = _GammaTBL[d];
			*pDst++ = _GammaTBLs90[d]; //Q{g(90%cXLC)
		}
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
		{
			a = _GammaTBLs80[*pSrc++];
			*pDst++ = a; //4byteԂ(Phbg)܂Bv2.98XV
			*pDst++ = a; //4byteԂ(Phbg)܂BQ{g(80%cXLC)
		}
		*pDst = 0;
		pDst0 += _Pitch2;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//XLC32rbgJ[xT{p
static void
zoom5xHS_dd32(
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;
	Uint32	a;

	// XLC80%
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch5;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
		{
			a = _GammaTBL[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Qڂ90%XLCŁB̓Of[VtɕRɂقaȂB
		{
			a = _GammaTBLs90[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0;
		pDst = pDst0 + _Pitch2;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Rڂ90%XLCŁB̓Of[VtɕRɂقaȂB
		{
			a = _GammaTBLs90[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0;
		pDst = pDst0 + _Pitch3;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Sڂ90%XLCŁB̓Of[VtɕRɂقaȂB
		{
			a = _GammaTBLs90[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0;
		pDst = pDst0 + _Pitch4;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
		{
			a = _GammaTBLs80[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0;
		pDst0 += _Pitch5;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//XLC32rbgJ[xS{p
static void
zoom4xHS_dd32(
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;
	Uint32	a;

	// XLC80%
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch4;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
		{
			a = _GammaTBL[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Qڂ90%XLCŁBv2.35XVB̓Of[VtɕRɂقaȂB
		{
			a = _GammaTBLs90[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0;
		pDst = pDst0 + _Pitch2;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Rڂ90%XLCŁBv2.35XVB̓Of[VtɕRɂقaȂB
		{
			a = _GammaTBLs90[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0;
		pDst = pDst0 + _Pitch3;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
		{
			a = _GammaTBLs80[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0;
		pDst0 += _Pitch4;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//XLC32rbgJ[xR{p
static void
zoom3xHS_dd32(
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;
	Uint32	a;

	// XLC80%
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch3;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
		{
			a = _GammaTBL[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Qڂ90%XLCɂB
		{
			a = _GammaTBLs90[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0;
		pDst = pDst0 + _Pitch2;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
		{
			a = _GammaTBLs80[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0;
		pDst0 += _Pitch3;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//XLC32rbgJ[xQ{pB
static void
zoom2xHS_dd32(
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;
	Uint32	a;

	// XLC80%
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch2;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
		{
			a = _GammaTBL[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
		{
			a = _GammaTBLs80[*pSrc++];
			*pDst++ = a;
			*pDst++ = a;
		}
		*pDst = 0;
		pDst0 += _Pitch2;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//XLCڂ₯TVłQ{R{S{T{pB32rbgJ[Bv2.92ǉ
static void
zoom2x3x4x5xTVB_dd32(
	Sint32	bairitsu,	// 2x3x4xB2xȂ2B3xȂ3B4xȂ4B5xȂ4B
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;

	// XLC80%Bc1x2{̃\[X쐬B
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch * 2;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
			*pDst++ = _GammaTBL[*pSrc++];
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
			*pDst++ = _GammaTBLs80[*pSrc++];
		*pDst = 0;
		pDst0 += _Pitch2;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//mXLCłQ{R{S{T{pB32rbgJ[B
static void
zoom2x3x4x5xNS_dd32(
	Sint32	bairitsu,	// 2x3x4xB2xȂ2B3xȂ3B4xȂ4B5xȂ5B
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j, k;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;
	Uint32	a;
	Sint32	bairitsu2; //c̃hbg{ɃfW^g傷邩Bx2x3Ȃ2Bx4Ȃ3B5xȂ4B

	if (bairitsu == 2)
		bairitsu2 = 2;
	else
		bairitsu2 = bairitsu - 1;

	// XLCȂ
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * (_Pitch * bairitsu2);
	for (i = 0; i < srcH; i++)
	{
		for (k = 1; k <= bairitsu2; k++) //cbairitsu{ɃfW^g傷
		{
			pSrc = pSrc0;
			pDst = pDst0;
			for (j = 0; j < *pTvW; j++)
			{
				a = _GammaTBL[*pSrc++];
				*pDst++ = a;
				*pDst++ = a; //Q{g(XLCȂ)
			}
			*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
			pDst0 += _Pitch;
		}
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//mXLCTVłQ{R{S{T{pB32rbgJ[B
static void
zoom2x3x4x5xNSTV_dd32(
	Sint32	bairitsu,	// 2x3x4xB2xȂ2B3xȂ3B4xȂ4B5xȂ4B
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j, k;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;
	Sint32	bairitsu2; //c̃hbg{ɃfW^g傷邩Bx2x3Ȃ1Bx4Ȃ2B5xȂ3B

	if (bairitsu <= 3)
		bairitsu2 = 1;
	else
		bairitsu2 = bairitsu - 2;

	// XLCȂ
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * (_Pitch * bairitsu2);
	for (i = 0; i < srcH; i++)
	{
		for (k = 1; k <= bairitsu2; k++) //cbairitsu{ɃfW^g傷
		{
			pSrc = pSrc0;
			pDst = pDst0;
			for (j = 0; j < *pTvW; j++)
				*pDst++ = _GammaTBL[*pSrc++];
			*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
			pDst0 += _Pitch;
		}
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//mXLCڂ₯TVłQ{R{S{T{pB32rbgJ[B
static void
zoom2x3x4x5xNSTVB_dd32(
	Sint32	bairitsu,	// 2x3x4xB2xȂ2B3xȂ3B4xȂ4B5xȂ4B
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;

	// XLCȂBc1x1{({)̃\[X쐬B
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
			*pDst++ = _GammaTBL[*pSrc++];
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst0 += _Pitch;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//32rbgJ[xP{pBXLCȂB
static void
zoom1xNS_dd32(
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW, 		//
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;

	// P{Ȃ̂ŃXLC͖
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
			*pDst++ = _GammaTBL[*pSrc++];
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst0 += _Pitch;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//TV Mode 32rbgJ[T{pB
static void
zoom5xTV_dd32(
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;

	// XLC80%
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch5;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
			*pDst++ = _GammaTBL[*pSrc++];
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Qڂ90%XLCŁB̓Of[VtɕRɂقaȂB
			*pDst++ = _GammaTBLs90[*pSrc++];
		*pDst = 0;
		pDst = pDst0 + _Pitch2;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Rڂ90%XLCŁB̓Of[VtɕRɂقaȂB
			*pDst++ = _GammaTBLs90[*pSrc++];
		*pDst = 0;
		pDst = pDst0 + _Pitch3;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Sڂ90%XLCŁB̓Of[VtɕRɂقaȂB
			*pDst++ = _GammaTBLs90[*pSrc++];
		*pDst = 0;
		pDst = pDst0 + _Pitch4;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
			*pDst++ = _GammaTBLs80[*pSrc++];
		*pDst = 0;
		pDst0 += _Pitch5;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//TV Mode 32rbgJ[S{pB
static void
zoom4xTV_dd32(
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;

	// XLC80%
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch4;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
			*pDst++ = _GammaTBL[*pSrc++];
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Qڂ90%XLCŁBv2.35XVB̓Of[VtɕRɂقaȂB
			*pDst++ = _GammaTBLs90[*pSrc++];
		*pDst = 0;
		pDst = pDst0 + _Pitch2;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Rڂ90%XLCŁBv2.35XVB̓Of[VtɕRɂقaȂB
			*pDst++ = _GammaTBLs90[*pSrc++];
		*pDst = 0;
		pDst = pDst0 + _Pitch3;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
			*pDst++ = _GammaTBLs80[*pSrc++];
		*pDst = 0;
		pDst0 += _Pitch4;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//TV Mode 32rbgJ[R{pB
static void
zoom3xTV_dd32(
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;

	// XLC80%
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch3;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
			*pDst++ = _GammaTBL[*pSrc++];
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++) //Qڂ90%XLCɂB
			*pDst++ = _GammaTBLs90[*pSrc++];
		*pDst = 0;
		pDst = pDst0 + _Pitch2;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
			*pDst++ = _GammaTBLs80[*pSrc++];
		*pDst = 0;
		pDst0 += _Pitch3;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//Half Mode 32rbgJ[ Q{pB
static void
zoom2xTV_dd32(
	Uint32* pSrc,		// ]̃|C^
	Sint32	srcY,		// ]YW
	Uint16* pTvW,		// eC̕
	Sint32	srcH)		// ]̍
{
	int		i, j;
	Uint32* pSrc0;
	Uint32* pDst;
	Uint32* pDst0;

	// XLC80%
	pSrc0 = pSrc;
	pDst0 = _pPixels + srcY * _Pitch2;
	for (i = 0; i < srcH; i++)
	{
		pSrc = pSrc0;
		pDst = pDst0;
		for (j = 0; j < *pTvW; j++)
			*pDst++ = _GammaTBL[*pSrc++];
		*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
		pDst = pDst0 + _Pitch;
		pSrc = pSrc0;
		for (j = 0; j < *pTvW; j++)
			*pDst++ = _GammaTBLs80[*pSrc++];
		*pDst = 0;
		pDst0 += _Pitch2;
		pSrc0 += SOURCE_PITCH;
		pTvW++;
	}
}

//[h 32rbgJ[B(&\[XR[h)DBeʃ[hŋʏ͋ʂčsBv2.29
static void
monoColor_32(
	Sint32		bairitsu,		// EBhE\{
	Sint32		scanlineType,	// XLC̃^Cv
	Uint32*		pSrc,			// ]̃|C^
	Sint32		srcY,			// ]YW
	Uint16*		pTvW,			// eC̕
	Sint32		srcH,			// ]̍
	Sint32		bGreen)			// O[fBXvC
{
	int			q, i, j, k;
	Uint32*		pSrc0;
	Uint32*		pDst;
	Uint32*		pDst0;
	Uint32		d;
	Uint32		a;
	int			sl;
	BOOL		bSpecial;

	if (bairitsu == 1)
		scanlineType = 0;
	if (((scanlineType == 2) || (scanlineType == 0) || ((scanlineType >= 5) && (scanlineType <= 8))) && (bairitsu >= 2))
		sl = 2; //XLCmXLC(ڂ₯^Cv)̏ꍇi܂AcXLCTVXLCڂ₯^Cvł͂Ȃꍇj
	else
		sl = 1;
	if ((scanlineType == 0) || ((scanlineType >= 7) && (scanlineType <= 10))) //mXLC
	{
		if (scanlineType == 10) //mXLCڂ₯^Cv2̏ꍇ
		{
			bairitsu = 1;
		}
		else if (scanlineType == 9) //mXLCڂ₯^Cv̏ꍇ
		{
			if (bairitsu >= 4)
				bairitsu -= 2;
			else
				bairitsu = 1;
		}
		else //ȊO
		{
			if (bairitsu >= 3)
				bairitsu--;
		}
		pSrc0 = pSrc;
		pDst0 = _pPixels + srcY * _Pitch * bairitsu;
		for (i = 0; i < srcH; i++)
		{
			for (q = 1; q <= bairitsu; q++)
			{
				pSrc = pSrc0;
				pDst = pDst0;
				for (j = 0; j < *pTvW; j++)
				{
					a = _MonoTBL[*pSrc++];
					for (k = 0; k < sl; k++) //XLC̏ꍇAhbgłQ{gB
						*pDst++ = a; //mNBPhbgԂ񏑂܂B
				}
				*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
				pDst0 += _Pitch;
			}
			pSrc0 += SOURCE_PITCH;
			pTvW++;
		}
	}
	else //XLC
	{
		// XLC80%
		bSpecial = (scanlineType == 1); //cXLC̏ꍇTRUEBv2.78
		if (scanlineType == 11) //TVXLC2ڂ₯^Cv̏ꍇ
			bairitsu = 2;
		pSrc0 = pSrc;
		pDst0 = _pPixels + srcY * _Pitch * bairitsu;
		for (i = 0; i < srcH; i++)
		{
			pSrc = pSrc0;
			pDst = pDst0;
			for (j = 0; j < *pTvW; j++)
			{
				d = *pSrc++;
				for (k = 0; k < sl; k++) //XLC̏ꍇAhbgłQ{gB
					*pDst++ = _MonoTBL[d]; //mNBPhbgԂ񏑂܂B
				if (bSpecial) //cXLC̏ꍇ
					*pDst++ = _MonoTBLs90[d]; //mNBPhbgԂ񏑂܂BQ{g(90%cXLC)
			}
			*pDst = 0; //Direct3Dł͉E[ɂPhbgԂNA()}[WĂȂƉE[B
			pDst = pDst0 + _Pitch;
			pSrc = pSrc0;
			switch (bairitsu)
			{
			case 5: //x5{Bv2.92
				for (j = 0; j < *pTvW; j++) //Qڂ90%XLCŁBv2.35XV
				{
					a = _MonoTBLs90[*pSrc++];
					for (k = 0; k < sl; k++) //XLC̏ꍇAhbgłQ{gB
						*pDst++ = a; //mNBPhbgԂ񏑂܂B
					if (bSpecial) //cXLC̏ꍇ
						*pDst++ = a; //mNBPhbgԂ񏑂܂BQ{g(90%cXLC)
				}
				*pDst = 0;
				pDst = pDst0 + _Pitch2;
				pSrc = pSrc0;
				for (j = 0; j < *pTvW; j++) //Rڂ90%XLCŁBv2.35XV
				{
					a = _MonoTBLs90[*pSrc++];
					for (k = 0; k < sl; k++) //XLC̏ꍇAhbgłQ{gB
						*pDst++ = a; //mNBPhbgԂ񏑂܂B
					if (bSpecial) //cXLC̏ꍇ
						*pDst++ = a; //mNBPhbgԂ񏑂܂BQ{g(90%cXLC)
				}
				*pDst = 0;
				pDst = pDst0 + _Pitch3;
				pSrc = pSrc0;
				for (j = 0; j < *pTvW; j++) //Sڂ90%XLCŁB
				{
					a = _MonoTBLs90[*pSrc++];
					for (k = 0; k < sl; k++) //XLC̏ꍇAhbgłQ{gB
						*pDst++ = a; //mNBPhbgԂ񏑂܂B
					if (bSpecial) //cXLC̏ꍇ
						*pDst++ = a; //mNBPhbgԂ񏑂܂BQ{g(90%cXLC)
				}
				*pDst = 0;
				pDst = pDst0 + _Pitch4;
				break;
			case 4: //x4{
				for (j = 0; j < *pTvW; j++) //Qڂ90%XLCŁBv2.35XV
				{
					a = _MonoTBLs90[*pSrc++];
					for (k = 0; k < sl; k++) //XLC̏ꍇAhbgłQ{gB
						*pDst++ = a; //mNBPhbgԂ񏑂܂B
					if (bSpecial) //cXLC̏ꍇ
						*pDst++ = a; //mNBPhbgԂ񏑂܂BQ{g(90%cXLC)
				}
				*pDst = 0;
				pDst = pDst0 + _Pitch2;
				pSrc = pSrc0;
				for (j = 0; j < *pTvW; j++) //Rڂ90%XLCŁBv2.35XV
				{
					a = _MonoTBLs90[*pSrc++];
					for (k = 0; k < sl; k++) //XLC̏ꍇAhbgłQ{gB
						*pDst++ = a; //mNBPhbgԂ񏑂܂B
					if (bSpecial) //cXLC̏ꍇ
						*pDst++ = a; //mNBPhbgԂ񏑂܂BQ{g(90%cXLC)
				}
				*pDst = 0;
				pDst = pDst0 + _Pitch3;
				break;
			case 3: //x3{
				for (j = 0; j < *pTvW; j++) //Qڂ90%XLC
				{
					a = _MonoTBLs90[*pSrc++];
					for (k = 0; k < sl; k++) //XLC̏ꍇAhbgłQ{gB
						*pDst++ = a; //mNBPhbgԂ񏑂܂B
					if (bSpecial) //cXLC̏ꍇ
						*pDst++ = a; //mNBPhbgԂ񏑂܂BQ{g(90%cXLC)
				}
				*pDst = 0;
				pDst = pDst0 + _Pitch2;
				break;
				//case 2: //x2{
				//	x2{̂Ƃ͏ȂB
			}
			if (bairitsu >= 2)
			{
				pSrc = pSrc0;
				for (j = 0; j < *pTvW; j++)
				{
					a = _MonoTBLs80[*pSrc++];
					for (k = 0; k < sl; k++) //XLC̏ꍇAhbgłQ{gB
						*pDst++ = a; //mNBPhbgԂ񏑂܂B
					if (bSpecial) //cXLC̏ꍇ
						*pDst++ = a; //mNBPhbgԂ񏑂܂BQ{g(80%cXLC)
				}
				*pDst = 0;
			}
			pDst0 += _Pitch * bairitsu;
			pSrc0 += SOURCE_PITCH;
			pTvW++;
		}
	}
}


//pSrc̕`f[^p\R\ɃGR[hAobNobt@։摜݂܂B
//		CƂɉ𑜓xςĂQ[iՂ̌C120%ȂǁjɂΉB
void
SCREEND3D_Blt(
	Uint32* pSrc,
	Sint32		srcX,
	Sint32		srcY,
	Uint16* pTvW,	//]̉sNZBsrcHC̐Ԃ
	Sint32		srcH,
	Sint32		executeCode)  //KitaoǉBsR[hB0cGR[hsB1cvC}ʂ֓]sB2cXN[Vbgpʂ֓]sB
							  //					   3cEɍ(I[o[XL)zuĂ̓](Ƃ1Ɠ)
							  //					   5cẼI[o[XLJbgĂ̓](Ƃ1Ɠ)
							  //					   6cg莞pfps\≹Ot\͍sȂ(Ƃ1Ɠ)
{
	Uint32*	pSrc32;
	Uint16*	pTvW2;
	Sint32	scanlineType;

	if (pSrc == NULL) return;

	//v1.28XVBCr̃GR[hɑΉB
	pSrc32 = pSrc + srcY * 512 + srcX;
	pTvW2 = pTvW + srcY;

	if (srcH > 0) //v2.43XV
	{
		if (lock_offscreen_surface(&_Pitch, &_pPixels)) //obNT[tFXbN
		{
			_Pitch2 = _Pitch * 2;
			_Pitch3 = _Pitch * 3;
			_Pitch4 = _Pitch * 4;
			_Pitch5 = _Pitch * 5;

			//xd̂߂ꂼ̉ʃ[hŁAʁX̃[`gB
			scanlineType = APP_GetScanlineType();
			if (MAINBOARD_GetMonoColor()) //[hȂB͂ɂ񂴂,p[htg̗Z
			{	//[h̏ꍇBv2.28,2.29
				monoColor_32(_Magnification, scanlineType, pSrc32, srcY, pTvW2, srcH, (MAINBOARD_GetForceMonoColor() == 2));
			}
			else
			{	//ʏ
				switch (scanlineType)
				{
				case 0: //mXLC
				case 7: //mXLC2(Sharp,Fast)
				case 8: //mXLC3(Soft)
					switch (_Magnification)
					{
						case 1:	zoom1xNS_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 2:
						case 3:
						case 4:
						case 5://v2.92ǉ
							zoom2x3x4x5xNS_dd32(_Magnification, pSrc32, srcY, pTvW2, srcH);
							break;
					}
					break;
				case 1: //cXLC
					switch (_Magnification)
					{
						case 1:	zoom1xNS_dd32(pSrc32, srcY, pTvW2, srcH); //mXLCƓB
							break;
						case 2:	zoom2x_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 3:	zoom3x_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 4:	zoom4x_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 5:	zoom5x_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
					}
					break;
				case 2: //XLC
				case 5: //XLC2
				case 6: //XLC3
					switch (_Magnification)
					{
						case 1:	zoom1xNS_dd32(pSrc32, srcY, pTvW2, srcH); //mXLCƓB
							break;
						case 2:	zoom2xHS_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 3:	zoom3xHS_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 4:	zoom4xHS_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 5:	zoom5xHS_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
					}
					break;
				case 3: //XLC2(Fast)
				case 4: //TVXLC
					switch (_Magnification)
					{
						case 1:	zoom1xNS_dd32(pSrc32, srcY, pTvW2, srcH); //mXLCƓB
							break;
						case 2:	zoom2xTV_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 3:	zoom3xTV_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 4:	zoom4xTV_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 5:	zoom5xTV_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
					}
					break;
				case 9: //mXLCTVBv2.92XV
					switch (_Magnification)
					{
						case 1:	zoom1xNS_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 2:
						case 3:
						case 4:
						case 5:
							zoom2x3x4x5xNSTV_dd32(_Magnification, pSrc32, srcY, pTvW2, srcH);
							break;
					}
					break;
				case 10: //mXLCTVڂ₯Bv2.92XV
					switch (_Magnification)
					{
						case 1:	zoom1xNS_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 2:
						case 3:
						case 4:
						case 5:
							zoom2x3x4x5xNSTVB_dd32(_Magnification, pSrc32, srcY, pTvW2, srcH);
							break;
					}
					break;
				case 11: //TVXLC2(ڂ₯)Bv2.92XV
					switch (_Magnification)
					{
						case 1:	zoom1xNS_dd32(pSrc32, srcY, pTvW2, srcH);
							break;
						case 2:
						case 3:
						case 4:
						case 5:
							zoom2x3x4x5xTVB_dd32(_Magnification, pSrc32, srcY, pTvW2, srcH);
							break;
					}
					break;
				}
			}

			//bN
			_pD3DSGame->UnlockRect();
		}
	}

	//vC}ʂւ̓]
	if (executeCode > 0)
		zoom_d3dTensou(pTvW + (16 - MAINBOARD_GetShowOverscanTop()),
			srcY + srcH - (16 - MAINBOARD_GetShowOverscanTop()),
			executeCode);
}


//VSync(A҂)sǂݒBVSyncݒłSyncłȂ̏ꍇ͎ňꎞIɃItɂB
void
SCREEND3D_SetVSyncScreen(
	BOOL	bVSyncScreen)
{
	BOOL		bPrevVSyncScreen = _bVSyncScreen;
	DEVMODE		dm;

	//fBXvČ݂̕\g߂BV-Syncs邩ǂfB
	MAINBOARD_SetVSyncHz(60); //60Hzɏ
	//MAINBOARD_SetVSyncHz(120);//testp
	memset(&dm, 0, sizeof(DEVMODE));
	dm.dmSize = sizeof(DEVMODE);
	EnumDisplaySettings(NULL, ENUM_CURRENT_SETTINGS, &dm);
	if ((dm.dmDisplayFrequency ==  60) || (dm.dmDisplayFrequency ==  59) || (dm.dmDisplayFrequency ==  61) || //tbV[g60Hz(5961܂)ݒ̂ƂBForceVSyncv2.65p~B
		(dm.dmDisplayFrequency == 120) || (dm.dmDisplayFrequency == 119) || (dm.dmDisplayFrequency == 121) || //tbV[g120Hz(119121܂)̂Ƃ
		(dm.dmDisplayFrequency == 180) || (dm.dmDisplayFrequency == 179) || (dm.dmDisplayFrequency == 181) || //tbV[g180Hz(179181܂)̂Ƃ
		(dm.dmDisplayFrequency == 240) || (dm.dmDisplayFrequency == 239) || (dm.dmDisplayFrequency == 241) || //tbV[g240Hz(239241܂)̂Ƃ
		(dm.dmDisplayFrequency == 300) || (dm.dmDisplayFrequency == 299) || (dm.dmDisplayFrequency == 301) || //tbV[g300Hz(299301܂)̂Ƃ
		(dm.dmDisplayFrequency == 360) || (dm.dmDisplayFrequency == 359) || (dm.dmDisplayFrequency == 361))   //tbV[g360Hz(359361܂)̂Ƃ
	{
		_bVSyncScreen = APP_GetVSyncScreen();
		APP_EnableVSyncMenu(TRUE); //j[XV
		if ((dm.dmDisplayFrequency == 120) || (dm.dmDisplayFrequency == 119) || (dm.dmDisplayFrequency == 121))      //tbV[g120Hz(119121܂)̂Ƃ
			MAINBOARD_SetVSyncHz(120);
		else if ((dm.dmDisplayFrequency == 180) || (dm.dmDisplayFrequency == 179) || (dm.dmDisplayFrequency == 181)) //tbV[g180Hz(179181܂)̂Ƃ
			MAINBOARD_SetVSyncHz(180);
		else if ((dm.dmDisplayFrequency == 240) || (dm.dmDisplayFrequency == 239) || (dm.dmDisplayFrequency == 241)) //tbV[g240Hz(239241܂)̂Ƃ
			MAINBOARD_SetVSyncHz(240);
		else if ((dm.dmDisplayFrequency == 300) || (dm.dmDisplayFrequency == 299) || (dm.dmDisplayFrequency == 301)) //tbV[g300Hz(299301܂)̂Ƃ
			MAINBOARD_SetVSyncHz(300);
		else if ((dm.dmDisplayFrequency == 360) || (dm.dmDisplayFrequency == 359) || (dm.dmDisplayFrequency == 361)) //tbV[g360Hz(359361܂)̂Ƃ
			MAINBOARD_SetVSyncHz(360);
	}
	else
	{
		_bVSyncScreen = FALSE;
		APP_EnableVSyncMenu(FALSE); //j[XV
	}
	//ݒ肪ύXꂽꍇADirect3DIuWFNgB
	if (_bVSyncScreen != bPrevVSyncScreen)
		if (_pD3D != NULL) //IĂ΁BOɌĂ΂ꂽꍇ(App.cĂ΂)͕ϐ̍XV̂݁B
			SCREEND3D_ChangeMode(_Width, _Height, _Magnification, _Flags);
}

//VSync(A҂)sĂ邩ǂԂBVSyncݒłSyncłȂ̏ꍇFALSEԂBv2.43
BOOL
SCREEND3D_GetVSyncScreen()
{
	return _bVSyncScreen;
}


//Windows̎V-Sync@\̕ϐXVBv2.65
void
SCREEND3D_UpdateWindowsAutoVSync()
{
	SCREEND3D_ChangeMode(_Width, _Height, _Magnification, _Flags); //Direct3DIuWFNgB
}


//OVBlank҂IԂBv1.28
Sint64
SCREEND3D_GetLastTimeSyncTime()
{
	return _LastTimeSyncTime;
}

//XN[Vbgt@CɏށBv2.12
void
SCREEND3D_WriteScreenshot(
	FILE* fp)
{
	int				i, j;
	D3DLOCKED_RECT	pLockedRect;
	HRESULT			hr;
	LONG			pitch;
	Uint32* pPixels0;
	Uint32* pPixels;
	Uint32			BGRR; //Bule,Green,Red,Reserved
	Sint32			width;
	Sint32			height;
	Sint32			left;
	Sint32			top;
	Sint32			w2, h2;
	Sint32			wp;

	//obt@ɍĕ`悷B
	if ((_Flags & SCREEN_FFULLSCREEN)|| //tXN[Bv2.98XV
		((APP_GetOverscanHideBlackLR())&&(MAINBOARD_GetShowOverscanLeft() == 0))|| //ẼI[o[XL̈ɍѕ\Ăꍇ
		((APP_GetOverscanHideBlackTop())&&(MAINBOARD_GetShowOverscanTop() < 8))) //㑤̃I[o[XL̈ɍѕ\Ăꍇ
			MAINBOARD_SetResolutionChange(TRUE); //`掞ɃS~cȂ悤ɉʑŜNAĂ`悷B
	MAINBOARD_DrawScreenshot();
	//_pD3DDev->Presentł̕\XV͍sȂB
	MAINBOARD_SetResolutionChange(FALSE); //ɖ߂

	//TCYvZ
	width = APP_GetGameWidth(_Magnification);
	height = APP_GetGameHeight(_Magnification);
	wp = 4 - (width * 3 % 4); //PC4bytePʂɐ邽߂̒l
	if (wp == 4) wp = 0;

	//̈ʒuvZ
	if (_Flags & SCREEN_FFULLSCREEN)
	{
		if (APP_GetFullStretched(TRUE))
		{
			//AXyNg4:3ɕۂ
			if (_Width / 4 >= _Height / 3)
			{	//ĉقẐŏcƂ
				w2 = (Sint32)((double)(_Height / 3.0 * 4.0 + 0.5));
				left = (_Width - w2) / 2;
				if (MAINBOARD_GetShowOverscanLeft() > 0) //ẼI[o[XL̈\Ȃ
					top = (_Height - (Sint32)((double)_Height * 0.96137 + 0.5)) / 2; //0.96137=224/((268-256)/4*3+224)
				else
					top = 0;
			}
			else
			{	//̂قẐŉƂ
				h2 = (Sint32)((double)(_Width / 4.0 * 3.0 + 0.5));
				left = 0;
				if (MAINBOARD_GetShowOverscanLeft() > 0) //ẼI[o[XL̈\Ȃ
					top = (_Height - (Sint32)((double)h2 * 0.96137 + 0.5)) / 2; //0.96137=224/((268-256)/4*3+224)
				else
					top = (_Height - h2) / 2;
			}
		}
		else if (APP_GetStretched())
		{
			if (MAINBOARD_GetShowOverscanLeft() > 0) //ẼI[o[XL̈\Ȃ
				w2 = 320 * _Magnification;
			else
				w2 = 298 * _Magnification;
			if (APP_GetVStretched()) //cʃ[hȂ
				w2 = (Sint32)((double)w2 * TATEGAMEN + 0.5);
			//AXyNgTVʂƓ4:3ɁBc̒PCEW224̐{(Q{)ɂ
			left = (_Width - w2) / 2;
			top = (_Height - 224 * _Magnification) / 2;
			if (MAINBOARD_GetShowOverscanTop() > 0) //㑤̃I[o[XL̈\Ȃ
			{
				top -= MAINBOARD_GetShowOverscanTop() * _Magnification;
				if (top < 0) //ʂ͂ݏoĂ܂ꍇB1440x900,1600x900Ȃǂł蓾B
					top = (_Height - 224 * _Magnification) / 2; //AXyNgۂ߁AI[o[XLJbgB
			}
		}
		else //mXgb`̏ꍇ
		{
			w2 = APP_GetNonstretchedWidth() * _Magnification;
			if (w2 > _Width) w2 = _Width; //ʂ͂ݏoĂ܂ꍇ́AXgb`(k)đΉB
			left = (_Width - w2) / 2;
			top = (_Height - 224 * _Magnification) / 2;
			if (MAINBOARD_GetShowOverscanTop() > 0) //㑤̃I[o[XL̈\Ȃ
			{
				top -= MAINBOARD_GetShowOverscanTop() * _Magnification;
				if (top < 0) top = 0; //ʂ͂ݏoĂ܂ꍇ́AXgb`(k)đΉB1440x900,1600x900Ȃǂł蓾B
			}
		}
	}
	else
	{
		left = 0;
		top = 0;
	}

	//Lv`郁bN
	hr = _pD3DSBack->LockRect(&pLockedRect, NULL, D3DLOCK_READONLY); //READONLYōBv2.28
	if (hr != D3D_OK) return;

	pitch = pLockedRect.Pitch / 4; //32bitPʂŏ邽߃sb`1/4ɁB
	pPixels0 = (Uint32*)pLockedRect.pBits + pitch * (top + height - 1) + left; //ŉit@Cɏo͂čs(BMP̎dl)B

	for (i = 0; i < height; i++)
	{
		pPixels = pPixels0;
		for (j = 0; j < width; j++)
		{
			BGRR = (*pPixels++);
			fwrite(&BGRR, 3, 1, fp); //BGR
		}
		if (wp > 0)
		{	//PC4bytePʂɐ
			BGRR = 0;
			fwrite(&BGRR, wp, 1, fp);
		}
		pPixels0 -= pitch;
	}

	//bN
	_pD3DSBack->UnlockRect();
}


//KitaoǉBXN[Vbĝ߂ɈꎞIɕ`{ύXBScreen.cppgpBv2.13
void
SCREEND3D_SetMagnification(
	Sint32	magnification)
{
	_Magnification = magnification;
}

//KitaoǉBv2.13
Sint32
SCREEND3D_GetMagnification()
{
	return _Magnification;
}

//KitaoǉBv2.79
BOOL
SCREEND3D_GetIntelVideoChip()
{
	return _bIntelVideoChip;
}

//KitaoǉBv2.19
BOOL
SCREEND3D_GetOldVideoChip()
{
	return _bOldVideoChip;
}


//C(Q[)ʗpItXN[PFœhԂAvC}ʂ֓]Bv2.77XV
void
SCREEND3D_Fill(
	Uint32		color)
{
	int			a, i, j;
	LONG		pitch;
	Uint32*		pPixels;
	Uint32*		pPixels0;
	Uint16		tvW[256];

	if (_Magnification == 1)
		a = 512;
	else
		a = 512 * 2;
	if (lock_offscreen_surface(&pitch, &pPixels))
	{
		pPixels0 = pPixels;
		for (i = 0; i < 256*_Magnification; i++)
		{
			pPixels = pPixels0;
			for (j = 0; j < a; j++)
				*pPixels++ = color; //4byteԂ(Phbg)܂B
			for (j = 0; j < 8; j++)
				*pPixels++ = 0; //E[Whbg͍Ŗ߂iDirect3D̃tB^[ɃS~oȂߕKvj
			pPixels0 += pitch;
		}
		_pD3DSGame->UnlockRect();
	}

	//vC}ʂւ̓]
	for (i = 0; i < 256; i++)
		tvW[i] = 256;
	zoom_d3dTensou(tvW, 224, 1);
}
