/******************************************************************************
Ootake

 [TurboConfig.cpp]
	A˃{^̐ݒ邽߂̃tH[

Copyright(C)2006-2021 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

******************************************************************************/
#define _CRT_SECURE_NO_DEPRECATE

#define DIRECTINPUT_VERSION	0x0500	//KitaoǉBɂ邩ȂADirectInput5yB7ƂxBXy[XnA[킩₷B

#include <string.h>
#include "TurboConfig.h"
#include "App.h"
#include "PadConfig.h"
#include "resource.h"
#include "JoyPad.h"
#include "KeyConfig.h"
#include "Printf.h" //eXgp


#define LINE_LEN	39
#define N_LINES		12

enum OptionComponent
{
	BUTTON_2BPAD = 1,
	EDIT_2BPAD,
	BUTTON_3BPAD,
	EDIT_3BPAD,
	BUTTON_HELP,
	BUTTON_CLOSE,
};

static HWND			_hWndC[BUTTON_CLOSE]; //eR|[lg̃nh

static HBRUSH		_hMyBrush; //uVF
static HFONT		_hFontB; //{^ptHg
static HBRUSH		_hEditBrush; //EDIT̘g̐F

static Uint32		_FontWidth;
static Uint32		_FontHeight;
static const char*	_pCaption = "\"Ootake\" Turbo Button Setting";
static HINSTANCE	_hInstance = NULL;
static HWND 		_hWnd = NULL;
static HWND 		_hParentWnd = NULL;

static Sint32		_PadID;
static Sint32		_SetOk = -1; //߂lBݒ芮Ȃ1BLZȂ-1Bݒ蒆0B
static Sint32*		_pSetOk;


//tHg̍擾
static Uint32
get_font_height(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = (HFONT)GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)(tm.tmHeight);
}

//tHg̉擾
static Uint32
get_font_width(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = (HFONT)GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)tm.tmAveCharWidth;
}

//WindowTCYݒ
static void
set_window_size(
	HWND			hWnd)
{
	RECT		rc;
	Uint32		wndW = _FontWidth  * LINE_LEN;
	Uint32		wndH = _FontHeight * N_LINES +1;

	SetRect(&rc, 0, 0, wndW, wndH);
	AdjustWindowRectEx(&rc, GetWindowLong(hWnd, GWL_STYLE),
						GetMenu(hWnd) != NULL, GetWindowLong(hWnd, GWL_EXSTYLE));
	wndW = rc.right - rc.left;
	wndH = rc.bottom - rc.top;
	GetWindowRect(_hParentWnd, &rc);
	MoveWindow(hWnd, rc.right-wndW, rc.top, wndW, wndH, TRUE);
}

//{^ݒ̏Ԃ\
static void
update_status()
{
	PCEPAD	pcePad;
	char	buf[128];
	char	buf2[3+1]; //v2.96C
	
	//Q{^pbh̘A˃{^ݒ
	APP_GetPcePad2(_PadID, &pcePad);
	strcpy(buf, " I..[");
	KEYCONFIG_ToChrPcePad(buf2, pcePad.button5);
	strcat(buf, buf2);
	strcat(buf, "]  II..[");
	KEYCONFIG_ToChrPcePad(buf2, pcePad.button6);
	strcat(buf, buf2);
	strcat(buf, "]");
	SendDlgItemMessage(_hWnd, EDIT_2BPAD, EM_SETSEL, 0, -1);	
	SendDlgItemMessage(_hWnd, EDIT_2BPAD, EM_REPLACESEL, FALSE, (LPARAM)buf);	

	//R{^pbh̃{^ݒ
	APP_GetPcePad3(_PadID, &pcePad);
	strcpy(buf, " I..[");
	KEYCONFIG_ToChrPcePad(buf2, pcePad.button5);
	strcat(buf, buf2);
	strcat(buf, "]  II..[");
	KEYCONFIG_ToChrPcePad(buf2, pcePad.button6);
	strcat(buf, buf2);
	strcat(buf, "]");
	SendDlgItemMessage(_hWnd, EDIT_3BPAD, EM_SETSEL, 0, -1);	
	SendDlgItemMessage(_hWnd, EDIT_3BPAD, EM_REPLACESEL, FALSE, (LPARAM)buf);	
}

//Window\XV
static void
update_window(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	PAINTSTRUCT 	ps;
	Uint32			x;
	Uint32			y;

	/* `揀 */
	hDC = BeginPaint(hWnd, &ps);
	SetBkMode(hDC, OPAQUE);	//̔wihԂ
	SetBkColor(hDC, RGB(64,128,64));
	SetTextColor(hDC, RGB(240,240,240));
	hFont = (HFONT)GetStockObject(OEM_FIXED_FONT);
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	x = _FontWidth*2;
	y = _FontHeight +3;
	if (JOYPAD_GetConnectSixButton())
		TextOut(hDC, x, y, "[ playing 6-Button Pad Game now! ]", 34);
	else if (JOYPAD_GetConnectThreeButton())
		TextOut(hDC, x, y, "[ playing 3-Button Pad Game now! ]", 34);
	else if (APP_GetInit()) //Q[łɋNĂꍇ(܂NSetting{^̌ĂяoȂꍇ)
		TextOut(hDC, x, y, "[ playing 2-Button Pad Game now! ]", 34);
	else	
		TextOut(hDC, x, y, "[ Most games use 2-Button Pad. ]", 32);
	x = _FontWidth*3 +2;
	y += _FontHeight*2 -3;
	TextOut(hDC, x, y, "Turbo for 2-Button Pad Games", 28);
	y += _FontHeight*3;
	TextOut(hDC, x, y, "Turbo for 3-Button Pad Games", 28);

	/* I */
	EndPaint(hWnd, &ps);
	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);
}


static LRESULT CALLBACK
turboconfig_wnd_proc(
	HWND		hWnd,
	UINT		uMsg,
	WPARAM		wParam,
	LPARAM		lParam)
{
	MSG			msg;
	PCEPAD		pcePad; //{^ݒpobt@
	Sint32		setOk;

	switch (uMsg)
	{
	case WM_CREATE:
		EnableWindow(_hParentWnd, FALSE);//eEBhE𖳌ă[_ɁB
		_hFontB = CreateFont(  0,						// B0 = ftHg
		                       0,						// B0Ȃ獂ɍ
    		                   0,						// px
        		               0,						// x[XCƂ̊px
            		           FW_NORMAL,				// 
                		       FALSE,					// C^bN
	                    	   FALSE,					// A_[C
		                       FALSE,					// ł
    		                   0,						// {舵ƂSHIFTJIS_CHARSETɂB
        		               0,						// o͐x
            		           0,						// NbsOx
                		       0,						// o͕i
                    		   0,						// sb`ƃt@~[
		                       ""						// ̖
							); //p̃ftHgtHgɐݒ
		_FontWidth	= get_font_width(hWnd);
		_FontHeight = get_font_height(hWnd);
		set_window_size(hWnd);
		_hEditBrush = CreateSolidBrush(RGB(0,0,0)); //EDIT̘g̐F
		break;

	case WM_PAINT:
		update_window(hWnd);
		break;

	case WM_CTLCOLORSTATIC:
		{	//ǂݎpEDITWM_CTLCOLORSTATICň̂łŐFw肷B
			SetBkMode((HDC)wParam, OPAQUE);	//̔wihԂ
			SetTextColor(((HDC)wParam), RGB(255,255,255)); //EDIT̕F
			SetBkColor(((HDC)wParam), RGB(0,0,0)); //EDIT̔wiF
		}
		return (LRESULT)_hEditBrush; //g\ɎgFԂ

	case WM_KEYDOWN:
		if (wParam == VK_ESCAPE)
		{
			TURBOCONFIG_Deinit();
			return 0;
		}
		break;

	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
			case BUTTON_2BPAD:
				//Q{^pbh̘A˃{^ݒ
				setOk = 0;
				ZeroMemory(&pcePad, sizeof(pcePad));
				APP_GetPcePad2(_PadID, &pcePad);
				PADCONFIG_Init(_hWnd, _hInstance, 1, _PadID, 2, &pcePad, &setOk); //PadConfig_CAO\
				while (setOk == 0) //_CAOʂԂ܂Ń[v
				{ 
					GetMessage(&msg ,NULL, 0, 0);
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
				if (setOk == 1) //ݒ肪ꍇ
				{
					APP_SetPcePad2(_PadID, pcePad);
					update_status(); //{^ݒ̏󋵕\XV
					_SetOk = 1; //Ŝ̃tO(PłݒXVtO𗧂Ă)Ă
				}
				break;
		
			case BUTTON_3BPAD:
				//R{^pbh̘A˃{^ݒ
				setOk = 0;
				ZeroMemory(&pcePad, sizeof(pcePad));
				APP_GetPcePad3(_PadID, &pcePad);
				PADCONFIG_Init(_hWnd, _hInstance, 1, _PadID, 3, &pcePad, &setOk); //PadConfig_CAO\
				while (setOk == 0) //_CAOʂԂ܂Ń[v
				{ 
					GetMessage(&msg ,NULL, 0, 0);
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
				if (setOk == 1) //ݒ肪ꍇ
				{
					APP_SetPcePad3(_PadID, pcePad);
					update_status(); //{^ݒ̏󋵕\XV
					_SetOk = 1; //Ŝ̃tO(PłݒXVtO𗧂Ă)Ă
				}
				break;
		
			case BUTTON_HELP:
				//A˃{^ݒ莞ɒӂ_Ȃǂ\
				MessageBox(hWnd,
					"You can set a special button for Auto-Fire. And, if you set the    \n"
					"normal Auto-Fire (check \"TurboButton I\" and \"TurboButton II\"    \n"
					"in the \"Input\" menu), you can use this Auto-Fire button as a    \n"
					"\"Non-Auto-Fire button\".    \n"
					"\n"
					"In Japanese language\n"
					"Aːp̃{^ݒł܂B̘Aːp{^ݒ肵   \n"
					"ꍇAɒʏ̘Aːݒi\"Input\"j[\"TurboButton I\",   \n"
					"\"TurboButton II\"Ƀ`FbNjۂɂ́At   \n"
					"\"A˃{^\"ƂĎgƂł܂B   ",
					"About \"Turbo Button\" Setting", MB_OK);
				break;
		
			case BUTTON_CLOSE:
				TURBOCONFIG_Deinit();
				return 0;
		}
		break;

	case WM_CLOSE:
		TURBOCONFIG_Deinit();
		return 0;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}


static BOOL
turboconfig_main()
{
	WNDCLASS	wc;
	HWND		hWnd;
	RECT		rc;
	Uint32		x;
	Uint32		y;
	HWND		hWndTmp;
	
	ZeroMemory(&wc, sizeof(wc));
	wc.style		 = 0;
	wc.lpfnWndProc	 = turboconfig_wnd_proc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = _hInstance;
	wc.hIcon		 = LoadIcon(_hInstance, MAKEINTRESOURCE(IDI_ICON)); //ACRǂݍ
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	_hMyBrush = CreateSolidBrush(RGB(64,128,64)); //uV
	wc.hbrBackground = _hMyBrush;
	wc.lpszMenuName  = "";
	wc.lpszClassName = _pCaption;

	if (RegisterClass(&wc) == 0)
		return FALSE;

	hWnd = CreateWindow(
		_pCaption,
		_pCaption,
		WS_SYSMENU | WS_CAPTION,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		0,
		0,
		_hParentWnd,
		NULL,
		_hInstance,
		NULL
	);

	if (hWnd == NULL)
		return FALSE;

	_hWnd = hWnd;

	//Q{^pbhݒ̃{^쐬
	x = _FontWidth*3 +2;
	y = _FontHeight*4 +2;
	hWndTmp = CreateWindow(
		"BUTTON", "Set ",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*6-1, _FontHeight+6,
		_hWnd, (HMENU)BUTTON_2BPAD, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));

	//Q{^pbhݒ󋵂̕\GfBbg(Read Only)쐬
	x += _FontWidth*6;
	hWndTmp = CreateWindow(
		"EDIT", " I..[ N ]  II..[Spc]",
		WS_CHILD | WS_VISIBLE | ES_LEFT | ES_READONLY,
		x, y, _FontWidth*28-1, _FontHeight+5,
		_hWnd, (HMENU)EDIT_2BPAD, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));

	//R{^pbhݒ̃{^쐬
	x = _FontWidth*3 +2;
	y += _FontHeight*3;
	hWndTmp = CreateWindow(
		"BUTTON", "Set ",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*6-1, _FontHeight+6,
		_hWnd, (HMENU)BUTTON_3BPAD, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));

	//R{^pbhݒ󋵂̕\GfBbg(Read Only)쐬
	x += _FontWidth*6;
	hWndTmp = CreateWindow(
		"EDIT", " I..[ N ]  II..[Spc]",
		WS_CHILD | WS_VISIBLE | ES_LEFT | ES_READONLY,
		x, y, _FontWidth*28-1, _FontHeight+5,
		_hWnd, (HMENU)EDIT_3BPAD, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));

	//Help{^쐬
	x = _FontWidth*16 +6;
	y += _FontHeight*2 +7;
	hWndTmp = CreateWindow(
		"BUTTON", "Help",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*10, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_HELP, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));

	//Close{^쐬
	x += _FontWidth*11 -3;
	hWndTmp = CreateWindow(
		"BUTTON", "Close",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*10, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_CLOSE, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));

	//{^ݒ̏󋵂\
	update_status();

	ShowWindow(_hWnd, SW_SHOWNORMAL);
	UpdateWindow(_hWnd);
	GetWindowRect(_hWnd, &rc);
	SetWindowPos(_hWnd, HWND_TOP, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, SWP_FRAMECHANGED);
	ImmAssociateContext(_hWnd, 0); //IME𖳌ɂ

	return TRUE;
}


BOOL
TURBOCONFIG_Init(
	HWND		hWnd,
	HINSTANCE	hInstance,
	Sint32	 	padID,
	Sint32*		setOk)
{
	if (_hInstance != NULL)
		TURBOCONFIG_Deinit();

	_hParentWnd = hWnd; //eEBhẼnh
	_hInstance = hInstance;

	_PadID	= padID;
	_pSetOk	= setOk;
	_SetOk	= -1; //LZ

	return turboconfig_main();
}


void
TURBOCONFIG_Deinit()
{
	if (_hInstance != NULL)
	{
		DestroyWindow(_hWnd);
		_hWnd = NULL;
		UnregisterClass(_pCaption, _hInstance);
		_hInstance = NULL;
		
		DeleteObject(_hFontB); //{^ptHgJ
		DeleteObject(_hMyBrush); //uVJ
		DeleteObject(_hEditBrush); //uVJ
		
		//CEBhEɃtH[JX߂OʂɁB
		EnableWindow(_hParentWnd, TRUE);
		SetForegroundWindow(_hParentWnd);
		
		*_pSetOk = _SetOk; //߂lݒB̏uԂKeyConfigEBhE͓oB
	}
}

